/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.certificatevalidation.crl;

import java.security.cert.X509CRL;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.commons.jmx.MBeanRegistrar;
import org.apache.synapse.transport.certificatevalidation.cache.CacheController;
import org.apache.synapse.transport.certificatevalidation.cache.CacheManager;
import org.apache.synapse.transport.certificatevalidation.cache.ManageableCache;
import org.apache.synapse.transport.certificatevalidation.cache.ManageableCacheValue;
import org.apache.synapse.transport.certificatevalidation.crl.CRLVerifier;

public class CRLCache
implements ManageableCache {
    private static volatile CRLCache cache;
    private static volatile Map<String, CRLCacheValue> hashMap;
    private static volatile Iterator<Map.Entry<String, CRLCacheValue>> iterator;
    private static volatile CacheManager cacheManager;
    private static CRLVerifier crlVerifier;
    private static final Log log;

    private CRLCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CRLCache getCache() {
        if (cache != null) return cache;
        Class<CRLCache> clazz = CRLCache.class;
        synchronized (CRLCache.class) {
            if (cache != null) return cache;
            cache = new CRLCache();
            // ** MonitorExit[var0] (shouldn't be in output)
            return cache;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void init(int size, int delay) {
        if (cacheManager != null) return;
        Class<CRLCache> clazz = CRLCache.class;
        synchronized (CRLCache.class) {
            if (cacheManager != null) return;
            cacheManager = new CacheManager(cache, size, delay);
            CacheController mbean = new CacheController(cache, cacheManager);
            MBeanRegistrar.getInstance().registerMBean((Object)mbean, "CacheController", "CRLCacheController");
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    @Override
    public synchronized ManageableCacheValue getNextCacheValue() {
        if (iterator.hasNext()) {
            return hashMap.get(iterator.next().getKey());
        }
        this.resetIterator();
        return null;
    }

    @Override
    public synchronized int getCacheSize() {
        return hashMap.size();
    }

    @Override
    public void resetIterator() {
        iterator = hashMap.entrySet().iterator();
    }

    private synchronized void replaceNewCacheValue(CRLCacheValue cacheValue) {
        if (cacheValue.isValid()) {
            return;
        }
        try {
            String crlUrl = cacheValue.crlUrl;
            X509CRL x509CRL = crlVerifier.downloadCRLFromWeb(crlUrl);
            this.setCacheValue(crlUrl, x509CRL);
        }
        catch (Exception e) {
            log.info((Object)"Cant replace old CacheValue with new CacheValue. So remove", (Throwable)e);
            cacheValue.removeThisCacheValue();
        }
    }

    public synchronized X509CRL getCacheValue(String crlUrl) {
        CRLCacheValue cacheValue = hashMap.get(crlUrl);
        if (cacheValue != null) {
            if (!cacheValue.isValid()) {
                cacheValue.updateCacheWithNewValue();
                CRLCacheValue crlCacheValue = hashMap.get(crlUrl);
                return crlCacheValue != null ? crlCacheValue.getValue() : null;
            }
            return cacheValue.getValue();
        }
        return null;
    }

    public synchronized void setCacheValue(String crlUrl, X509CRL crl) {
        CRLCacheValue cacheValue = new CRLCacheValue(crlUrl, crl);
        log.info((Object)("Before set- HashMap size " + hashMap.size()));
        hashMap.put(crlUrl, cacheValue);
        log.info((Object)("After set - HashMap size " + hashMap.size()));
    }

    public synchronized void removeCacheValue(String crlUrl) {
        log.info((Object)("Before remove - HashMap size " + hashMap.size()));
        hashMap.remove(crlUrl);
        log.info((Object)("After remove - HashMap size " + hashMap.size()));
    }

    static {
        hashMap = new ConcurrentHashMap<String, CRLCacheValue>();
        iterator = hashMap.entrySet().iterator();
        crlVerifier = new CRLVerifier(null);
        log = LogFactory.getLog(CRLCache.class);
    }

    private class CRLCacheValue
    implements ManageableCacheValue {
        private String crlUrl;
        private X509CRL crl;
        private long timeStamp = System.currentTimeMillis();

        public CRLCacheValue(String crlUrl, X509CRL crl) {
            this.crlUrl = crlUrl;
            this.crl = crl;
        }

        public String getKey() {
            return this.crlUrl;
        }

        public X509CRL getValue() {
            this.timeStamp = System.currentTimeMillis();
            return this.crl;
        }

        @Override
        public boolean isValid() {
            Date today = new Date();
            Date nextUpdate = this.crl.getNextUpdate();
            return nextUpdate != null && nextUpdate.after(today);
        }

        @Override
        public long getTimeStamp() {
            return this.timeStamp;
        }

        @Override
        public void removeThisCacheValue() {
            CRLCache.this.removeCacheValue(this.crlUrl);
        }

        @Override
        public void updateCacheWithNewValue() {
            CRLCache.this.replaceNewCacheValue(this);
        }
    }
}

