/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.certificatevalidation.cache;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.transport.certificatevalidation.cache.ManageableCache;
import org.apache.synapse.transport.certificatevalidation.cache.ManageableCacheValue;

public class CacheManager {
    private final boolean DO_NOT_INTERRUPT_IF_RUNNING = false;
    private ScheduledExecutorService scheduler;
    private ScheduledFuture scheduledFuture = null;
    private ManageableCache cache;
    private int cacheMaxSize;
    private int delay;
    private CacheManagingTask cacheManagingTask;
    private static final Log log = LogFactory.getLog(CacheManager.class);

    public CacheManager(ManageableCache cache, int cacheMaxSize, int delay) {
        int NUM_THREADS = 1;
        this.scheduler = Executors.newScheduledThreadPool(NUM_THREADS);
        this.cache = cache;
        this.cacheMaxSize = cacheMaxSize;
        this.cacheManagingTask = new CacheManagingTask();
        this.delay = delay;
        this.start();
    }

    private boolean start() {
        if (this.scheduledFuture == null || this.scheduledFuture.isCancelled()) {
            this.scheduledFuture = this.scheduler.scheduleWithFixedDelay(this.cacheManagingTask, this.delay, this.delay, TimeUnit.MINUTES);
            log.info((Object)(this.cache.getClass().getSimpleName() + " Cache Manager Started"));
            return true;
        }
        return false;
    }

    public boolean wakeUpNow() {
        if (this.scheduledFuture != null) {
            if (!this.scheduledFuture.isCancelled()) {
                this.scheduledFuture.cancel(false);
            }
            this.scheduledFuture = this.scheduler.scheduleWithFixedDelay(this.cacheManagingTask, 0L, this.delay, TimeUnit.MINUTES);
            log.info((Object)(this.cache.getClass().getSimpleName() + " Cache Manager Wakened Up....."));
            return true;
        }
        return false;
    }

    public boolean changeDelay(int delay) throws IllegalArgumentException {
        int min = 1;
        int max = 1440;
        if (delay < min || delay > max) {
            throw new IllegalArgumentException("Delay time should should be between " + min + " and " + max + " minutes");
        }
        this.delay = delay;
        return this.wakeUpNow();
    }

    public int getDelay() {
        return this.delay;
    }

    public boolean stop() {
        if (this.scheduledFuture != null && !this.scheduledFuture.isCancelled()) {
            this.scheduledFuture.cancel(false);
            log.info((Object)(this.cache.getClass().getSimpleName() + " Cache Manager Stopped....."));
            return true;
        }
        return false;
    }

    public boolean isRunning() {
        return !this.scheduledFuture.isCancelled();
    }

    private class CacheManagingTask
    implements Runnable {
        private CacheManagingTask() {
        }

        @Override
        public void run() {
            long start = System.currentTimeMillis();
            log.info((Object)(CacheManager.this.cache.getClass().getSimpleName() + " Cache Manager Task Started."));
            int cacheSize = CacheManager.this.cache.getCacheSize();
            int numberToRemove = cacheSize > CacheManager.this.cacheMaxSize ? cacheSize - CacheManager.this.cacheMaxSize : 0;
            ArrayList<ManageableCacheValue> entriesToRemove = new ArrayList<ManageableCacheValue>();
            LRUEntryCollector lruEntryCollector = new LRUEntryCollector(entriesToRemove, numberToRemove);
            CacheManager.this.cache.resetIterator();
            while (cacheSize-- > 0) {
                ManageableCacheValue nextCacheValue = CacheManager.this.cache.getNextCacheValue();
                if (nextCacheValue == null) {
                    log.info((Object)"Cache manager iteration through Cache values done");
                    break;
                }
                if (!nextCacheValue.isValid()) {
                    log.info((Object)"Updating Invalid Cache Value by Manager");
                    nextCacheValue.updateCacheWithNewValue();
                }
                if (numberToRemove <= 0) continue;
                lruEntryCollector.collectEntriesToRemove(nextCacheValue);
            }
            for (ManageableCacheValue oldCacheValue : entriesToRemove) {
                log.info((Object)"Removing LRU value from cache");
                oldCacheValue.removeThisCacheValue();
            }
            log.info((Object)(CacheManager.this.cache.getClass().getSimpleName() + " Cache Manager Task Done. Took " + (System.currentTimeMillis() - start) + " ms."));
        }

        private class LRUEntryCollector {
            private List<ManageableCacheValue> entriesToRemove;
            private int listMaxSize;

            LRUEntryCollector(List<ManageableCacheValue> entriesToRemove, int numberToRemove) {
                this.entriesToRemove = entriesToRemove;
                this.listMaxSize = numberToRemove;
            }

            private void collectEntriesToRemove(ManageableCacheValue value) {
                int i;
                int j;
                this.entriesToRemove.add(value);
                for (j = i = this.entriesToRemove.size() - 1; j > 0 && value.getTimeStamp() < this.entriesToRemove.get(j - 1).getTimeStamp(); --j) {
                    this.entriesToRemove.remove(j);
                    this.entriesToRemove.add(j, this.entriesToRemove.get(j - 1));
                }
                this.entriesToRemove.remove(j);
                this.entriesToRemove.add(j, value);
                if (this.entriesToRemove.size() > this.listMaxSize) {
                    this.entriesToRemove.remove(this.entriesToRemove.size() - 1);
                }
            }
        }
    }
}

