/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.extension.time;

import java.text.ParseException;
import java.util.Date;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.log4j.Logger;
import org.wso2.siddhi.core.config.ExecutionPlanContext;
import org.wso2.siddhi.core.exception.ExecutionPlanRuntimeException;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.executor.function.FunctionExecutor;
import org.wso2.siddhi.query.api.definition.Attribute;
import org.wso2.siddhi.query.api.exception.ExecutionPlanValidationException;

public class TimestampInMillisecondsFunctionExtension
extends FunctionExecutor {
    private static final Logger log = Logger.getLogger(TimestampInMillisecondsFunctionExtension.class);
    private Attribute.Type returnType = Attribute.Type.LONG;
    private boolean useDefaultDateFormat = false;
    private String dateFormat = null;

    protected void init(ExpressionExecutor[] attributeExpressionExecutors, ExecutionPlanContext executionPlanContext) {
        if (attributeExpressionExecutors.length > 0) {
            if (attributeExpressionExecutors.length == 2) {
                if (attributeExpressionExecutors[0].getReturnType() != Attribute.Type.STRING) {
                    throw new ExecutionPlanValidationException("Invalid parameter type found for the first argument of time:timestampInMilliseconds(dateValue,dateFormat) function,required " + Attribute.Type.STRING + " but found " + attributeExpressionExecutors[0].getReturnType().toString());
                }
                if (attributeExpressionExecutors[1].getReturnType() != Attribute.Type.STRING) {
                    throw new ExecutionPlanValidationException("Invalid parameter type found for the second argument of time:timestampInMilliseconds(dateValue,dateFormat) function, required " + Attribute.Type.STRING + " but found " + attributeExpressionExecutors[1].getReturnType().toString());
                }
            } else if (attributeExpressionExecutors.length == 1) {
                if (attributeExpressionExecutors[0].getReturnType() != Attribute.Type.STRING) {
                    throw new ExecutionPlanValidationException("Invalid parameter type found for the first argument of time:timestampInMilliseconds(dateValue,dateFormat) function, required " + Attribute.Type.STRING + "but found " + attributeExpressionExecutors[0].getReturnType().toString());
                }
                this.useDefaultDateFormat = true;
                this.dateFormat = "yyyy-MM-dd HH:mm:ss.SSS";
            } else {
                throw new ExecutionPlanValidationException("Invalid no of arguments passed to time:timestampInMilliseconds(dateValue,dateFormat) function, required 2, but found " + attributeExpressionExecutors.length);
            }
        }
    }

    protected Object execute(Object[] data) {
        if (data.length == 2) {
            long returnValue;
            if (data[0] == null) {
                throw new ExecutionPlanRuntimeException("Invalid input given to time:timestampInMilliseconds(dateValue,dateFormat) function. First argument cannot be null");
            }
            if (!this.useDefaultDateFormat) {
                if (data[1] == null) {
                    throw new ExecutionPlanRuntimeException("Invalid input given to time:timestampInMilliseconds(dateValue,dateFormat) function. First argument cannot be null");
                }
                this.dateFormat = (String)data[1];
            }
            String source = (String)data[0];
            FastDateFormat userSpecificFormat = FastDateFormat.getInstance((String)this.dateFormat);
            try {
                Date date = userSpecificFormat.parse(source);
                returnValue = date.getTime();
            }
            catch (ParseException e) {
                String errorMsg = "Provided format " + this.dateFormat + " does not match with the timestamp " + source + e.getMessage();
                throw new ExecutionPlanRuntimeException(errorMsg, (Throwable)e);
            }
            return returnValue;
        }
        throw new ExecutionPlanRuntimeException("Invalid set of arguments" + data.length + " given to time:timestampInMilliseconds(dateValue,dateFormat) function. Only two arguments can be provided. ");
    }

    protected Object execute(Object data) {
        long returnValue;
        if (data == null) {
            return System.currentTimeMillis();
        }
        String source = (String)data;
        FastDateFormat userSpecificFormat = FastDateFormat.getInstance((String)this.dateFormat);
        try {
            Date date = userSpecificFormat.parse(source);
            returnValue = date.getTime();
        }
        catch (ParseException e) {
            String errorMsg = "Provided format " + this.dateFormat + " does not match with the timestamp " + source + e.getMessage();
            throw new ExecutionPlanRuntimeException(errorMsg, (Throwable)e);
        }
        return returnValue;
    }

    public void start() {
    }

    public void stop() {
    }

    public Attribute.Type getReturnType() {
        return this.returnType;
    }

    public Object[] currentState() {
        return new Object[0];
    }

    public void restoreState(Object[] state) {
    }
}

