/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.extension.time;

import java.text.ParseException;
import java.util.Date;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.log4j.Logger;
import org.wso2.siddhi.core.config.ExecutionPlanContext;
import org.wso2.siddhi.core.exception.ExecutionPlanRuntimeException;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.executor.function.FunctionExecutor;
import org.wso2.siddhi.query.api.definition.Attribute;
import org.wso2.siddhi.query.api.exception.ExecutionPlanValidationException;

public class ExtractDateFunctionExtension
extends FunctionExecutor {
    private static final Logger log = Logger.getLogger(ExtractDateFunctionExtension.class);
    private Attribute.Type returnType = Attribute.Type.STRING;

    protected void init(ExpressionExecutor[] attributeExpressionExecutors, ExecutionPlanContext executionPlanContext) {
        if (attributeExpressionExecutors.length > 2) {
            throw new ExecutionPlanValidationException("Invalid no of arguments passed to time:date(dateValue,dateFormat) function, required 2, but found " + attributeExpressionExecutors.length);
        }
        if (attributeExpressionExecutors[0].getReturnType() != Attribute.Type.STRING) {
            throw new ExecutionPlanValidationException("Invalid parameter type found for the first argument of time:date(dateValue,dateFormat) function, required " + Attribute.Type.STRING + " but found " + attributeExpressionExecutors[0].getReturnType().toString());
        }
        if (attributeExpressionExecutors.length > 0 && attributeExpressionExecutors[1].getReturnType() != Attribute.Type.STRING) {
            throw new ExecutionPlanValidationException("Invalid parameter type found for the second argument of time:date(dateValue,dateFormat) function, required " + Attribute.Type.STRING + " but found " + attributeExpressionExecutors[1].getReturnType().toString());
        }
    }

    protected Object execute(Object[] data) {
        String userFormat;
        if (data[0] == null) {
            throw new ExecutionPlanRuntimeException("Invalid input given to time:date(dateValue,dateFormat) function. First argument cannot be null");
        }
        if (data.length > 0) {
            if (data[1] == null) {
                throw new ExecutionPlanRuntimeException("Invalid input given to time:date(dateValue,dateFormat) function. Second argument cannot be null");
            }
            userFormat = (String)data[1];
        } else {
            userFormat = "yyyy-MM-dd HH:mm:ss.SSS";
        }
        String source = null;
        try {
            source = (String)data[0];
            FastDateFormat userSpecificFormat = FastDateFormat.getInstance((String)userFormat);
            Date userSpecifiedDate = userSpecificFormat.parse(source);
            FastDateFormat dataFormat = FastDateFormat.getInstance((String)"yyyy-MM-dd");
            return dataFormat.format(userSpecifiedDate);
        }
        catch (ParseException e) {
            String errorMsg = "Provided format " + userFormat + " does not match with the timestamp " + source + e.getMessage();
            throw new ExecutionPlanRuntimeException(errorMsg, (Throwable)e);
        }
        catch (ClassCastException e) {
            String errorMsg = "Provided Data type cannot be cast to desired format. " + e.getMessage();
            throw new ExecutionPlanRuntimeException(errorMsg, (Throwable)e);
        }
    }

    protected Object execute(Object data) {
        return null;
    }

    public void start() {
    }

    public void stop() {
    }

    public Attribute.Type getReturnType() {
        return this.returnType;
    }

    public Object[] currentState() {
        return new Object[0];
    }

    public void restoreState(Object[] state) {
    }
}

