/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.simulator.ui.fileupload;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Map;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.CarbonException;
import org.wso2.carbon.event.simulator.ui.EventSimulatorUIUtils;
import org.wso2.carbon.event.simulator.ui.fileupload.CSVUploaderClient;
import org.wso2.carbon.ui.CarbonUIMessage;
import org.wso2.carbon.ui.transports.fileupload.AbstractFileUploadExecutor;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.FileItemData;

public class CSVUploadExecutor
extends AbstractFileUploadExecutor {
    private static Log log = LogFactory.getLog(CSVUploadExecutor.class);
    private static final String[] ALLOWED_FILE_EXTENSIONS = new String[]{".csv"};

    public boolean execute(HttpServletRequest request, HttpServletResponse response) throws CarbonException, IOException {
        response.setContentType("text/html; charset=utf-8");
        PrintWriter out = response.getWriter();
        String webContext = (String)request.getAttribute("WebContext");
        String serverURL = (String)request.getAttribute("ServerURL");
        String cookie = (String)request.getAttribute("wso2carbon.admin.service.cookie");
        Map fileItemsMap = this.getFileItemsMap();
        if (fileItemsMap == null || fileItemsMap.isEmpty()) {
            String msg = "File uploading failed.";
            log.error((Object)msg);
            out.write("<textarea>(function(){i18n.fileUplodedFailed();})();</textarea>");
            return true;
        }
        CSVUploaderClient uploaderClient = new CSVUploaderClient(this.configurationContext, serverURL + "EventSimulatorAdminService.EventSimulatorAdminServiceHttpsSoap12Endpoint", cookie);
        try {
            for (FileItemData fileData : (ArrayList)fileItemsMap.get("csvFileName")) {
                String fileName = this.getFileName(fileData.getFileItem().getName());
                if (fileName.matches("(.*[\\\\].*[/].*|.*[/].*[\\\\].*)")) {
                    log.error((Object)"CSV file Validation Failure: one or more of the following illegal characters are in the package.\n ~!@#$;%^*()+={}[]| \\<>");
                    throw new Exception("CSV file Validation Failure: one or more of the following illegal characters are in the package. ~!@#$;%^*()+={}[]| \\<>");
                }
                this.checkServiceFileExtensionValidity(fileName, ALLOWED_FILE_EXTENSIONS);
                if (fileName.lastIndexOf(92) != -1) {
                    int indexOfColon = fileName.lastIndexOf(92) + 1;
                    fileName = fileName.substring(indexOfColon, fileName.length());
                }
                if (!fileData.getFileItem().getFieldName().equals("csvFileName")) continue;
                EventSimulatorUIUtils.validatePath(fileName);
                File uploadedTempFile = new File(CarbonUtils.getTmpDir(), fileName);
                fileData.getFileItem().write(uploadedTempFile);
                FileDataSource dataSource = new FileDataSource(uploadedTempFile);
                uploaderClient.addUploadedFileItem(new DataHandler((DataSource)dataSource), fileName, "csv");
            }
            uploaderClient.uploadFileItems();
            String msg = "Your CSV file has been uploaded successfully. Please refresh this page to configure and play the file";
            CarbonUIMessage.sendCarbonUIMessage((String)msg, (String)"info", (HttpServletRequest)request, (HttpServletResponse)response, (String)(this.getContextRoot(request) + "/" + webContext + "/eventsimulator/index.jsp"));
            return true;
        }
        catch (Exception e) {
            String errMsg = "File upload failed :" + e.getMessage();
            log.error((Object)errMsg, (Throwable)e);
            CarbonUIMessage.sendCarbonUIMessage((String)errMsg, (String)"error", (HttpServletRequest)request, (HttpServletResponse)response, (String)(this.getContextRoot(request) + "/" + webContext + "/eventsimulator/index.jsp"));
            return false;
        }
    }
}

