/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.andes.authentication.internal;

import java.util.UUID;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.andes.configuration.AndesConfigurationManager;
import org.wso2.andes.kernel.AndesException;
import org.wso2.carbon.andes.authentication.andes.oauth.config.OAuthConfigurationManager;
import org.wso2.carbon.andes.authentication.internal.AuthenticationServiceDataHolder;
import org.wso2.carbon.andes.authentication.service.AuthenticationService;
import org.wso2.carbon.andes.authentication.service.AuthenticationServiceImpl;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.base.api.ServerConfigurationService;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.user.core.service.RealmService;

@Component(name="org.wso2.carbon.andes.authentication.internal.AuthenticationServiceComponent", immediate=true)
public class AuthenticationServiceComponent {
    private ServiceRegistration authenticationService = null;
    private static final String CARBON_CONFIG_PORT_OFFSET = "Ports.Offset";
    private static final int CARBON_DEFAULT_PORT_OFFSET = 0;

    @Activate
    protected void activate(ComponentContext ctx) throws AndesException {
        AndesConfigurationManager.initialize((int)this.getPortOffset());
        OAuthConfigurationManager.getInstance().initConfig();
        String accessKey = UUID.randomUUID().toString();
        AuthenticationServiceDataHolder.getInstance().setAccessKey(accessKey);
        this.authenticationService = ctx.getBundleContext().registerService(AuthenticationService.class.getName(), (Object)new AuthenticationServiceImpl(accessKey), null);
    }

    @Deactivate
    protected void deactivate(ComponentContext ctx) {
        if (null != this.authenticationService) {
            this.authenticationService.unregister();
        }
    }

    @Reference(name="registry.service", service=RegistryService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRegistryService")
    protected void setRegistryService(RegistryService registryService) {
        AuthenticationServiceDataHolder.getInstance().setRegistryService(registryService);
    }

    protected void unsetRegistryService(RegistryService registryService) {
        AuthenticationServiceDataHolder.getInstance().setRegistryService(null);
    }

    @Reference(name="realm.service", service=RealmService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRealmService")
    protected void setRealmService(RealmService realmService) {
        AuthenticationServiceDataHolder.getInstance().setRealmService(realmService);
    }

    protected void unsetRealmService(RealmService realmService) {
        AuthenticationServiceDataHolder.getInstance().setRealmService(null);
    }

    @Reference(name="server.configuration", service=ServerConfigurationService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetServerConfiguration")
    protected void setServerConfiguration(ServerConfigurationService serverConfiguration) {
    }

    protected void unsetServerConfiguration(ServerConfigurationService serverConfiguration) {
    }

    private int getPortOffset() {
        ServerConfiguration carbonConfig = ServerConfiguration.getInstance();
        String portOffset = System.getProperty("portOffset", carbonConfig.getFirstProperty(CARBON_CONFIG_PORT_OFFSET));
        try {
            if (portOffset != null) {
                return Integer.parseInt(portOffset.trim());
            }
            return 0;
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }
}

