/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.andes.authentication.andes.oauth.config;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.andes.configuration.AndesConfigurationManager;
import org.wso2.andes.configuration.enums.AndesConfiguration;
import org.wso2.andes.configuration.modules.JKSStore;
import org.wso2.andes.configuration.util.ConfigurationProperty;
import org.wso2.andes.kernel.AndesException;

public class OAuthConfigurationManager {
    private static final Log log = LogFactory.getLog(OAuthConfigurationManager.class);
    private URL hostUrl;
    private String username;
    private String password;
    private JKSStore jksKeyStore;
    private JKSStore jksTrustStore;
    private int maximumTotalHttpConnection;
    private int maximumHttpConnectionPerHost;
    private static final String USERNAME_KEY = "username";
    private static final String PASSWORD_KEY = "password";
    private static final String HOST_URL_KEY = "hostURL";
    private static final String MAX_CONNECTION_KEY = "maxConnectionsPerHost";
    private static final String TOTAL_CONNECTION_KEY = "maxTotalConnections";
    private static final int DEFAULT_CONNECTION_PER_HOST = 2;
    private static final int DEFAULT_TOTAL_CONNECTION = 100;
    private static final OAuthConfigurationManager oAuthConfigurationManager = new OAuthConfigurationManager();

    public static OAuthConfigurationManager getInstance() {
        return oAuthConfigurationManager;
    }

    private OAuthConfigurationManager() {
    }

    public synchronized void initConfig() throws AndesException {
        this.jksKeyStore = (JKSStore)AndesConfigurationManager.readValue((ConfigurationProperty)AndesConfiguration.TRANSPORTS_MQTT_SSL_CONNECTION_KEYSTORE);
        this.jksTrustStore = (JKSStore)AndesConfigurationManager.readValue((ConfigurationProperty)AndesConfiguration.TRANSPORTS_MQTT_SSL_CONNECTION_TRUSTSTORE);
        List mqttTranportProperties = AndesConfigurationManager.readValueList((AndesConfiguration)AndesConfiguration.LIST_TRANSPORT_MQTT_AUTHENTICATION_PROPERTIES);
        for (String property : mqttTranportProperties) {
            String propertyValue = (String)AndesConfigurationManager.readValueOfChildByKey((AndesConfiguration)AndesConfiguration.TRANSPORT_MQTT_AUTHENTICATION_PROPERTIES, (String)property);
            switch (property) {
                case "hostURL": {
                    this.setHostUrl(propertyValue);
                    break;
                }
                case "username": {
                    this.setUsername(propertyValue);
                    break;
                }
                case "password": {
                    this.setPassword(propertyValue);
                    break;
                }
                case "maxConnectionsPerHost": {
                    this.setMaximumHttpConnectionPerHost(propertyValue);
                    break;
                }
                case "maxTotalConnections": {
                    this.setMaximumTotalHttpConnection(propertyValue);
                }
            }
        }
    }

    public URL getHostUrl() {
        return this.hostUrl;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public JKSStore getJksKeyStore() {
        return this.jksKeyStore;
    }

    public int getMaximumTotalHttpConnection() {
        return this.maximumTotalHttpConnection;
    }

    public int getMaximumHttpConnectionPerHost() {
        return this.maximumHttpConnectionPerHost;
    }

    private void setHostUrl(String hostUrlString) throws AndesException {
        try {
            this.hostUrl = new URL(hostUrlString);
        }
        catch (NullPointerException | MalformedURLException e) {
            String errorMsg = "invalid token endpoint URL " + hostUrlString;
            log.error((Object)errorMsg);
            throw new AndesException(errorMsg);
        }
    }

    private void setUsername(String username) throws AndesException {
        if (username == null || username.isEmpty()) {
            String errorMsg = "invalid username " + username;
            log.error((Object)errorMsg);
            throw new AndesException(errorMsg);
        }
        this.username = username;
    }

    private void setPassword(String password) throws AndesException {
        if (password == null || password.isEmpty()) {
            String errorMsg = "invalid password " + password;
            log.error((Object)errorMsg);
            throw new AndesException(errorMsg);
        }
        this.password = password;
    }

    private void setMaximumTotalHttpConnection(String maximumTotalConnectionString) {
        try {
            this.maximumTotalHttpConnection = Integer.parseInt(maximumTotalConnectionString);
        }
        catch (NullPointerException | NumberFormatException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("maximum total connection is " + maximumTotalConnectionString + " therefore set to the default value"));
            }
            this.maximumTotalHttpConnection = 100;
        }
    }

    private void setMaximumHttpConnectionPerHost(String maximumConnectionPerHostString) {
        try {
            this.maximumHttpConnectionPerHost = Integer.parseInt(maximumConnectionPerHostString);
        }
        catch (NumberFormatException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("maximum connection per host is " + maximumConnectionPerHostString + " therefore set to the default value"));
            }
            this.maximumHttpConnectionPerHost = 2;
        }
    }
}

