/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.andes.authentication.andes.oauth;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.security.GeneralSecurityException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.transport.http.HttpTransportProperties;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.contrib.ssl.EasySSLProtocolSocketFactory;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.pool.BasePoolableObjectFactory;
import org.apache.commons.ssl.KeyMaterial;
import org.wso2.andes.configuration.modules.JKSStore;
import org.wso2.carbon.andes.authentication.andes.oauth.config.OAuthConfigurationManager;
import org.wso2.carbon.andes.authentication.andes.oauth.exception.OAuthTokenValidationException;
import org.wso2.carbon.identity.oauth2.stub.OAuth2TokenValidationServiceStub;

public class OAuthTokenValidaterStubFactory
extends BasePoolableObjectFactory {
    private static final Log log = LogFactory.getLog(OAuthTokenValidaterStubFactory.class);
    OAuthConfigurationManager config = OAuthConfigurationManager.getInstance();
    private HttpClient httpClient = this.createHttpClient();

    public Object makeObject() throws Exception {
        return this.generateStub();
    }

    public void passivateObject(Object o) throws Exception {
        if (o instanceof OAuth2TokenValidationServiceStub) {
            OAuth2TokenValidationServiceStub stub = (OAuth2TokenValidationServiceStub)o;
            stub._getServiceClient().cleanupTransport();
        }
    }

    private OAuth2TokenValidationServiceStub generateStub() throws OAuthTokenValidationException {
        OAuth2TokenValidationServiceStub stub;
        block5: {
            URL hostURL = this.config.getHostUrl();
            try {
                if (hostURL != null) {
                    stub = new OAuth2TokenValidationServiceStub(hostURL.toString());
                    if (stub != null) {
                        ServiceClient client = stub._getServiceClient();
                        client.getServiceContext().getConfigurationContext().setProperty("CACHED_HTTP_CLIENT", (Object)this.httpClient);
                        HttpTransportProperties.Authenticator auth = new HttpTransportProperties.Authenticator();
                        auth.setPreemptiveAuthentication(true);
                        String username = this.config.getUsername();
                        String password = this.config.getPassword();
                        auth.setUsername(username);
                        auth.setPassword(password);
                        Options options = client.getOptions();
                        options.setProperty("_NTLM_DIGEST_BASIC_AUTHENTICATION_", (Object)auth);
                        options.setProperty("REUSE_HTTP_CLIENT", (Object)"true");
                        client.setOptions(options);
                        if (hostURL.getProtocol().equals("https")) {
                            EasySSLProtocolSocketFactory sslProtocolSocketFactory = this.createProtocolSocketFactory();
                            Protocol authhttps = new Protocol(hostURL.getProtocol(), (ProtocolSocketFactory)sslProtocolSocketFactory, hostURL.getPort());
                            Protocol.registerProtocol((String)hostURL.getProtocol(), (Protocol)authhttps);
                            options.setProperty("CUSTOM_PROTOCOL_HANDLER", (Object)authhttps);
                        }
                        break block5;
                    }
                    String errorMsg = "OAuth Validation instanization failed.";
                    throw new OAuthTokenValidationException(errorMsg);
                }
                String errorMsg = "host url is invalid";
                throw new OAuthTokenValidationException(errorMsg);
            }
            catch (AxisFault axisFault) {
                throw new OAuthTokenValidationException("Error occurred while creating the OAuth2TokenValidationServiceStub.", (Exception)((Object)axisFault));
            }
        }
        return stub;
    }

    private EasySSLProtocolSocketFactory createProtocolSocketFactory() throws OAuthTokenValidationException {
        try {
            EasySSLProtocolSocketFactory easySSLPSFactory = new EasySSLProtocolSocketFactory();
            JKSStore jksKeyStore = OAuthConfigurationManager.getInstance().getJksKeyStore();
            String keyStoreLocation = jksKeyStore.getStoreLocation();
            char[] password = jksKeyStore.getPassword().toCharArray();
            File keyStoreFile = new File(keyStoreLocation);
            if (keyStoreFile.exists()) {
                KeyMaterial km = new KeyMaterial(keyStoreLocation, password);
                easySSLPSFactory.setKeyMaterial(km);
                return easySSLPSFactory;
            }
            String errorMsg = "Unable to load Keystore from the following location: " + keyStoreLocation;
            throw new OAuthTokenValidationException(errorMsg);
        }
        catch (IOException e) {
            String errorMsg = "Failed to initiate EasySSLProtocolSocketFactory.";
            throw new OAuthTokenValidationException(errorMsg, e);
        }
        catch (GeneralSecurityException e) {
            String errorMsg = "Failed to set the key material in easy ssl factory.";
            throw new OAuthTokenValidationException(errorMsg, e);
        }
    }

    private HttpClient createHttpClient() {
        HttpConnectionManagerParams params = new HttpConnectionManagerParams();
        params.setDefaultMaxConnectionsPerHost(this.config.getMaximumHttpConnectionPerHost());
        params.setMaxTotalConnections(this.config.getMaximumTotalHttpConnection());
        MultiThreadedHttpConnectionManager connectionManager = new MultiThreadedHttpConnectionManager();
        connectionManager.setParams(params);
        return new HttpClient((HttpConnectionManager)connectionManager);
    }
}

