/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.andes.authentication.andes;

import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.List;
import org.apache.axis2.context.ServiceContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.dna.mqtt.moquette.server.AuthenticationInfo;
import org.dna.mqtt.moquette.server.IAuthenticator;
import org.wso2.carbon.andes.authentication.andes.oauth.OAuthTokenValidaterStubFactory;
import org.wso2.carbon.identity.oauth2.stub.OAuth2TokenValidationServiceStub;
import org.wso2.carbon.identity.oauth2.stub.dto.OAuth2TokenValidationRequestDTO;
import org.wso2.carbon.identity.oauth2.stub.dto.OAuth2TokenValidationRequestDTO_OAuth2AccessToken;
import org.wso2.carbon.identity.oauth2.stub.dto.OAuth2TokenValidationResponseDTO;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class OAuth2BasedMQTTAuthenticator
implements IAuthenticator {
    private static final Log log = LogFactory.getLog(OAuth2BasedMQTTAuthenticator.class);
    private static final String TOKEN_TYPE = "bearer";
    private static final String SCOPE_IDENTIFIER = "scope";
    private static final String TOKEN_EXPIRY_TIME_IDENTIFIER = "expiry_time";
    private static String cookie;
    private GenericObjectPool stubs = new GenericObjectPool((PoolableObjectFactory)new OAuthTokenValidaterStubFactory());

    public AuthenticationInfo checkValid(String token, String unusedParameter) {
        return this.validateToken(token);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AuthenticationInfo validateToken(String token) {
        OAuth2TokenValidationServiceStub tokenValidationServiceStub = null;
        try {
            Object stub = this.stubs.borrowObject();
            if (stub != null) {
                tokenValidationServiceStub = (OAuth2TokenValidationServiceStub)stub;
                if (cookie != null) {
                    tokenValidationServiceStub._getServiceClient().getOptions().setProperty("Cookie", (Object)cookie);
                }
                AuthenticationInfo authenticationInfo = this.getAuthenticationInfo(token, tokenValidationServiceStub);
                return authenticationInfo;
            }
            log.warn((Object)"Stub initialization failed.");
        }
        catch (RemoteException e) {
            log.error((Object)"Error on connecting with the validation endpoint.", (Throwable)e);
        }
        catch (Exception e) {
            log.error((Object)"Error occurred in borrowing an validation stub from the pool.", (Throwable)e);
        }
        finally {
            try {
                if (tokenValidationServiceStub != null) {
                    this.stubs.returnObject((Object)tokenValidationServiceStub);
                }
            }
            catch (Exception e) {
                log.warn((Object)"Error occurred while returning the object back to the oauth token validation service stub pool.", (Throwable)e);
            }
        }
        AuthenticationInfo authenticationInfo = new AuthenticationInfo();
        authenticationInfo.setAuthenticated(false);
        return authenticationInfo;
    }

    private AuthenticationInfo getAuthenticationInfo(String token, OAuth2TokenValidationServiceStub tokenValidationServiceStub) throws RemoteException {
        AuthenticationInfo authenticationInfo = new AuthenticationInfo();
        OAuth2TokenValidationRequestDTO validationRequest = new OAuth2TokenValidationRequestDTO();
        OAuth2TokenValidationRequestDTO_OAuth2AccessToken accessToken = new OAuth2TokenValidationRequestDTO_OAuth2AccessToken();
        accessToken.setTokenType(TOKEN_TYPE);
        accessToken.setIdentifier(token);
        validationRequest.setAccessToken(accessToken);
        OAuth2TokenValidationResponseDTO tokenValidationResponse = tokenValidationServiceStub.validate(validationRequest);
        if (tokenValidationResponse == null) {
            authenticationInfo.setAuthenticated(false);
            return authenticationInfo;
        }
        boolean authenticated = tokenValidationResponse.getValid();
        if (authenticated) {
            String authorizedUser = tokenValidationResponse.getAuthorizedUser();
            String username = MultitenantUtils.getTenantAwareUsername((String)authorizedUser);
            String tenantDomain = MultitenantUtils.getTenantDomain((String)authorizedUser);
            authenticationInfo.setUsername(username);
            authenticationInfo.setTenantDomain(tenantDomain);
            authenticationInfo.setProperty(TOKEN_EXPIRY_TIME_IDENTIFIER, (Object)tokenValidationResponse.getExpiryTime());
            String[] validateResponseScope = tokenValidationResponse.getScope();
            if (validateResponseScope != null && validateResponseScope.length > 0) {
                List<String> responseScopes = Arrays.asList(validateResponseScope);
                authenticationInfo.setProperty(SCOPE_IDENTIFIER, responseScopes);
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("Token validation failed for token: " + token));
        }
        ServiceContext serviceContext = tokenValidationServiceStub._getServiceClient().getLastOperationContext().getServiceContext();
        cookie = (String)serviceContext.getProperty("Cookie");
        authenticationInfo.setAuthenticated(authenticated);
        return authenticationInfo;
    }
}

