/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.andes.authentication.andes;

import java.io.IOException;
import java.security.Principal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.AccountNotFoundException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.andes.server.security.auth.database.PrincipalDatabase;
import org.wso2.andes.server.security.auth.sasl.AuthenticationProviderInitialiser;
import org.wso2.andes.server.security.auth.sasl.UsernamePrincipal;
import org.wso2.andes.server.security.auth.sasl.plain.PlainInitialiser;
import org.wso2.andes.server.security.auth.sasl.plain.PlainPasswordCallback;
import org.wso2.carbon.andes.authentication.internal.AuthenticationServiceDataHolder;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.user.api.UserRealm;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.core.service.RealmService;

public class CarbonBasedPrincipalDatabase
implements PrincipalDatabase {
    private static final String DOMAIN_NAME_SEPARATOR = "!";
    private static final Log logger = LogFactory.getLog(CarbonBasedPrincipalDatabase.class);
    private Map<String, AuthenticationProviderInitialiser> saslServers = new HashMap<String, AuthenticationProviderInitialiser>();

    public CarbonBasedPrincipalDatabase() {
        PlainInitialiser plain = new PlainInitialiser();
        plain.initialise((PrincipalDatabase)this);
        this.saslServers.put(plain.getMechanismName(), (AuthenticationProviderInitialiser)plain);
    }

    public Map<String, AuthenticationProviderInitialiser> getMechanisms() {
        return this.saslServers;
    }

    public List<Principal> getUsers() {
        return null;
    }

    public boolean deletePrincipal(Principal principal) throws AccountNotFoundException {
        return true;
    }

    public Principal getUser(String username) {
        UsernamePrincipal user = null;
        try {
            UserRealm userRealm = this.getUserRealm(username);
            if (null != userRealm && userRealm.getUserStoreManager().isExistingUser(username)) {
                user = new UsernamePrincipal(username);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Error while retrieving RegistryService.", (Throwable)e);
        }
        return user;
    }

    public boolean verifyPassword(String principal, char[] password) throws AccountNotFoundException {
        return true;
    }

    public boolean updatePassword(Principal principal, char[] password) throws AccountNotFoundException {
        return true;
    }

    public boolean createPrincipal(Principal principal, char[] password) {
        return true;
    }

    public void reload() throws IOException {
    }

    public void setPassword(Principal principal, PasswordCallback passwordCallback) throws IOException, AccountNotFoundException {
        try {
            if (principal == null) {
                throw new IllegalArgumentException("Principal should never be null");
            }
            String username = principal.getName();
            String password = ((PlainPasswordCallback)passwordCallback).getPlainPassword();
            String domainName = null;
            boolean isAuthenticated = false;
            if (password.equals(AuthenticationServiceDataHolder.getInstance().getAccessKey())) {
                isAuthenticated = true;
            } else {
                UserRealm userRealm = this.getUserRealm(username);
                if (null == userRealm) {
                    throw new AccountNotFoundException("Invalid User : " + principal);
                }
                int domainNameSeparatorIndex = username.lastIndexOf(DOMAIN_NAME_SEPARATOR);
                if (-1 != domainNameSeparatorIndex) {
                    domainName = username.substring(domainNameSeparatorIndex + 1);
                    username = username.substring(0, domainNameSeparatorIndex).replaceAll(DOMAIN_NAME_SEPARATOR, "@");
                }
                if (!userRealm.getUserStoreManager().isExistingUser(username)) {
                    throw new AccountNotFoundException("Invalid User : " + principal);
                }
                isAuthenticated = userRealm.getUserStoreManager().authenticate(username, (Object)password);
                if (isAuthenticated && -1 != domainNameSeparatorIndex) {
                    RealmService realmService = AuthenticationServiceDataHolder.getInstance().getRealmService();
                    int tenantID = realmService.getTenantManager().getTenantId(domainName);
                    PrivilegedCarbonContext.destroyCurrentContext();
                    PrivilegedCarbonContext cc = PrivilegedCarbonContext.getThreadLocalCarbonContext();
                    cc.setTenantDomain(domainName);
                    cc.setTenantId(tenantID);
                }
            }
            ((PlainPasswordCallback)passwordCallback).setAuthenticated(isAuthenticated);
        }
        catch (UserStoreException e) {
            logger.error((Object)"User not authenticated.", (Throwable)e);
        }
        catch (NullPointerException e) {
            logger.error((Object)"Error while authenticating.", (Throwable)e);
        }
    }

    public void setPasswordFile(String passwordFile) {
    }

    private UserRealm getUserRealm(String username) {
        UserRealm userRealm = null;
        RealmService realmService = AuthenticationServiceDataHolder.getInstance().getRealmService();
        if (null != realmService) {
            try {
                int tenantID = -1234;
                int domainNameSeparatorIndex = username.lastIndexOf(DOMAIN_NAME_SEPARATOR);
                PrivilegedCarbonContext.destroyCurrentContext();
                PrivilegedCarbonContext cc = PrivilegedCarbonContext.getThreadLocalCarbonContext();
                cc.setTenantDomain("carbon.super");
                cc.setTenantId(tenantID);
                if (-1 != domainNameSeparatorIndex) {
                    String domainName = username.substring(domainNameSeparatorIndex + 1);
                    tenantID = realmService.getTenantManager().getTenantId(domainName);
                }
                userRealm = realmService.getTenantUserRealm(tenantID);
            }
            catch (UserStoreException e) {
                logger.error((Object)("Error while getting tenant user realm for user " + username), (Throwable)e);
            }
        }
        return userRealm;
    }
}

