/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.andes.authentication.andes;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dna.mqtt.moquette.server.AuthenticationInfo;
import org.dna.mqtt.moquette.server.IAuthenticator;
import org.wso2.carbon.andes.authentication.internal.AuthenticationServiceDataHolder;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.user.api.UserRealm;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.api.UserStoreManager;
import org.wso2.carbon.user.core.tenant.TenantManager;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class CarbonBasedMQTTAuthenticator
implements IAuthenticator {
    private static final Log logger = LogFactory.getLog(CarbonBasedMQTTAuthenticator.class);
    private static final String DOMAIN_NAME_SEPARATOR = "!";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuthenticationInfo checkValid(String username, String password) {
        boolean isAuthenticated = false;
        String carbonCompliantUsername = username.replace(DOMAIN_NAME_SEPARATOR, "@");
        AuthenticationInfo authenticationInfo = new AuthenticationInfo();
        try {
            PrivilegedCarbonContext.startTenantFlow();
            int tenantId = this.getTenantIdOfUser(carbonCompliantUsername);
            if (-1 != tenantId) {
                if (username.contains(DOMAIN_NAME_SEPARATOR)) {
                    String tenantDomain = username.substring(username.indexOf(DOMAIN_NAME_SEPARATOR) + 1);
                    PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantDomain(tenantDomain);
                    PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId(true);
                } else {
                    PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(-1234);
                    PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantDomain("carbon.super");
                }
                UserRealm userRealm = AuthenticationServiceDataHolder.getInstance().getRealmService().getTenantUserRealm(tenantId);
                UserStoreManager userStoreManager = userRealm.getUserStoreManager();
                username = MultitenantUtils.getTenantAwareUsername((String)carbonCompliantUsername);
                isAuthenticated = userStoreManager.authenticate(username, (Object)password);
                authenticationInfo.setUsername(carbonCompliantUsername);
                authenticationInfo.setTenantDomain(MultitenantUtils.getTenantDomain((String)carbonCompliantUsername));
            } else {
                logger.error((Object)String.format("Access denied, unable to find a tenant for user name : %s", username));
            }
        }
        catch (UserStoreException e) {
            String errorMsg = String.format("Unable to authenticate user : %s", username);
            logger.error((Object)errorMsg, (Throwable)e);
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
        authenticationInfo.setAuthenticated(isAuthenticated);
        return authenticationInfo;
    }

    private int getTenantIdOfUser(String username) throws UserStoreException {
        int tenantId = -1;
        String domainName = MultitenantUtils.getTenantDomain((String)username);
        if (domainName != null) {
            TenantManager tenantManager = AuthenticationServiceDataHolder.getInstance().getRealmService().getTenantManager();
            tenantId = tenantManager.getTenantId(domainName);
        }
        return tenantId;
    }
}

