/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.extensions.handlers.utils;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.net.ConnectException;
import java.net.URI;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.jvnet.ws.wadl.ast.InvalidWADLException;
import org.jvnet.ws.wadl.ast.WadlAstBuilder;
import org.jvnet.ws.wadl.util.MessageListener;
import org.w3c.dom.Element;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.ResourceImpl;
import org.wso2.carbon.registry.core.ResourcePath;
import org.wso2.carbon.registry.core.config.RegistryContext;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.Repository;
import org.wso2.carbon.registry.core.jdbc.VersionRepository;
import org.wso2.carbon.registry.core.jdbc.handlers.RequestContext;
import org.wso2.carbon.registry.core.session.CurrentSession;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.registry.extensions.handlers.utils.EndpointUtils;
import org.wso2.carbon.registry.extensions.handlers.utils.RESTServiceUtils;
import org.wso2.carbon.registry.extensions.handlers.utils.SchemaProcessor;
import org.wso2.carbon.registry.extensions.handlers.utils.SchemaValidator;
import org.wso2.carbon.registry.extensions.services.Utils;
import org.wso2.carbon.registry.extensions.utils.CommonUtil;
import org.wso2.carbon.registry.extensions.utils.WSDLValidationInfo;
import org.xml.sax.InputSource;

public class WADLProcessor {
    private static final Log log = LogFactory.getLog(WADLProcessor.class);
    private static final String WADL_EXTENSION = ".wadl";
    private String wadlMediaType = "application/wadl+xml";
    private String xsdMediaType = "application/xsd+xml";
    private static String commonWADLLocation = "/wadls/";
    private static String commonSchemaLocation = "/schemas/";
    private Registry registry;
    private Repository repository;
    private VersionRepository versionRepository;
    private boolean createService = true;
    private List<String> importedSchemas = new LinkedList<String>();
    private OMElement wadlElement;

    public WADLProcessor(RequestContext requestContext) {
        this.registry = requestContext.getRegistry();
        this.repository = requestContext.getRepository();
        this.versionRepository = requestContext.getVersionRepository();
    }

    public boolean getCreateService() {
        return this.createService;
    }

    public void setCreateService(boolean createService) {
        this.createService = createService;
    }

    public static String getCommonSchemaLocation() {
        return commonSchemaLocation;
    }

    public static void setCommonSchemaLocation(String commonSchemaLocation) {
        WADLProcessor.commonSchemaLocation = commonSchemaLocation;
    }

    public static String getCommonWADLLocation() {
        return commonWADLLocation;
    }

    public static void setCommonWADLLocation(String commonWADLLocation) {
        WADLProcessor.commonWADLLocation = commonWADLLocation;
    }

    public String addWadlToRegistry(RequestContext requestContext, Resource resource, String resourcePath, boolean skipValidation) throws RegistryException {
        Object resourceContent;
        String wadlName = RegistryUtils.getResourceName((String)resourcePath);
        String version = requestContext.getResource().getProperty("version");
        if (version == null) {
            version = "1.0.0";
            requestContext.getResource().setProperty("version", version);
        }
        String wadlContent = (resourceContent = resource.getContent()) instanceof String ? (String)resourceContent : new String((byte[])resourceContent);
        try {
            XMLStreamReader reader = XMLInputFactory.newInstance().createXMLStreamReader(new StringReader(wadlContent));
            StAXOMBuilder builder = new StAXOMBuilder(reader);
            this.wadlElement = builder.getDocumentElement();
        }
        catch (XMLStreamException e) {
            String msg = "Unexpected error occured while reading the WADL at " + resourcePath + ".";
            log.error((Object)msg);
            throw new RegistryException(msg, (Throwable)e);
        }
        String wadlNamespace = this.wadlElement.getNamespace().getNamespaceURI();
        String actualPath = this.getWadlLocation(requestContext, this.wadlElement, wadlName, version);
        OMElement grammarsElement = this.wadlElement.getFirstChildWithName(new QName(wadlNamespace, "grammars"));
        if (StringUtils.isNotBlank((String)requestContext.getSourceURL())) {
            String uri = requestContext.getSourceURL();
            if (!skipValidation) {
                this.validateWADL(uri);
            }
            if (resource.getUUID() == null) {
                resource.setUUID(UUID.randomUUID().toString());
            }
            String wadlBaseUri = uri.substring(0, uri.lastIndexOf("/") + 1);
            if (grammarsElement != null) {
                grammarsElement.detach();
                this.wadlElement.addChild((OMNode)this.resolveImports(grammarsElement, wadlBaseUri, version, requestContext.getResource().getProperties()));
            }
        } else {
            if (!skipValidation) {
                File tempFile = null;
                BufferedWriter bufferedWriter = null;
                OutputStreamWriter fileWriter = null;
                try {
                    tempFile = File.createTempFile(wadlName, null);
                    fileWriter = new FileWriter(tempFile);
                    bufferedWriter = new BufferedWriter(fileWriter);
                    bufferedWriter.write(this.wadlElement.toString());
                    bufferedWriter.flush();
                }
                catch (IOException e) {
                    String msg = "Error occurred while reading the WADL " + wadlName + " file";
                    log.error((Object)msg, (Throwable)e);
                    throw new RegistryException(msg, (Throwable)e);
                }
                finally {
                    String msg;
                    if (fileWriter != null) {
                        try {
                            fileWriter.close();
                        }
                        catch (IOException e) {
                            msg = "Error occurred while closing " + wadlName + " file writer";
                            log.warn((Object)msg, (Throwable)e);
                        }
                    }
                    if (bufferedWriter != null) {
                        try {
                            bufferedWriter.close();
                        }
                        catch (IOException e) {
                            msg = "Error occurred while closing WADL " + wadlName + " file writer";
                            log.warn((Object)msg, (Throwable)e);
                        }
                    }
                }
                this.validateWADL(tempFile.toURI().toString());
                try {
                    this.delete(tempFile);
                }
                catch (IOException e) {
                    String msg = "An error occurred while deleting the temporary files from local file system.";
                    log.warn((Object)msg, (Throwable)e);
                    throw new RegistryException(msg, (Throwable)e);
                }
            }
            if (grammarsElement != null) {
                grammarsElement = this.resolveImports(grammarsElement, null, version, requestContext.getResource().getProperties());
                this.wadlElement.addChild((OMNode)grammarsElement);
            }
        }
        requestContext.setResourcePath(new ResourcePath(actualPath));
        if (resource.getProperty("resource.source") == null) {
            resource.setProperty("resource.source", "Auto");
        }
        this.registry.put(actualPath, resource);
        this.addImportAssociations(actualPath);
        if (this.getCreateService()) {
            ResourceImpl tempResource = new ResourceImpl();
            requestContext.setResource((Resource)tempResource);
            OMElement serviceElement = RESTServiceUtils.createRestServiceArtifact(this.wadlElement, wadlName, version, RegistryUtils.getRelativePath((RegistryContext)requestContext.getRegistryContext(), (String)actualPath));
            String servicePath = RESTServiceUtils.addServiceToRegistry(requestContext, serviceElement);
            this.registry.addAssociation(servicePath, actualPath, "depends");
            this.registry.addAssociation(actualPath, servicePath, "usedBy");
            this.saveEndpointElement(requestContext, servicePath, version);
        }
        return resource.getPath();
    }

    private void delete(File file) throws IOException {
        if (file != null && file.exists() && !file.delete()) {
            log.warn((Object)("Failed to delete file/directory at path: " + file.getAbsolutePath()));
        }
    }

    public String importWADLToRegistry(RequestContext requestContext, boolean skipValidation) throws RegistryException {
        Registry registry;
        Resource resource;
        String version;
        ResourcePath resourcePath = requestContext.getResourcePath();
        String wadlName = RegistryUtils.getResourceName((String)resourcePath.getPath());
        if (!wadlName.endsWith(WADL_EXTENSION)) {
            wadlName = wadlName + WADL_EXTENSION;
        }
        if ((version = requestContext.getResource().getProperty("version")) == null) {
            version = "1.0.0";
            requestContext.getResource().setProperty("version", version);
        }
        String uri = requestContext.getSourceURL();
        if (!skipValidation) {
            this.validateWADL(uri);
        }
        if ((resource = (registry = requestContext.getRegistry()).newResource()).getUUID() == null) {
            resource.setUUID(UUID.randomUUID().toString());
        }
        resource.setMediaType(this.wadlMediaType);
        resource.setProperties(requestContext.getResource().getProperties());
        ByteArrayOutputStream outputStream = null;
        InputStream inputStream = null;
        try {
            int nextChar;
            inputStream = new URL(uri).openStream();
            outputStream = new ByteArrayOutputStream();
            while ((nextChar = inputStream.read()) != -1) {
                outputStream.write(nextChar);
            }
            outputStream.flush();
            this.wadlElement = AXIOMUtil.stringToOM((String)new String(outputStream.toByteArray()));
            this.wadlElement.toString();
        }
        catch (Exception e) {
            throw new RegistryException("Unexpected error occured while reading the WADL at" + uri, (Throwable)e);
        }
        finally {
            String msg;
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    msg = "Error while closing  outputStream";
                    log.warn((Object)msg);
                }
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    msg = "Error while closing  inputStream";
                    log.warn((Object)msg);
                }
            }
        }
        String wadlNamespace = this.wadlElement.getNamespace().getNamespaceURI();
        OMElement grammarsElement = this.wadlElement.getFirstChildWithName(new QName(wadlNamespace, "grammars"));
        String wadlBaseUri = uri.substring(0, uri.lastIndexOf("/") + 1);
        if (grammarsElement != null) {
            grammarsElement.detach();
            this.wadlElement.addChild((OMNode)this.resolveImports(grammarsElement, wadlBaseUri, version, requestContext.getResource().getProperties()));
        }
        String actualPath = this.getWadlLocation(requestContext, this.wadlElement, wadlName, version);
        if (resource.getProperty("resource.source") == null) {
            resource.setProperty("resource.source", "Auto");
        }
        resource.setContent((Object)this.wadlElement.toString());
        requestContext.setResourcePath(new ResourcePath(actualPath));
        registry.put(actualPath, resource);
        this.addImportAssociations(actualPath);
        if (this.createService) {
            OMElement serviceElement = RESTServiceUtils.createRestServiceArtifact(this.wadlElement, wadlName, version, RegistryUtils.getRelativePath((RegistryContext)requestContext.getRegistryContext(), (String)actualPath));
            String servicePath = RESTServiceUtils.addServiceToRegistry(requestContext, serviceElement);
            CommonUtil.addDependency(registry, servicePath, actualPath);
            this.saveEndpointElement(requestContext, servicePath, version);
        }
        return actualPath;
    }

    public void saveEndpointElement(RequestContext requestContext, String servicePath, String version) throws RegistryException {
        String endpointPath = this.createEndpointElement(requestContext, this.wadlElement, version, servicePath);
        if (StringUtils.isNotBlank((String)endpointPath)) {
            CommonUtil.addDependency(this.registry, servicePath, endpointPath);
        }
    }

    private OMElement resolveImports(OMElement grammarsElement, String wadlBaseUri, String wadlVersion, Properties props) throws RegistryException {
        String wadlNamespace = grammarsElement.getNamespace().getNamespaceURI();
        Iterator grammarElements = grammarsElement.getChildrenWithName(new QName(wadlNamespace, "include"));
        while (grammarElements.hasNext()) {
            OMElement childElement = (OMElement)grammarElements.next();
            OMAttribute refAttr = childElement.getAttribute(new QName("href"));
            String importUrl = refAttr.getAttributeValue();
            if (!importUrl.endsWith(".xsd")) continue;
            if (!importUrl.startsWith("http")) {
                if (this.registry.resourceExists(importUrl)) continue;
                if (wadlBaseUri != null) {
                    importUrl = wadlBaseUri + importUrl;
                }
            }
            String schemaPath = this.saveSchema(importUrl, wadlVersion, props);
            this.importedSchemas.add(schemaPath);
            refAttr.setAttributeValue(schemaPath);
            childElement.addAttribute(refAttr);
        }
        return grammarsElement;
    }

    private void validateWADL(String uri) throws RegistryException {
        WadlAstBuilder builder = new WadlAstBuilder(new WadlAstBuilder.SchemaCallback(){

            public void processSchema(InputSource is) {
                if (is != null && is.getByteStream() != null) {
                    try {
                        is.getByteStream().close();
                    }
                    catch (IOException e) {
                        String msg = "Error while closing  InputSource";
                        log.warn((Object)msg);
                    }
                }
            }

            public void processSchema(String uri, Element node) {
            }
        }, new MessageListener(){

            public void warning(String message, Throwable throwable) {
            }

            public void info(String message) {
            }

            public void error(String message, Throwable throwable) {
            }
        });
        try {
            builder.buildAst(new URI(uri));
        }
        catch (ConnectException e) {
            String msg = "Invalid WADL uri found " + uri;
            throw new RegistryException(msg, (Throwable)e);
        }
        catch (InvalidWADLException e) {
            String msg = "Invalid WADL definition found";
            throw new RegistryException(msg, (Throwable)e);
        }
        catch (FileNotFoundException e) {
            String msg = "WADL not found";
            throw new RegistryException(msg, (Throwable)e);
        }
        catch (Exception e) {
            String msg = "Unexpected error occured while adding WADL from " + uri;
            throw new RegistryException(msg, (Throwable)e);
        }
    }

    private String saveSchema(String schemaUrl, String version, Properties props) throws RegistryException {
        if (schemaUrl != null) {
            WSDLValidationInfo validationInfo;
            RequestContext requestContext = new RequestContext(this.registry, this.repository, this.versionRepository);
            Resource local = requestContext.getRegistry().newResource();
            local.setMediaType(this.xsdMediaType);
            local.setProperty("resource.source", "Auto");
            local.setProperties(props);
            requestContext.setSourceURL(schemaUrl);
            requestContext.setResource(local);
            String xsdName = schemaUrl;
            xsdName = xsdName.lastIndexOf("/") != -1 ? xsdName.substring(xsdName.lastIndexOf("/")) : "/" + xsdName;
            String path = "/_system/governance" + xsdName;
            requestContext.setResourcePath(new ResourcePath(path));
            try {
                validationInfo = SchemaValidator.validate(new XMLInputSource(null, schemaUrl, null));
            }
            catch (Exception e) {
                throw new RegistryException("Exception occured while validating the schema", (Throwable)e);
            }
            SchemaProcessor schemaProcessor = new SchemaProcessor(requestContext, validationInfo);
            try {
                return schemaProcessor.importSchemaToRegistry(requestContext, path, this.getChrootedSchemaLocation(requestContext.getRegistryContext()), true, true);
            }
            catch (RegistryException e) {
                throw new RegistryException("Failed to import the schema", (Throwable)e);
            }
        }
        return null;
    }

    private String createEndpointElement(RequestContext requestContext, OMElement wadlElement, String version, String servicePath) throws RegistryException {
        String wadlNamespacePrefix;
        OMNamespace wadlNamespace = wadlElement.getNamespace();
        String wadlNamespaceURI = wadlNamespace.getNamespaceURI();
        OMElement resourcesElement = wadlElement.getFirstChildWithName(new QName(wadlNamespaceURI, "resources", wadlNamespacePrefix = wadlNamespace.getPrefix()));
        if (resourcesElement != null) {
            String endpointUrl = resourcesElement.getAttributeValue(new QName("base"));
            if (!StringUtils.isBlank((String)endpointUrl)) {
                OMElement endpointElement;
                String endpointPath = EndpointUtils.deriveEndpointFromUrl(endpointUrl);
                String endpointName = EndpointUtils.deriveEndpointNameWithNamespaceFromUrl(endpointUrl);
                String endpointContent = EndpointUtils.getEndpointContentWithOverview(endpointUrl, endpointPath, endpointName, version);
                EndpointUtils.addEndpointToService(requestContext.getRegistry(), servicePath, endpointUrl, "");
                try {
                    endpointElement = AXIOMUtil.stringToOM((String)endpointContent);
                }
                catch (XMLStreamException e) {
                    throw new RegistryException("Error in creating the endpoint element. ", (Throwable)e);
                }
                return RESTServiceUtils.addEndpointToRegistry(requestContext, endpointElement, endpointPath);
            }
            log.warn((Object)"Base path does not exist. endpoint creation may fail. ");
        } else {
            log.warn((Object)"Resources element is null. ");
        }
        return null;
    }

    private void addImportAssociations(String path) throws RegistryException {
        for (String schema : this.importedSchemas) {
            CommonUtil.addDependency(this.registry, path, schema);
        }
    }

    private String getChrootedWadlLocation(RegistryContext registryContext) {
        return RegistryUtils.getAbsolutePath((RegistryContext)registryContext, (String)("/_system/governance" + WADLProcessor.getCommonWADLLocation()));
    }

    private String getChrootedSchemaLocation(RegistryContext registryContext) {
        return RegistryUtils.getAbsolutePath((RegistryContext)registryContext, (String)("/_system/governance" + WADLProcessor.getCommonSchemaLocation()));
    }

    private String getWadlLocation(RequestContext context, OMElement wadlElement, String wadlName, String version) {
        if (Utils.getRxtService() != null) {
            String pathExpression = Utils.getRxtService().getStoragePath(this.wadlMediaType);
            pathExpression = CommonUtil.replaceExpressionOfPath(pathExpression, "name", wadlName);
            pathExpression = CommonUtil.getPathFromPathExpression(pathExpression, context.getResource().getProperties(), null);
            String namespace = CommonUtil.derivePathFragmentFromNamespace(wadlElement.getNamespace().getNamespaceURI()).replace("//", "/");
            namespace = namespace.replace(".", "/");
            pathExpression = CommonUtil.replaceExpressionOfPath(pathExpression, "namespace", namespace);
            pathExpression = pathExpression.replace("//", "/");
            pathExpression = CommonUtil.replaceExpressionOfPath(pathExpression, "version", version);
            String wadlPath = RegistryUtils.getAbsolutePath((RegistryContext)context.getRegistryContext(), (String)pathExpression.replace("//", "/"));
            if (CurrentSession.getLocalPathMap() != null && !Boolean.valueOf((String)CurrentSession.getLocalPathMap().get("archieve-upload")).booleanValue()) {
                wadlPath = CommonUtil.getRegistryPath(context.getRegistry().getRegistryContext(), wadlPath);
                CurrentSession.getLocalPathMap().remove(context.getResourcePath().getCompletePath());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Saving current session local paths, key: " + wadlPath + " | value: " + pathExpression));
                }
                CurrentSession.getLocalPathMap().put(wadlPath, pathExpression);
            }
            return wadlPath;
        }
        String wadlNamespace = wadlElement.getNamespace().getNamespaceURI();
        String namespaceSegment = CommonUtil.derivePathFragmentFromNamespace(wadlNamespace).replace("//", "/");
        String actualPath = this.getChrootedWadlLocation(context.getRegistryContext()) + namespaceSegment + version + "/" + wadlName;
        return actualPath;
    }
}

