/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.extensions.handlers.utils;

import com.ibm.wsdl.BindingImpl;
import com.ibm.wsdl.PortImpl;
import com.ibm.wsdl.PortTypeImpl;
import com.ibm.wsdl.ServiceImpl;
import com.ibm.wsdl.extensions.http.HTTPAddressImpl;
import com.ibm.wsdl.extensions.soap.SOAPAddressImpl;
import com.ibm.wsdl.extensions.soap.SOAPBindingImpl;
import com.ibm.wsdl.extensions.soap12.SOAP12AddressImpl;
import com.ibm.wsdl.extensions.soap12.SOAP12BindingImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.Service;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.llom.OMElementImpl;
import org.apache.axiom.om.impl.llom.OMTextImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.uddi.api_v3.AccessPoint;
import org.uddi.api_v3.AuthToken;
import org.uddi.api_v3.BindingTemplate;
import org.uddi.api_v3.BindingTemplates;
import org.uddi.api_v3.BusinessDetail;
import org.uddi.api_v3.BusinessEntity;
import org.uddi.api_v3.BusinessInfo;
import org.uddi.api_v3.BusinessList;
import org.uddi.api_v3.BusinessService;
import org.uddi.api_v3.CategoryBag;
import org.uddi.api_v3.Description;
import org.uddi.api_v3.DiscoveryURL;
import org.uddi.api_v3.DiscoveryURLs;
import org.uddi.api_v3.FindBusiness;
import org.uddi.api_v3.InstanceDetails;
import org.uddi.api_v3.KeyedReference;
import org.uddi.api_v3.Name;
import org.uddi.api_v3.OverviewDoc;
import org.uddi.api_v3.OverviewURL;
import org.uddi.api_v3.TModel;
import org.uddi.api_v3.TModelDetail;
import org.uddi.api_v3.TModelInstanceDetails;
import org.uddi.api_v3.TModelInstanceInfo;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.extensions.beans.BusinessServiceInfo;
import org.wso2.carbon.registry.extensions.beans.ServiceDocumentsBean;
import org.wso2.carbon.registry.extensions.handlers.utils.WSDLInfo;
import org.wso2.carbon.registry.server.service.RegistryAdmin;
import org.wso2.carbon.registry.uddi.utils.UDDIUtil;

public class UDDIPublisher {
    private static final Log log = LogFactory.getLog(UDDIPublisher.class);
    private static final String BUSINESS_NAME = "WSO2";
    private static final String BUSINESS_HOMEPAGE_URL = "www.wso2.com";
    private BusinessServiceInfo businessServiceInfo;
    private HashMap<BindingImpl, TModelDetail> bindingTModelDetailHashMap = new HashMap();
    private HashMap<PortTypeImpl, TModelDetail> portTypeTModelDetailHashMap = new HashMap();

    public void publishBusinessService(AuthToken authToken, BusinessServiceInfo businessServiceInfo) throws RegistryException {
        this.businessServiceInfo = businessServiceInfo;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Publishing business service is started.");
        }
        BusinessService businessService = null;
        try {
            String businessKey = this.saveBusiness(authToken);
            if (businessKey == null) {
                return;
            }
            WSDLInfo wsdlInfo = businessServiceInfo.getServiceWSDLInfo();
            String serviceName = businessServiceInfo.getServiceName();
            if (wsdlInfo != null && serviceName != null) {
                Map<QName, Service> services = this.getAllServices(wsdlInfo.getWSDLDefinition(), new ArrayList<String>());
                if (services.size() > 0) {
                    for (Service service1 : services.values()) {
                        ServiceImpl service = (ServiceImpl)service1;
                        if (!serviceName.equals(service.getQName().getLocalPart())) continue;
                        businessServiceInfo.setService(service);
                        businessService = this.createBusinessService(businessKey);
                    }
                }
                UDDIUtil.publishBusinessService(businessService, (AuthToken)authToken);
            } else if (wsdlInfo != null) {
                for (Service service1 : this.getAllServices(wsdlInfo.getWSDLDefinition(), new ArrayList<String>()).values()) {
                    ServiceImpl service = (ServiceImpl)service1;
                    businessServiceInfo.setService(service);
                    businessService = this.createBusinessService(businessKey);
                    UDDIUtil.publishBusinessService((BusinessService)businessService, (AuthToken)authToken);
                }
            } else {
                UDDIUtil.publishBusinessService(businessService, (AuthToken)authToken);
            }
        }
        catch (RegistryException e) {
            throw new RegistryException("Faied to publish service to UDDI repository", (Throwable)e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Business service has been successfully published into UDDI");
        }
    }

    private Map<QName, Service> getAllServices(Definition wsdlDefinition, List<String> traversedDefinitionList) {
        HashMap<QName, Service> servicesMap = new HashMap<QName, Service>();
        if (traversedDefinitionList.contains(wsdlDefinition.getTargetNamespace())) {
            return null;
        }
        traversedDefinitionList.add(wsdlDefinition.getTargetNamespace());
        for (Object imprtCol : wsdlDefinition.getImports().values()) {
            Vector importVector = (Vector)imprtCol;
            for (Import importEel : importVector) {
                Map<QName, Service> childMap;
                if (importEel.getDefinition() == null || (childMap = this.getAllServices(importEel.getDefinition(), traversedDefinitionList)) == null) continue;
                servicesMap.putAll(childMap);
            }
        }
        if (!wsdlDefinition.getServices().isEmpty()) {
            servicesMap.putAll(wsdlDefinition.getServices());
        }
        return servicesMap;
    }

    private BusinessService createBusinessService(String businessKey) {
        BusinessService businessService = new BusinessService();
        businessService.setBusinessKey(businessKey);
        ServiceImpl service = this.businessServiceInfo.getService();
        if (this.businessServiceInfo.getServiceDescription() != null) {
            Description serviceDesc = new Description();
            serviceDesc.setLang("en");
            serviceDesc.setValue(this.businessServiceInfo.getServiceDescription());
            businessService.getDescription().add(serviceDesc);
        }
        CategoryBag categoryBag = new CategoryBag();
        this.addKeyedReferenceToCategoryBag(categoryBag, "uddi:uddi.org:wsdl:types", "WSDL type", "service");
        if (service != null) {
            String serviceName = service.getQName().getLocalPart();
            String serviceNamespace = service.getQName().getNamespaceURI();
            Name name = new Name();
            name.setValue(serviceName);
            businessService.getName().add(name);
            Map ports = service.getPorts();
            if (ports != null) {
                BindingTemplates bindingTemplates = new BindingTemplates();
                for (PortImpl port : ports.values()) {
                    BindingTemplate bindingTemplate = null;
                    List extensibilityElementList = port.getExtensibilityElements();
                    if (extensibilityElementList.size() <= 0) continue;
                    for (Object address : extensibilityElementList) {
                        String className = address.getClass().getSimpleName();
                        if ("SOAPAddressImpl".equals(className)) {
                            bindingTemplate = this.createBindingTemplateForSOAP11(bindingTemplate, port, address);
                            continue;
                        }
                        if ("SOAP12AddressImpl".equals(className)) {
                            bindingTemplate = this.createBindingTemplateForSOAP12(bindingTemplate, port, address);
                            continue;
                        }
                        if (!"HTTPAddressImpl".equals(className)) continue;
                        bindingTemplate = this.createBindingTemplateForHTTP(bindingTemplate, port, address);
                    }
                    if (bindingTemplate == null) continue;
                    bindingTemplates.getBindingTemplate().add(bindingTemplate);
                }
                businessService.setBindingTemplates(bindingTemplates);
            }
            this.addKeyedReferenceToCategoryBag(categoryBag, "uddi:uddi.org:xml:namespace", "service namespace", serviceNamespace);
            this.addKeyedReferenceToCategoryBag(categoryBag, "uddi:uddi.org:xml:localname", "service local name", serviceName);
        }
        businessService.setCategoryBag(categoryBag);
        return businessService;
    }

    private BindingTemplate createBindingTemplateForSOAP11(BindingTemplate bindingTemplate, PortImpl port, Object address) {
        bindingTemplate = new BindingTemplate();
        SOAPAddressImpl soapAddress = (SOAPAddressImpl)address;
        String endpoint = soapAddress.getLocationURI();
        AccessPoint accessPoint = new AccessPoint();
        accessPoint.setValue(endpoint);
        accessPoint.setUseType("endPoint");
        bindingTemplate.setAccessPoint(accessPoint);
        TModelInstanceDetails tModelinstanceDetails = this.constructTModelInstanceDetails(port);
        bindingTemplate.setTModelInstanceDetails(tModelinstanceDetails);
        return bindingTemplate;
    }

    private BindingTemplate createBindingTemplateForSOAP12(BindingTemplate bindingTemplate, PortImpl port, Object address) {
        bindingTemplate = new BindingTemplate();
        SOAP12AddressImpl soap12Address = (SOAP12AddressImpl)address;
        String endpoint = soap12Address.getLocationURI();
        AccessPoint accessPoint = new AccessPoint();
        accessPoint.setValue(endpoint);
        accessPoint.setUseType("endPoint");
        bindingTemplate.setAccessPoint(accessPoint);
        TModelInstanceDetails tModelinstanceDetails = this.constructTModelInstanceDetails(port);
        bindingTemplate.setTModelInstanceDetails(tModelinstanceDetails);
        return bindingTemplate;
    }

    private BindingTemplate createBindingTemplateForHTTP(BindingTemplate bindingTemplate, PortImpl port, Object address) {
        bindingTemplate = new BindingTemplate();
        HTTPAddressImpl httpAddress = (HTTPAddressImpl)address;
        String endpoint = httpAddress.getLocationURI();
        AccessPoint accessPoint = new AccessPoint();
        accessPoint.setValue(endpoint);
        accessPoint.setUseType("endPoint");
        bindingTemplate.setAccessPoint(accessPoint);
        TModelInstanceDetails tModelinstanceDetails = this.constructTModelInstanceDetails(port);
        if (tModelinstanceDetails == null) {
            return null;
        }
        bindingTemplate.setTModelInstanceDetails(tModelinstanceDetails);
        return bindingTemplate;
    }

    private TModelInstanceDetails constructTModelInstanceDetails(PortImpl port) {
        TModelInstanceDetails tModelInstanceDetails = new TModelInstanceDetails();
        BindingImpl binding = (BindingImpl)port.getBinding();
        PortTypeImpl portType = (PortTypeImpl)binding.getPortType();
        if (portType == null) {
            log.warn((Object)"portType null therefore failed to published to UDDI");
            return null;
        }
        String tModelKey = this.publishPortTypeTModels(portType, tModelInstanceDetails);
        this.publishBindingTModel(binding, tModelKey, port.getName(), tModelInstanceDetails);
        if (this.businessServiceInfo.getDocuments() != null) {
            this.publishDocumentTModel(tModelInstanceDetails);
        }
        if (this.businessServiceInfo.getServiceEndpoints() != null) {
            this.publishEndpointDetails(tModelInstanceDetails);
        }
        return tModelInstanceDetails;
    }

    private String publishPortTypeTModels(PortTypeImpl portType, TModelInstanceDetails tModelInstantDetails) {
        TModel tModel = null;
        String tModelKey = null;
        TModelDetail tModelDetail = null;
        if (!this.portTypeTModelDetailHashMap.containsKey(portType)) {
            tModel = this.constructPortTypeTModel(portType);
            try {
                tModelDetail = UDDIUtil.saveTModel((TModel)tModel);
                this.portTypeTModelDetailHashMap.put(portType, tModelDetail);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("PortType: " + portType.getQName().getLocalPart() + " TModel has been successfully published to UDDI."));
                }
            }
            catch (RegistryException e) {
                log.warn((Object)("Failed to publish portType: " + portType.getQName().getLocalPart() + " TModel"));
            }
        } else {
            tModelDetail = this.portTypeTModelDetailHashMap.get(portType);
        }
        if (tModelDetail != null) {
            TModelInstanceInfo tModelInstanceInfo = new TModelInstanceInfo();
            Description desc = new Description();
            desc.setValue("The wsdl:portType that this wsdl:port implements.");
            desc.setLang("en");
            tModelInstanceInfo.getDescription().add(desc);
            tModelKey = ((TModel)tModelDetail.getTModel().iterator().next()).getTModelKey();
            tModelInstanceInfo.setTModelKey(tModelKey);
            tModelInstantDetails.getTModelInstanceInfo().add(tModelInstanceInfo);
        }
        return tModelKey;
    }

    private TModel constructPortTypeTModel(PortTypeImpl portType) {
        TModel tModel = new TModel();
        Name portTypeName = new Name();
        portTypeName.setValue(portType.getQName().getLocalPart());
        tModel.setName(portTypeName);
        RegistryAdmin admin = new RegistryAdmin();
        String wsdlUrl = admin.getHTTPPermalink(this.businessServiceInfo.getServiceWSDLInfo().getProposedRegistryURL());
        if (wsdlUrl != null && wsdlUrl.contains(";version:")) {
            wsdlUrl = wsdlUrl.split(";version:")[0];
        }
        OverviewDoc overviewDoc = new OverviewDoc();
        OverviewURL overviewUrl = new OverviewURL();
        overviewUrl.setValue(wsdlUrl);
        overviewUrl.setUseType("wsdlInterface");
        overviewDoc.setOverviewURL(overviewUrl);
        tModel.getOverviewDoc().add(overviewDoc);
        CategoryBag categoryBag = new CategoryBag();
        String portTypeNamespace = portType.getQName().getNamespaceURI();
        if (portTypeNamespace != null) {
            this.addKeyedReferenceToCategoryBag(categoryBag, "uddi:uddi.org:xml:namespace", "portType namespace", portTypeNamespace);
        }
        this.addKeyedReferenceToCategoryBag(categoryBag, "uddi:uddi.org:wsdl:types", "WSDL type", "portType");
        tModel.setCategoryBag(categoryBag);
        return tModel;
    }

    private void publishBindingTModel(BindingImpl binding, String tModelKey, String portName, TModelInstanceDetails tModelInstantDetails) {
        TModelDetail tModelDetail = null;
        if (!this.bindingTModelDetailHashMap.containsKey(binding)) {
            TModel tModel = this.constructBindingTModel(binding, tModelKey);
            try {
                tModelDetail = UDDIUtil.saveTModel((TModel)tModel);
                this.bindingTModelDetailHashMap.put(binding, tModelDetail);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Binding: " + binding.getQName().getLocalPart() + " TModel has been successfully published to UDDI."));
                }
            }
            catch (RegistryException e) {
                log.warn((Object)("Failed to publish binding: " + binding.getQName().getLocalPart() + " TModel"));
            }
        } else {
            tModelDetail = this.bindingTModelDetailHashMap.get(binding);
        }
        if (tModelDetail != null) {
            TModelInstanceInfo tModelInstanceInfo = new TModelInstanceInfo();
            Description desc = new Description();
            desc.setValue("The wsdl:binding that this wsdl:port implements. The instanceParms specifies the port local name");
            desc.setLang("en");
            tModelInstanceInfo.getDescription().add(desc);
            tModelInstanceInfo.setTModelKey(((TModel)tModelDetail.getTModel().iterator().next()).getTModelKey());
            InstanceDetails instanceDetails = new InstanceDetails();
            instanceDetails.setInstanceParms(portName);
            tModelInstanceInfo.setInstanceDetails(instanceDetails);
            tModelInstantDetails.getTModelInstanceInfo().add(tModelInstanceInfo);
        }
    }

    private TModel constructBindingTModel(BindingImpl binding, String tModelKey) {
        TModel tModel = new TModel();
        Name bindingName = new Name();
        bindingName.setValue(binding.getQName().getLocalPart());
        tModel.setName(bindingName);
        RegistryAdmin admin = new RegistryAdmin();
        String wsdlUrl = admin.getHTTPPermalink(this.businessServiceInfo.getServiceWSDLInfo().getProposedRegistryURL());
        if (wsdlUrl != null && wsdlUrl.contains(";version:")) {
            wsdlUrl = wsdlUrl.split(";version:")[0];
        }
        OverviewDoc overviewDoc = new OverviewDoc();
        OverviewURL overviewUrl = new OverviewURL();
        overviewUrl.setValue(wsdlUrl);
        overviewUrl.setUseType("wsdlInterface");
        overviewDoc.setOverviewURL(overviewUrl);
        tModel.getOverviewDoc().add(overviewDoc);
        CategoryBag categoryBag = new CategoryBag();
        String bindingNamespace = binding.getQName().getNamespaceURI();
        if (bindingNamespace != null) {
            this.addKeyedReferenceToCategoryBag(categoryBag, "uddi:uddi.org:xml:namespace", "binding namespace", bindingNamespace);
        }
        this.addKeyedReferenceToCategoryBag(categoryBag, "uddi:uddi.org:wsdl:types", "WSDL type", "binding");
        this.addKeyedReferenceToCategoryBag(categoryBag, "uddi:uddi.org:wsdl:porttypereference", "portType reference", tModelKey);
        ArrayList<String> protocolNTransport = this.getBindingProtocolAndTransport(binding);
        if (protocolNTransport.size() == 2) {
            this.addKeyedReferenceToCategoryBag(categoryBag, "uddi:uddi.org:wsdl:categorization:protocol", protocolNTransport.get(0), protocolNTransport.get(1));
        }
        if (protocolNTransport.size() == 4) {
            this.addKeyedReferenceToCategoryBag(categoryBag, "uddi:uddi.org:wsdl:categorization:protocol", protocolNTransport.get(0), protocolNTransport.get(1));
            this.addKeyedReferenceToCategoryBag(categoryBag, "uddi:uddi.org:wsdl:categorization:transportport", protocolNTransport.get(2), protocolNTransport.get(3));
        }
        this.addKeyedReferenceToCategoryBag(categoryBag, "uddi:uddi.org:categorization:types", "uddi-org:types", "wsdlSpec");
        tModel.setCategoryBag(categoryBag);
        return tModel;
    }

    private ArrayList<String> getBindingProtocolAndTransport(BindingImpl binding) {
        ArrayList<String> protocolNTransport = new ArrayList<String>();
        if (binding.getExtensibilityElements().iterator().hasNext()) {
            String className = binding.getExtensibilityElements().iterator().next().getClass().getSimpleName();
            if ("SOAPBindingImpl".equals(className)) {
                SOAPBindingImpl soap11BindingProtocol = (SOAPBindingImpl)binding.getExtensibilityElements().iterator().next();
                String transportUri = soap11BindingProtocol.getTransportURI();
                protocolNTransport.add("SOAP Protocol");
                protocolNTransport.add("uddi:uddi.org:protocol:soap");
                if ("http://schemas.xmlsoap.org/soap/http".equals(transportUri)) {
                    protocolNTransport.add("HTTP Transport");
                    protocolNTransport.add("uddi:uddi.org:transport:http");
                } else if ("http://schemas.pocketsoap.com/soap/smtp".equals(transportUri)) {
                    protocolNTransport.add("SMTP Transport");
                    protocolNTransport.add("uddi:uddi.org:transport:smtp");
                }
            } else if ("SOAP12BindingImpl".equals(className)) {
                SOAP12BindingImpl soap12BindingProtocol = (SOAP12BindingImpl)binding.getExtensibilityElements().iterator().next();
                String transportUri = soap12BindingProtocol.getTransportURI();
                protocolNTransport.add("SOAP Protocol");
                protocolNTransport.add("uddi:uddi.org:protocol:soap");
                if ("http://schemas.xmlsoap.org/soap/http".equals(transportUri)) {
                    protocolNTransport.add("HTTP Transport");
                    protocolNTransport.add("uddi:uddi.org:transport:http");
                } else if ("http://schemas.pocketsoap.com/soap/smtp".equals(transportUri)) {
                    protocolNTransport.add("SMTP Transport");
                    protocolNTransport.add("uddi:uddi.org:transport:smtp");
                }
            } else if ("HTTPBindingImpl".equals(className)) {
                protocolNTransport.add("HTTP Protocol");
                protocolNTransport.add("uddi:uddi.org:protocol:http");
            }
        }
        return protocolNTransport;
    }

    private void publishDocumentTModel(TModelInstanceDetails tModelInstanceDetails) {
        ArrayList<ServiceDocumentsBean> documents = this.businessServiceInfo.getDocuments();
        Description desc = new Description();
        desc.setValue("This provides a documentation about the service");
        for (ServiceDocumentsBean document : documents) {
            TModelInstanceInfo tModelInstanceInfo = new TModelInstanceInfo();
            tModelInstanceInfo.getDescription().add(desc);
            TModel tModel = new TModel();
            Name documentName = new Name();
            documentName.setValue(document.getDocumentType());
            tModel.setName(documentName);
            OverviewDoc docDetails = new OverviewDoc();
            OverviewURL docUrl = new OverviewURL();
            docUrl.setValue(document.getDocumentUrl());
            docUrl.setUseType("text");
            docDetails.setOverviewURL(docUrl);
            Description description = new Description();
            description.setValue(document.getDocumentDescription());
            docDetails.getDescription().add(description);
            tModel.getOverviewDoc().add(docDetails);
            TModelDetail tModelDetail = null;
            try {
                tModelDetail = UDDIUtil.saveTModel((TModel)tModel);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Document: " + documentName.getValue() + " TModel has been successfully published to UDDI."));
                }
            }
            catch (RegistryException e) {
                log.error((Object)("Failed to publish document: " + documentName.getValue() + " TModel"), (Throwable)e);
            }
            if (tModelDetail == null) continue;
            tModelInstanceInfo.setTModelKey(((TModel)tModelDetail.getTModel().iterator().next()).getTModelKey());
            tModelInstanceDetails.getTModelInstanceInfo().add(tModelInstanceInfo);
        }
    }

    private void publishEndpointDetails(TModelInstanceDetails tModelInstanceDetails) {
        OMElement[] elements;
        Description desc = new Description();
        desc.setValue("This provides the endpoint for an environment");
        for (OMElement element : elements = this.businessServiceInfo.getServiceEndpoints()) {
            String endpointDetail = ((OMTextImpl)((OMElementImpl)element).getFirstOMChildIfAvailable()).getText();
            String environment = endpointDetail.split(":")[0];
            int characterLengthForFirstColon = endpointDetail.indexOf(":") + 1;
            String endpoint = endpointDetail.substring(characterLengthForFirstColon);
            TModelInstanceInfo tModelInstanceInfo = new TModelInstanceInfo();
            tModelInstanceInfo.getDescription().add(desc);
            TModel tModel = new TModel();
            Name environmentName = new Name();
            environmentName.setValue(environment);
            tModel.setName(environmentName);
            OverviewDoc overviewDoc = new OverviewDoc();
            OverviewURL endpointUrl = new OverviewURL();
            endpointUrl.setValue(endpoint);
            overviewDoc.setOverviewURL(endpointUrl);
            tModel.getOverviewDoc().add(overviewDoc);
            TModelDetail tModelDetail = null;
            try {
                tModelDetail = UDDIUtil.saveTModel((TModel)tModel);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Endpoint: " + environmentName.getValue() + " TModel has been successfully published to UDDI."));
                }
            }
            catch (RegistryException e) {
                log.error((Object)("Failed to publish endpoint: " + environmentName.getValue() + " TModel"), (Throwable)e);
            }
            if (tModelDetail == null) continue;
            tModelInstanceInfo.setTModelKey(((TModel)tModelDetail.getTModel().iterator().next()).getTModelKey());
            tModelInstanceDetails.getTModelInstanceInfo().add(tModelInstanceInfo);
        }
    }

    private void addKeyedReferenceToCategoryBag(CategoryBag categoryBag, String tModelKey, String keyName, String keyValue) {
        KeyedReference keyedReference = new KeyedReference();
        keyedReference.setTModelKey(tModelKey);
        keyedReference.setKeyName(keyName);
        keyedReference.setKeyValue(keyValue);
        categoryBag.getKeyedReference().add(keyedReference);
    }

    private String saveBusiness(AuthToken authToken) throws RegistryException {
        String businessKey = null;
        String businessName = null;
        BusinessEntity businessEntity = new BusinessEntity();
        businessName = BUSINESS_NAME;
        String businessHomepageUrl = BUSINESS_HOMEPAGE_URL;
        if (UDDIUtil.businessKeyMap == null || !UDDIUtil.businessKeyMap.containsKey(businessHomepageUrl)) {
            BusinessInfo businessInfo = this.findBusiness(businessName, businessHomepageUrl);
            if (businessInfo == null) {
                Name businessEntityName = new Name();
                businessEntityName.setValue(businessName);
                businessEntityName.setLang("en");
                businessEntity.getName().add(businessEntityName);
                DiscoveryURL url = new DiscoveryURL();
                url.setValue(businessHomepageUrl);
                url.setUseType("homepage");
                DiscoveryURLs discoveryUrls = new DiscoveryURLs();
                discoveryUrls.getDiscoveryURL().add(url);
                businessEntity.setDiscoveryURLs(discoveryUrls);
                BusinessDetail businessDetail = null;
                try {
                    businessDetail = UDDIUtil.publishBusiness((BusinessEntity)businessEntity, (AuthToken)authToken);
                }
                catch (RegistryException e) {
                    throw new RegistryException("Unable to publish the business entity", (Throwable)e);
                }
                businessKey = ((BusinessEntity)businessDetail.getBusinessEntity().iterator().next()).getBusinessKey();
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Business entity has been successfully published into UDDI");
                }
            } else {
                businessKey = businessInfo.getBusinessKey();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("BusinessKey of the businessEntity:" + businessName + " has been successfully taken from UDDI registry."));
                }
            }
            if (UDDIUtil.businessKeyMap == null) {
                UDDIUtil.businessKeyMap = new HashMap();
            }
            UDDIUtil.businessKeyMap.put(businessHomepageUrl, businessKey);
        } else {
            businessKey = (String)UDDIUtil.businessKeyMap.get(businessHomepageUrl);
            if (log.isDebugEnabled()) {
                log.debug((Object)("BusinessKey of the businessEntity:" + businessName + " has been successfully taken."));
            }
        }
        return businessKey;
    }

    private BusinessInfo findBusiness(String businessName, String businessHomepageUrl) {
        FindBusiness business = new FindBusiness();
        BusinessList businessList = null;
        BusinessInfo businessInfo = null;
        Name name = new Name();
        name.setValue(businessName);
        DiscoveryURL homepageUrl = new DiscoveryURL();
        homepageUrl.setValue(businessHomepageUrl);
        DiscoveryURLs urls = new DiscoveryURLs();
        urls.getDiscoveryURL().add(homepageUrl);
        business.getName().add(name);
        business.setDiscoveryURLs(urls);
        try {
            businessList = UDDIUtil.findBusiness((FindBusiness)business);
            if (businessList.getBusinessInfos() != null) {
                businessInfo = (BusinessInfo)businessList.getBusinessInfos().getBusinessInfo().iterator().next();
            }
        }
        catch (RegistryException e) {
            log.error((Object)("Failed to find the business" + businessName), (Throwable)e);
        }
        return businessInfo;
    }
}

