/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.extensions.handlers;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.wso2.carbon.registry.core.Association;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.ResourcePath;
import org.wso2.carbon.registry.core.config.RegistryContext;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.handlers.Handler;
import org.wso2.carbon.registry.core.jdbc.handlers.RequestContext;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.registry.extensions.handlers.utils.SchemaProcessor;
import org.wso2.carbon.registry.extensions.handlers.utils.SchemaValidator;
import org.wso2.carbon.registry.extensions.utils.CommonUtil;
import org.wso2.carbon.registry.extensions.utils.WSDLValidationInfo;

public class XSDMediaTypeHandler
extends Handler {
    private static final Log log = LogFactory.getLog(XSDMediaTypeHandler.class);
    private String location = "/schema/";
    private String locationTag = "location";
    private boolean disableSchemaValidation = false;
    private boolean disableSymlinkCreation = true;
    private String defaultSchemaVersion = "1.0.0";
    private OMElement locationConfiguration;

    public OMElement getLocationConfiguration() {
        return this.locationConfiguration;
    }

    public void setLocationConfiguration(OMElement locationConfiguration) throws RegistryException {
        Iterator confElements = locationConfiguration.getChildElements();
        while (confElements.hasNext()) {
            OMElement confElement = (OMElement)confElements.next();
            if (!confElement.getQName().equals(new QName(this.locationTag))) continue;
            this.location = confElement.getText();
            if (!this.location.startsWith("/")) {
                this.location = "/" + this.location;
            }
            if (this.location.endsWith("/")) continue;
            this.location = this.location + "/";
        }
        this.locationConfiguration = locationConfiguration;
    }

    public boolean isDisableSymlinkCreation() {
        return this.disableSymlinkCreation;
    }

    public void setDisableSymlinkCreation(String disableSymlinkCreation) {
        this.disableSymlinkCreation = Boolean.toString(true).equals(disableSymlinkCreation);
    }

    public void setDefaultServiceVersion(String defaultSchemaVersion) {
        this.defaultSchemaVersion = defaultSchemaVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(RequestContext requestContext) throws RegistryException {
        if (!CommonUtil.isUpdateLockAvailable()) {
            return;
        }
        CommonUtil.acquireUpdateLock();
        try {
            String savedName;
            Resource resource = requestContext.getResource();
            String resourcePath = requestContext.getResourcePath().getPath();
            String parentPath = RegistryUtils.getParentPath((String)resourcePath);
            Registry registry = requestContext.getRegistry();
            String remotePut = resource.getProperty("registry.remotemount.operation");
            if (remotePut != null) {
                CommonUtil.releaseUpdateLock();
                resource.removeProperty("registry.remotemount.operation");
                registry.put(resourcePath, resource);
                requestContext.setProcessingComplete(true);
                return;
            }
            String oldResourcePath = null;
            if (registry.resourceExists(resourcePath)) {
                Object newContent = resource.getContent();
                if (newContent instanceof String) {
                    newContent = RegistryUtils.encodeString((String)((String)newContent));
                }
                Resource oldResource = registry.get(resourcePath);
                Object oldContent = oldResource.getContent();
                String newContentString = null;
                String oldContentString = null;
                if (newContent != null) {
                    newContentString = newContent instanceof String ? (String)newContent : RegistryUtils.decodeBytes((byte[])((byte[])newContent));
                }
                if (oldContent != null) {
                    oldContentString = oldContent instanceof String ? (String)oldContent : RegistryUtils.decodeBytes((byte[])((byte[])oldContent));
                }
                if (newContent == null && oldContent == null || newContentString != null && newContentString.equals(oldContentString)) {
                    return;
                }
                oldResourcePath = resourcePath;
            }
            WSDLValidationInfo validationInfo = null;
            requestContext.setSourceURL(requestContext.getResource().getProperty("sourceURL"));
            String sourceURL = requestContext.getSourceURL();
            if (StringUtils.isNotBlank((String)sourceURL)) {
                if (requestContext.getSourceURL().toLowerCase().startsWith("file:")) {
                    String msg = "The source URL must not be file in the server's local file system";
                    throw new RegistryException(msg);
                }
                try {
                    if (!this.disableSchemaValidation) {
                        validationInfo = SchemaValidator.validate(new XMLInputSource(null, sourceURL, null));
                    }
                }
                catch (Exception e) {
                    throw new RegistryException("Exception occurred while validating the schema " + sourceURL, (Throwable)e);
                }
                savedName = this.processSchemaImport(requestContext, resourcePath, validationInfo);
            } else {
                Object resourceContent = resource.getContent();
                if (resourceContent instanceof String) {
                    resourceContent = RegistryUtils.encodeString((String)((String)resourceContent));
                    resource.setContent(resourceContent);
                }
                if (resourceContent instanceof byte[]) {
                    try {
                        ByteArrayInputStream in = new ByteArrayInputStream((byte[])resourceContent);
                        if (!this.disableSchemaValidation) {
                            validationInfo = SchemaValidator.validate(new XMLInputSource(null, null, null, (InputStream)in, null));
                        }
                    }
                    catch (Exception e) {
                        throw new RegistryException("Exception occurred while validating the schema", (Throwable)e);
                    }
                }
                savedName = this.processSchemaUpload(requestContext, resourcePath, validationInfo);
            }
            if (StringUtils.isNotBlank((String)savedName)) {
                this.onPutCompleted(resourcePath, Collections.singletonMap(sourceURL, savedName), Collections.emptyList(), requestContext);
                requestContext.setActualPath(savedName);
            }
            requestContext.setProcessingComplete(true);
        }
        finally {
            CommonUtil.releaseUpdateLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importResource(RequestContext requestContext) throws RegistryException {
        if (!CommonUtil.isUpdateLockAvailable()) {
            return;
        }
        CommonUtil.acquireUpdateLock();
        try {
            String parentPath = RegistryUtils.getParentPath((String)requestContext.getResourcePath().getPath());
            String resourcePath = requestContext.getResourcePath().getCompletePath();
            String sourceURL = requestContext.getSourceURL();
            if (requestContext.getSourceURL() != null && requestContext.getSourceURL().toLowerCase().startsWith("file:")) {
                String msg = "The source URL must not be file in the server's local file system";
                throw new RegistryException(msg);
            }
            WSDLValidationInfo validationInfo = null;
            try {
                if (!this.disableSchemaValidation) {
                    validationInfo = SchemaValidator.validate(new XMLInputSource(null, sourceURL, null));
                }
            }
            catch (Exception e) {
                throw new RegistryException("Exception occured while validating the schema", (Throwable)e);
            }
            String savedName = this.processSchemaImport(requestContext, resourcePath, validationInfo);
            if (parentPath.endsWith("/")) {
                requestContext.setActualPath(parentPath + RegistryUtils.getResourceName((String)savedName));
            } else {
                requestContext.setActualPath(parentPath + "/" + RegistryUtils.getResourceName((String)savedName));
            }
            this.onPutCompleted(resourcePath, Collections.singletonMap(sourceURL, savedName), Collections.emptyList(), requestContext);
            requestContext.setProcessingComplete(true);
        }
        finally {
            CommonUtil.releaseUpdateLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String processSchemaUpload(RequestContext requestContext, String resourcePath, WSDLValidationInfo validationInfo) throws RegistryException {
        String registryPath = null;
        List<File> tempFiles = this.makeTempDirStructure(requestContext);
        try {
            SchemaProcessor schemaProcessor = this.buildSchemaProcessor(requestContext, validationInfo);
            registryPath = schemaProcessor.putSchemaToRegistry(requestContext, resourcePath, this.getChrootedLocation(requestContext.getRegistryContext()), true, this.disableSymlinkCreation);
        }
        finally {
            this.deleteTempFiles(tempFiles);
        }
        return registryPath;
    }

    private List<File> makeTempDirStructure(RequestContext requestContext) throws RegistryException {
        String resourcePath = requestContext.getResource().getPath();
        Registry registry = requestContext.getRegistry();
        ArrayList<File> tempFiles = new ArrayList<File>();
        if (resourcePath == null) {
            return tempFiles;
        }
        try {
            File tempFile;
            String uri;
            LinkedHashSet<String> registryPaths = new LinkedHashSet<String>();
            registryPaths.add(resourcePath);
            Association[] dependencies = CommonUtil.getDependenciesRecursively(registry, resourcePath);
            if (dependencies != null) {
                for (Association dependency : dependencies) {
                    String targetPath = dependency.getDestinationPath();
                    if (!targetPath.startsWith("/")) continue;
                    registryPaths.add(targetPath);
                }
            }
            File referenceTempFile = File.createTempFile("xsd", ".ref");
            File tempDir = new File(referenceTempFile.getAbsolutePath().substring(0, referenceTempFile.getAbsolutePath().length() - ".ref".length()));
            String tempDirPath = tempDir.getAbsolutePath();
            for (String registryPath : registryPaths) {
                int byteCount;
                byte[] resourceContentBytes;
                Object resourceContent;
                if (!registryPath.startsWith("/")) continue;
                String filePath = tempDirPath + registryPath;
                File tempFile2 = new File(filePath);
                this.makeDirs(tempFile2.getParentFile());
                if (registryPath.equals(resourcePath)) {
                    resourceContent = requestContext.getResource().getContent();
                } else {
                    Resource r;
                    if (!registry.resourceExists(registryPath) || (r = registry.get(registryPath)) == null) continue;
                    resourceContent = r.getContent();
                }
                if (resourceContent == null) {
                    resourceContentBytes = new byte[]{};
                } else if (resourceContent instanceof byte[]) {
                    resourceContentBytes = (byte[])resourceContent;
                } else if (resourceContent instanceof String) {
                    resourceContentBytes = RegistryUtils.encodeString((String)((String)resourceContent));
                } else {
                    String msg = "Unknown type for the content resourcePath: " + registryPath + ", content type: " + resourceContent.getClass().getName() + ".";
                    log.error((Object)msg);
                    throw new RegistryException(msg);
                }
                ByteArrayInputStream in = new ByteArrayInputStream(resourceContentBytes);
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(tempFile2));
                byte[] contentChunk = new byte[1024];
                while ((byteCount = in.read(contentChunk)) != -1) {
                    out.write(contentChunk, 0, byteCount);
                }
                out.flush();
                out.close();
                tempFiles.add(tempFile2);
            }
            if (tempFiles.size() == 0) {
                String msg = "Temporary files count is zero, when updating a xsd. xsd resourcePath: " + resourcePath + ".";
                log.error((Object)msg);
            }
            if ((uri = (tempFile = (File)tempFiles.get(0)).toURI().toString()) != null) {
                if (uri.startsWith("file:")) {
                    uri = uri.substring(5);
                }
                while (uri.startsWith("/")) {
                    uri = uri.substring(1);
                }
                uri = "file:///" + uri;
                requestContext.setSourceURL(uri);
            }
            tempFiles.add(tempDir);
            tempFiles.add(referenceTempFile);
        }
        catch (IOException ioe) {
            String msg = "Error in updating the XML Schema. XML Schema resourcePath: " + resourcePath + ".";
            log.error((Object)msg, (Throwable)ioe);
            throw new RegistryException(msg, (Throwable)ioe);
        }
        return tempFiles;
    }

    private void deleteTempFiles(List<File> tempFiles) throws RegistryException {
        try {
            int fileSize = tempFiles.size();
            if (fileSize >= 2) {
                for (int i = 0; i < fileSize - 2; ++i) {
                    FileUtils.forceDelete((File)tempFiles.get(i));
                }
                FileUtils.deleteDirectory((File)tempFiles.get(fileSize - 2));
                FileUtils.forceDelete((File)tempFiles.get(fileSize - 1));
            }
        }
        catch (IOException ioe) {
            String msg = "Error in updating the XML Schema. XML Schema resourcePath: " + tempFiles.get(0) + ".";
            log.error((Object)msg, (Throwable)ioe);
            throw new RegistryException(msg, (Throwable)ioe);
        }
    }

    private void makeDirs(File file) throws IOException {
        if (file != null && !file.exists() && !file.mkdirs()) {
            log.warn((Object)("Failed to create directories at path: " + file.getAbsolutePath()));
        }
    }

    protected SchemaProcessor buildSchemaProcessor(RequestContext requestContext, WSDLValidationInfo validationInfo) {
        return new SchemaProcessor(requestContext, validationInfo);
    }

    protected String processSchemaImport(RequestContext requestContext, String resourcePath, WSDLValidationInfo validationInfo) throws RegistryException {
        SchemaProcessor schemaProcessor = this.buildSchemaProcessor(requestContext, validationInfo);
        return schemaProcessor.importSchemaToRegistry(requestContext, resourcePath, this.getChrootedLocation(requestContext.getRegistryContext()), true, this.disableSymlinkCreation);
    }

    protected void onPutCompleted(String path, Map<String, String> addedResources, List<String> otherResources, RequestContext requestContext) throws RegistryException {
    }

    private String getChrootedLocation(RegistryContext registryContext) {
        return RegistryUtils.getAbsolutePath((RegistryContext)registryContext, (String)("/_system/governance" + this.location));
    }

    public void setDisableSchemaValidation(String disableSchemaValidation) {
        this.disableSchemaValidation = Boolean.toString(true).equals(disableSchemaValidation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(RequestContext requestContext) throws RegistryException {
        if (!CommonUtil.isUpdateLockAvailable()) {
            return;
        }
        CommonUtil.acquireUpdateLock();
        try {
            Registry registry = requestContext.getRegistry();
            ResourcePath resourcePath = requestContext.getResourcePath();
            if (resourcePath == null) {
                throw new RegistryException("The resource path is not available.");
            }
            Resource resource = registry.get(resourcePath.getPath());
        }
        finally {
            CommonUtil.releaseUpdateLock();
        }
    }
}

