/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.extensions.handlers;

import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.ResourcePath;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.handlers.Handler;
import org.wso2.carbon.registry.core.jdbc.handlers.RequestContext;
import org.wso2.carbon.registry.core.utils.RegistryUtils;

public class VersionContainerMediaTypeHandler
extends Handler {
    public void putChild(RequestContext requestContext) throws RegistryException {
        String path = requestContext.getResourcePath().getPath();
        Resource resource = requestContext.getResource();
        if (resource instanceof Collection) {
            String parentPath = resource.getParentPath();
            String newVersionNumber = RegistryUtils.getResourceName((String)path);
            if (!"application/vnd.wso2.versioned-collection".equals(resource.getMediaType())) {
                throw new RegistryException("Only Collections of type application/vnd.wso2.versioned-collection can be put into the collection: " + parentPath);
            }
            if (!newVersionNumber.matches("^(\\d+[.]*)+\\d+(-[a-zA-Z0-9]+)?$")) {
                throw new RegistryException("Version number should be in the format :<major no>.<minor no>.<patch no>");
            }
            Registry registry = requestContext.getRegistry();
            Resource parent = registry.get(parentPath);
            parent.setProperty("latest.version", newVersionNumber);
            registry.put(parentPath, parent);
        }
    }

    public void put(RequestContext requestContext) throws RegistryException {
        Registry registry = requestContext.getRegistry();
        ResourcePath containerPath = requestContext.getResourcePath();
        String latestVersionNumber = requestContext.getResource().getProperty("latest.version");
        if (latestVersionNumber == null) {
            return;
        }
        String latestVersionCollectionPath = containerPath + "/" + latestVersionNumber;
        if (registry.resourceExists(latestVersionCollectionPath)) {
            Collection latestVersionCollection = (Collection)registry.get(latestVersionCollectionPath);
            for (String childPath : latestVersionCollection.getChildren()) {
                String childName = RegistryUtils.getResourceName((String)childPath);
                registry.createLink(containerPath + "/" + childName, childPath);
            }
        }
    }
}

