/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.extensions.handlers;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.common.utils.artifact.manager.ArtifactManager;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.ResourceImpl;
import org.wso2.carbon.registry.core.config.RegistryContext;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.handlers.Handler;
import org.wso2.carbon.registry.core.jdbc.handlers.RequestContext;
import org.wso2.carbon.registry.core.session.CurrentSession;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.registry.extensions.services.Utils;
import org.wso2.carbon.registry.extensions.utils.CommonUtil;

public class PolicyMediaTypeHandler
extends Handler {
    private static final Log log = LogFactory.getLog(PolicyMediaTypeHandler.class);
    private String location = "/policies/";
    private String locationTag = "location";
    private OMElement locationConfiguration;
    private String identityPolicyPath = "/_system/config/repository/components/org.wso2.carbon.security.mgt/policy";

    public OMElement getPolicyLocationConfiguration() {
        return this.locationConfiguration;
    }

    public void setPolicyLocationConfiguration(OMElement locationConfiguration) throws RegistryException {
        Iterator confElements = locationConfiguration.getChildElements();
        while (confElements.hasNext()) {
            OMElement confElement = (OMElement)confElements.next();
            if (!confElement.getQName().equals(new QName(this.locationTag))) continue;
            this.location = confElement.getText();
            if (!this.location.startsWith("/")) {
                this.location = "/" + this.location;
            }
            if (this.location.endsWith("/")) continue;
            this.location = this.location + "/";
        }
        this.locationConfiguration = locationConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(RequestContext requestContext) throws RegistryException {
        if (!CommonUtil.isUpdateLockAvailable()) {
            return;
        }
        CommonUtil.acquireUpdateLock();
        try {
            String resourceContent;
            if (requestContext == null) {
                throw new RegistryException("The request context is not available.");
            }
            String path = requestContext.getResourcePath().getPath();
            Resource resource = requestContext.getResource();
            Registry registry = requestContext.getRegistry();
            Object resourceContentObj = resource.getContent();
            if (resourceContentObj instanceof String) {
                resourceContent = (String)resourceContentObj;
                resource.setContent((Object)RegistryUtils.encodeString((String)resourceContent));
            } else {
                resourceContent = RegistryUtils.decodeBytes((byte[])((byte[])resourceContentObj));
            }
            try {
                Resource oldResource;
                byte[] oldContent;
                if (registry.resourceExists(path) && (oldContent = (byte[])(oldResource = registry.get(path)).getContent()) != null && RegistryUtils.decodeBytes((byte[])oldContent).equals(resourceContent)) {
                    return;
                }
            }
            catch (Exception e) {
                String msg = "Error in comparing the policy content updates. policy path: " + path + ".";
                log.error((Object)msg, (Throwable)e);
                throw new RegistryException(msg, (Throwable)e);
            }
            byte[] newContent = RegistryUtils.encodeString((String)resourceContent);
            if (newContent != null) {
                ByteArrayInputStream inputStream = new ByteArrayInputStream(newContent);
                this.addPolicyToRegistry(requestContext, inputStream);
            }
            ArtifactManager.getArtifactManager().getTenantArtifactRepository().addArtifact(path);
        }
        finally {
            CommonUtil.releaseUpdateLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importResource(RequestContext requestContext) throws RegistryException {
        if (!CommonUtil.isUpdateLockAvailable()) {
            return;
        }
        CommonUtil.acquireUpdateLock();
        try {
            InputStream inputStream;
            String sourceURL = requestContext.getSourceURL();
            try {
                if (sourceURL != null && sourceURL.toLowerCase().startsWith("file:")) {
                    String msg = "The source URL must not be file in the server's local file system";
                    throw new RegistryException(msg);
                }
                inputStream = new URL(sourceURL).openStream();
            }
            catch (IOException e) {
                throw new RegistryException("The URL " + sourceURL + " is incorrect.", (Throwable)e);
            }
            this.addPolicyToRegistry(requestContext, inputStream);
        }
        finally {
            CommonUtil.releaseUpdateLock();
        }
    }

    private void addPolicyToRegistry(RequestContext requestContext, InputStream inputStream) throws RegistryException {
        Resource newResource;
        Resource policyResource;
        if (requestContext.getResource() == null) {
            policyResource = new ResourceImpl();
            policyResource.setMediaType("application/policy+xml");
        } else {
            policyResource = requestContext.getResource();
        }
        String version = requestContext.getResource().getProperty("version");
        if (version == null) {
            version = "1.0.0";
            requestContext.getResource().setProperty("version", version);
        }
        Registry registry = requestContext.getRegistry();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            int nextChar;
            while ((nextChar = inputStream.read()) != -1) {
                outputStream.write(nextChar);
            }
            outputStream.flush();
        }
        catch (IOException e) {
            throw new RegistryException("Exception occured while reading policy content", (Throwable)e);
        }
        try {
            AXIOMUtil.stringToOM((String)RegistryUtils.decodeBytes((byte[])outputStream.toByteArray())).toString();
        }
        catch (Exception e) {
            throw new RegistryException("The given policy file does not contain valid XML.");
        }
        String resourcePath = requestContext.getResourcePath().getPath();
        String policyFileName = resourcePath.substring(resourcePath.lastIndexOf("/") + 1);
        Registry systemRegistry = CommonUtil.getUnchrootedSystemRegistry(requestContext);
        RegistryContext registryContext = requestContext.getRegistryContext();
        String commonLocation = this.getChrootedLocation(registryContext);
        if (!systemRegistry.resourceExists(commonLocation)) {
            systemRegistry.put(commonLocation, (Resource)systemRegistry.newCollection());
        }
        String policyPath = this.isIdentityPolicyPath(requestContext) ? requestContext.getResourcePath().getCompletePath() : this.getPolicyLocation(requestContext, policyFileName, commonLocation, resourcePath, version);
        String relativeArtifactPath = RegistryUtils.getRelativePath((RegistryContext)registry.getRegistryContext(), (String)policyPath);
        relativeArtifactPath = RegistryUtils.getRelativePathToOriginal((String)relativeArtifactPath, (String)"/_system/governance");
        if (registry.resourceExists(policyPath)) {
            newResource = registry.get(policyPath);
        } else {
            newResource = new ResourceImpl();
            Properties properties = policyResource.getProperties();
            if (properties != null) {
                List<String> linkProperties = Arrays.asList("registry.link", "registry.user", "registry.mount", "registry.author", "registry.mountpoint", "registry.targetpoint", "registry.actualpath", "registry.realpath");
                for (Map.Entry<Object, Object> e : properties.entrySet()) {
                    String key = (String)e.getKey();
                    if (linkProperties.contains(key)) continue;
                    newResource.setProperty(key, (List)e.getValue());
                }
            }
        }
        newResource.setMediaType("application/policy+xml");
        if (policyResource.getProperty("resource.source") == null) {
            newResource.setProperty("resource.source", "Auto");
        } else {
            newResource.setProperty("resource.source", policyResource.getProperty("resource.source"));
        }
        String policyId = policyResource.getUUID();
        if (policyId == null) {
            policyId = UUID.randomUUID().toString();
        }
        newResource.setUUID(policyId);
        newResource.setContent((Object)outputStream.toByteArray());
        this.addPolicyToRegistry(requestContext, policyPath, requestContext.getSourceURL(), newResource, registry);
        ((ResourceImpl)newResource).setPath(relativeArtifactPath);
        String symlinkLocation = RegistryUtils.getAbsolutePath((RegistryContext)registryContext, (String)newResource.getProperty("SymlinkPropertyName"));
        if (symlinkLocation != null) {
            Resource resource = requestContext.getRegistry().get(symlinkLocation);
            if (resource != null) {
                String isLink = resource.getProperty("registry.link");
                String mountPoint = resource.getProperty("registry.mountpoint");
                String targetPoint = resource.getProperty("registry.targetpoint");
                String actualPath = resource.getProperty("registry.actualpath");
                if (isLink != null && mountPoint != null && targetPoint != null) {
                    symlinkLocation = actualPath + "/";
                }
            }
            requestContext.getSystemRegistry().createLink(symlinkLocation + policyFileName, policyPath);
        }
        requestContext.setResource(newResource);
        requestContext.setProcessingComplete(true);
    }

    private String getPolicyLocation(RequestContext requestContext, String policyFileName, String commonLocation, String resourcePath, String version) {
        if (Utils.getRxtService() != null && Utils.getRxtService().getStoragePath("application/policy+xml") != null) {
            String pathExpression = Utils.getRxtService().getStoragePath("application/policy+xml");
            pathExpression = CommonUtil.getPathFromPathExpression(pathExpression, requestContext.getResource().getProperties(), null);
            String policyPath = pathExpression = RegistryUtils.getAbsolutePath((RegistryContext)requestContext.getRegistryContext(), (String)CommonUtil.replaceExpressionOfPath(pathExpression, "name", this.extractResourceFromURL(policyFileName, ".xml")));
            if (CurrentSession.getLocalPathMap() != null && !Boolean.valueOf((String)CurrentSession.getLocalPathMap().get("archieve-upload")).booleanValue()) {
                policyPath = CommonUtil.getRegistryPath(requestContext.getRegistry().getRegistryContext(), pathExpression);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Saving current session local paths, key: " + policyPath + " | value: " + pathExpression));
                }
                CurrentSession.getLocalPathMap().put(policyPath, pathExpression);
            }
            return policyPath;
        }
        String policyPath = !resourcePath.startsWith(commonLocation) && !resourcePath.equals(RegistryUtils.getAbsolutePath((RegistryContext)requestContext.getRegistryContext(), (String)("/" + policyFileName))) && !resourcePath.equals(RegistryUtils.getAbsolutePath((RegistryContext)requestContext.getRegistryContext(), (String)("/_system/governance/" + policyFileName))) ? resourcePath : commonLocation + version + "/" + this.extractResourceFromURL(policyFileName, ".xml");
        return policyPath;
    }

    protected void addPolicyToRegistry(RequestContext context, String path, String url, Resource resource, Registry registry) throws RegistryException {
        context.setActualPath(path);
        registry.put(path, resource);
    }

    private String extractResourceFromURL(String policyURL, String suffix) {
        String resourceName = policyURL;
        if (policyURL.lastIndexOf("?") > 0) {
            resourceName = policyURL.substring(0, policyURL.indexOf("?")) + suffix;
        } else if (policyURL.indexOf(".") > 0) {
            resourceName = policyURL.substring(0, policyURL.lastIndexOf(".")) + suffix;
        } else if (!policyURL.endsWith(suffix)) {
            resourceName = policyURL + suffix;
        }
        return resourceName;
    }

    private String getChrootedLocation(RegistryContext registryContext) {
        return RegistryUtils.getAbsolutePath((RegistryContext)registryContext, (String)("/_system/governance" + this.location));
    }

    private boolean isIdentityPolicyPath(RequestContext requestContext) {
        return requestContext.getResourcePath() != null && requestContext.getResourcePath().getCompletePath().contains(this.identityPolicyPath);
    }
}

