/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.extensions.handlers;

import java.io.StringReader;
import java.util.UUID;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.ResourceImpl;
import org.wso2.carbon.registry.core.config.RegistryContext;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.handlers.Handler;
import org.wso2.carbon.registry.core.jdbc.handlers.RequestContext;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.registry.extensions.utils.CommonUtil;

public class PeopleMediaTypeHandler
extends Handler {
    private static final Log log = LogFactory.getLog(PeopleMediaTypeHandler.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(RequestContext requestContext) throws RegistryException {
        if (!CommonUtil.isUpdateLockAvailable()) {
            return;
        }
        CommonUtil.acquireUpdateLock();
        try {
            Resource oldResource;
            String oldContent;
            OMElement artifactInfoElement;
            Registry registry = requestContext.getRegistry();
            Resource resource = requestContext.getResource();
            if (resource == null) {
                throw new RegistryException("The resource is not available.");
            }
            String originalPath = requestContext.getResourcePath().getPath();
            String resourceName = RegistryUtils.getResourceName((String)originalPath);
            Object resourceContent = resource.getContent();
            String artifactInfo = resourceContent instanceof String ? (String)resourceContent : RegistryUtils.decodeBytes((byte[])((byte[])resourceContent));
            try {
                XMLStreamReader reader = XMLInputFactory.newInstance().createXMLStreamReader(new StringReader(artifactInfo));
                StAXOMBuilder builder = new StAXOMBuilder(reader);
                artifactInfoElement = builder.getDocumentElement();
            }
            catch (Exception e) {
                String msg = "Error in parsing the content of the people artifact. The requested path to store the artifact: " + originalPath + ".";
                log.error((Object)msg);
                throw new RegistryException(msg, (Throwable)e);
            }
            String personName = CommonUtil.getServiceName(artifactInfoElement);
            String peopleGroup = CommonUtil.getPeopleGroup(artifactInfoElement);
            String peopleType = CommonUtil.getPeopleType(artifactInfoElement);
            String artifactStorePath = RegistryUtils.getAbsolutePath((RegistryContext)registry.getRegistryContext(), (String)("/_system/governance/people/" + peopleGroup + "/" + peopleType + "/" + personName));
            String peopleArtifactId = resource.getUUID();
            if (peopleArtifactId == null) {
                peopleArtifactId = UUID.randomUUID().toString();
                resource.setUUID(peopleArtifactId);
            }
            if (registry.resourceExists(artifactStorePath) && artifactInfo.equals(oldContent = RegistryUtils.decodeBytes((byte[])((byte[])(oldResource = registry.get(artifactStorePath)).getContent())))) {
                return;
            }
            resource.setContent((Object)RegistryUtils.encodeString((String)artifactInfoElement.toString()));
            ((ResourceImpl)resource).prepareContentForPut();
            registry.put(artifactStorePath, resource);
            String symLinkLocation = RegistryUtils.getAbsolutePath((RegistryContext)requestContext.getRegistryContext(), (String)requestContext.getResource().getProperty("SymlinkPropertyName"));
            if (!artifactStorePath.equals(originalPath)) {
                Resource serviceResource = requestContext.getRegistry().get(RegistryUtils.getParentPath((String)originalPath));
                String isLink = serviceResource.getProperty("registry.link");
                String mountPoint = serviceResource.getProperty("registry.mountpoint");
                String targetPoint = serviceResource.getProperty("registry.targetpoint");
                String actualPath = serviceResource.getProperty("registry.actualpath");
                if (isLink != null && mountPoint != null && targetPoint != null) {
                    symLinkLocation = actualPath + "/";
                }
                if (symLinkLocation != null) {
                    registry.createLink(symLinkLocation + resourceName, artifactStorePath);
                }
            }
            requestContext.setProcessingComplete(true);
        }
        finally {
            CommonUtil.releaseUpdateLock();
        }
    }
}

