/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.extensions.handlers;

import java.util.List;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.handlers.Handler;
import org.wso2.carbon.registry.core.jdbc.handlers.RequestContext;
import org.wso2.carbon.registry.extensions.utils.CommonUtil;

public class ExtensionsSymLinkHandler
extends Handler {
    public void createLink(RequestContext requestContext) throws RegistryException {
        String symlinkPath = requestContext.getResourcePath().getPath();
        String targetResourcePath = requestContext.getTargetPath();
        if (requestContext.getRegistry().resourceExists(targetResourcePath)) {
            Resource r = requestContext.getRegistry().get(targetResourcePath);
            r.addProperty("registry.resource.symlink.path", symlinkPath);
            requestContext.getRegistry().put(targetResourcePath, r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(RequestContext requestContext) throws RegistryException {
        if (!CommonUtil.isUpdateLockAvailable()) {
            return;
        }
        CommonUtil.acquireUpdateLock();
        try {
            Resource resource = requestContext.getRegistry().get(requestContext.getResourcePath().getPath());
            List symlinkPaths = resource.getPropertyValues("registry.resource.symlink.path");
            if (symlinkPaths != null && symlinkPaths.size() > 0) {
                for (String symlinkPath : symlinkPaths) {
                    if (symlinkPath == null || !requestContext.getRegistry().resourceExists(symlinkPath)) continue;
                    requestContext.getRegistry().delete(symlinkPath);
                }
            }
        }
        finally {
            CommonUtil.releaseUpdateLock();
        }
    }
}

