/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.extensions.handlers;

import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.handlers.Handler;
import org.wso2.carbon.registry.core.jdbc.handlers.RequestContext;
import org.wso2.carbon.registry.extensions.handlers.RecursiveDeleteHandler;

public class DeleteHierarchyHandler
extends Handler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(RequestContext requestContext) throws RegistryException {
        if (!RecursiveDeleteHandler.isDeleteLockAvailable()) {
            return;
        }
        RecursiveDeleteHandler.acquireDeleteLock();
        try {
            Registry registry = requestContext.getRegistry();
            String parentPath = requestContext.getResource().getParentPath();
            Resource currentResource = registry.get(requestContext.getResource().getPath());
            if (currentResource instanceof Collection && ((Collection)currentResource).getChildCount() != 0) {
                String[] childPaths;
                for (String childPath : childPaths = ((Collection)currentResource).getChildren()) {
                    this.deleteChildRecursively(childPath, registry);
                }
            }
            registry.delete(requestContext.getResource().getPath());
            this.deleteRecursively(parentPath, registry);
            requestContext.setProcessingComplete(true);
        }
        finally {
            RecursiveDeleteHandler.releaseDeleteLock();
        }
    }

    private void deleteRecursively(String path, Registry registry) throws RegistryException {
        Resource currentResource = registry.get(path);
        if (currentResource instanceof Collection && ((Collection)currentResource).getChildCount() == 0) {
            registry.delete(path);
            this.deleteRecursively(currentResource.getParentPath(), registry);
        }
    }

    private void deleteChildRecursively(String path, Registry registry) throws RegistryException {
        Resource currentResource = registry.get(path);
        if (currentResource instanceof Collection && ((Collection)currentResource).getChildCount() == 0) {
            String[] childPaths;
            for (String childPath : childPaths = ((Collection)currentResource).getChildren()) {
                this.deleteChildRecursively(childPath, registry);
            }
            registry.delete(path);
        } else {
            registry.delete(path);
        }
    }
}

