/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.amqp.implementation;

import com.azure.core.amqp.exception.AmqpException;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.tracing.ProcessKind;
import com.azure.core.util.tracing.Tracer;
import java.util.Objects;
import reactor.core.publisher.Signal;

public class TracerProvider {
    private final ClientLogger logger = new ClientLogger(TracerProvider.class);
    private Tracer tracer;

    public TracerProvider(Iterable<Tracer> tracers) {
        Objects.requireNonNull(tracers, "'tracers' cannot be null.");
        if (tracers.iterator().hasNext()) {
            this.tracer = tracers.iterator().next();
        }
    }

    public boolean isEnabled() {
        return this.tracer != null;
    }

    public Context startSpan(String serviceBaseName, Context context, ProcessKind processKind) {
        if (this.tracer == null) {
            return context;
        }
        Objects.requireNonNull(context, "'context' cannot be null.");
        Objects.requireNonNull(processKind, "'processKind' cannot be null.");
        String spanName = this.getSpanName(serviceBaseName, processKind);
        return this.tracer.start(spanName, context, processKind);
    }

    public void endSpan(Context context, Signal<Void> signal) {
        if (this.tracer == null) {
            return;
        }
        Objects.requireNonNull(context, "'context' cannot be null.");
        Objects.requireNonNull(signal, "'signal' cannot be null.");
        switch (signal.getType()) {
            case ON_COMPLETE: {
                this.end("success", null, context);
                break;
            }
            case ON_ERROR: {
                String errorCondition = "";
                Throwable throwable = null;
                if (signal.hasError() && (throwable = signal.getThrowable()) instanceof AmqpException) {
                    AmqpException exception = (AmqpException)((Object)throwable);
                    errorCondition = exception.getErrorCondition().getErrorCondition();
                }
                this.end(errorCondition, throwable, context);
                break;
            }
        }
    }

    public void addSpanLinks(Context context) {
        if (this.tracer == null) {
            return;
        }
        Objects.requireNonNull(context, "'context' cannot be null.");
        this.tracer.addLink(context);
    }

    public Context extractContext(String diagnosticId, Context context) {
        if (this.tracer == null) {
            return context;
        }
        Objects.requireNonNull(context, "'context' cannot be null.");
        Objects.requireNonNull(diagnosticId, "'diagnosticId' cannot be null.");
        return this.tracer.extractContext(diagnosticId, context);
    }

    public Context getSharedSpanBuilder(String serviceBaseName, Context context) {
        if (this.tracer == null) {
            return context;
        }
        Objects.requireNonNull(context, "'context' cannot be null.");
        String spanName = this.getSpanName(serviceBaseName, ProcessKind.SEND);
        return this.tracer.getSharedSpanBuilder(spanName, context);
    }

    private void end(String statusMessage, Throwable throwable, Context context) {
        this.tracer.end(statusMessage, throwable, context);
    }

    private String getSpanName(String serviceBaseName, ProcessKind processKind) {
        switch (processKind) {
            case SEND: {
                serviceBaseName = serviceBaseName + "send";
                break;
            }
            case MESSAGE: {
                serviceBaseName = serviceBaseName + "message";
                break;
            }
            case PROCESS: {
                serviceBaseName = serviceBaseName + "process";
                break;
            }
            default: {
                this.logger.warning("Unknown processKind type: {}", new Object[]{processKind});
            }
        }
        return serviceBaseName;
    }
}

