/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.generic.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.util.XMLUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xerces.util.SecurityManager;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.utils.CarbonUtils;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Util {
    private static final Log log = LogFactory.getLog(Util.class);
    private static Validator serviceSchemaValidator = null;
    private static final int ENTITY_EXPANSION_LIMIT = 0;

    public static boolean validateOMContent(OMElement omContent, Validator validator) {
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(omContent.toString().getBytes("utf-8"));
            StreamSource xmlFile = new StreamSource(is);
            if (validator != null) {
                validator.validate(xmlFile);
            }
        }
        catch (SAXException e) {
            log.error((Object)"Unable to validate the given xml configuration ", (Throwable)e);
            return false;
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)"Unsupported content");
            return false;
        }
        catch (IOException e) {
            log.error((Object)"Unable to validate the given file");
            return false;
        }
        return true;
    }

    public static Validator getSchemaValidator(String schemaPath) {
        if (serviceSchemaValidator == null) {
            try {
                SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                Schema schema = schemaFactory.newSchema(new File(schemaPath));
                serviceSchemaValidator = schema.newValidator();
            }
            catch (SAXException e) {
                log.error((Object)("Unable to get a schema validator from the given file path : " + schemaPath));
            }
        }
        return serviceSchemaValidator;
    }

    public static String getServicesSchemaLocation() {
        return CarbonUtils.getCarbonHome() + File.separator + "repository" + File.separator + "resources" + File.separator + "service-ui-config.xsd";
    }

    public static void validateOMContent(OMElement element) throws RegistryException {
        if (!Util.validateOMContent(element, Util.getSchemaValidator(Util.getServicesSchemaLocation()))) {
            String message = "Unable to validate the xml configuration";
            log.error((Object)message);
            throw new RegistryException(message);
        }
    }

    public static OMElement buildOMElement(String payload) throws RegistryException {
        OMElement element = Util.getOMElementFromString(payload);
        element.build();
        return element;
    }

    public static OMElement getOMElementFromString(String payload) throws RegistryException {
        try {
            DocumentBuilderFactory dbf = Util.getSecuredDocumentBuilder();
            DocumentBuilder builder = dbf.newDocumentBuilder();
            Document document = builder.parse(new InputSource(new StringReader(payload)));
            return XMLUtils.toOM((Element)document.getDocumentElement());
        }
        catch (Exception e) {
            String message = "Unable to parse the XML configuration. Please validate the XML configuration";
            throw new RegistryException(message, (Throwable)e);
        }
    }

    public static DocumentBuilderFactory getSecuredDocumentBuilder() {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setXIncludeAware(false);
        dbf.setExpandEntityReferences(false);
        try {
            dbf.setFeature("http://xml.org/sax/features/external-general-entities", false);
            dbf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            dbf.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        }
        catch (ParserConfigurationException e) {
            log.error((Object)"Failed to load XML Processor Feature external-general-entities or external-parameter-entities or nonvalidating/load-external-dtd");
        }
        SecurityManager securityManager = new SecurityManager();
        securityManager.setEntityExpansionLimit(0);
        dbf.setAttribute("http://apache.org/xml/properties/security-manager", securityManager);
        return dbf;
    }
}

