/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.generic.util;

import javax.cache.Cache;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.governance.api.util.GovernanceUtils;
import org.wso2.carbon.governance.generic.util.Util;
import org.wso2.carbon.governance.list.util.CommonUtil;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.config.RegistryContext;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.utils.RegistryUtils;

public class GenericArtifactUtil {
    private static final Log log = LogFactory.getLog(GenericArtifactUtil.class);
    public static final String REL_RXT_BASE_PATH = "/_system/governance/repository/components/org.wso2.carbon.governance/types".split("/_system/governance")[1];

    public static boolean addRXTResource(String path, String rxtConfig, Registry registry) throws RegistryException {
        String rxtName = null;
        Resource resource = null;
        String rxtStoragePath = null;
        try {
            if (rxtConfig == null || rxtConfig.equals("")) {
                log.error((Object)"Failed to add RXT resource , because RXT content is null or empty");
                return false;
            }
            OMElement element = GenericArtifactUtil.buildOMElement(rxtConfig);
            if (!CommonUtil.validateXMLConfigOnSchema((String)RegistryUtils.decodeBytes((byte[])element.toString().getBytes()), (String)"rxt-ui-config")) {
                throw new RegistryException("Violation of RXT definition in configuration file, follow the schema correctly..!!");
            }
            if (element != null) {
                rxtName = element.getAttributeValue(new QName("shortName"));
            }
            if (rxtName == null || rxtName.equals("")) {
                return false;
            }
            if (RegistryUtils.isRegistryReadOnly((RegistryContext)registry.getRegistryContext())) {
                return false;
            }
            if (path == null) {
                resource = registry.newResource();
                rxtStoragePath = GenericArtifactUtil.getCalculatedRXTPath(rxtName);
            } else if (registry.resourceExists(GenericArtifactUtil.getGovernanceRelativePath(path))) {
                resource = registry.get(GenericArtifactUtil.getGovernanceRelativePath(path));
                rxtStoragePath = GenericArtifactUtil.getGovernanceRelativePath(path);
            }
            Cache rxtConfigCache = GovernanceUtils.getRXTConfigCache((String)"RXT_CONFIG_CACHE");
            resource.setContent((Object)element.toString().getBytes());
            resource.setMediaType("application/vnd.wso2.registry-ext-type+xml");
            registry.beginTransaction();
            registry.put(rxtStoragePath, resource);
            registry.commitTransaction();
            if (rxtConfigCache.containsKey((Object)rxtStoragePath)) {
                rxtConfigCache.put((Object)rxtStoragePath, (Object)((Boolean)rxtConfigCache.get((Object)rxtStoragePath) ^ true));
            } else {
                rxtConfigCache.put((Object)rxtStoragePath, (Object)true);
            }
        }
        catch (RegistryException e) {
            registry.rollbackTransaction();
            log.error((Object)("Error occurred while installing the RXT configuration " + rxtName), (Throwable)e);
            throw new RegistryException("Unable to store the rxt resource ", (Throwable)e);
        }
        catch (Exception e) {
            registry.rollbackTransaction();
            log.error((Object)("Error occurred while installing the RXT configuration " + rxtName), (Throwable)e);
            throw new RegistryException("Unable to store the rxt resource ", (Throwable)e);
        }
        return true;
    }

    public static OMElement buildOMElement(String payload) throws RegistryException {
        OMElement element = Util.getOMElementFromString(payload);
        element.build();
        return element;
    }

    public static String getRXTKeyFromContent(String payload) throws RegistryException {
        OMElement element = GenericArtifactUtil.buildOMElement(payload);
        return element.getAttributeValue(new QName("shortName"));
    }

    public static String getArtifactUIContentFromConfig(String payload) throws RegistryException {
        OMElement element = GenericArtifactUtil.buildOMElement(payload);
        OMElement content = element.getFirstChildWithName(new QName("content"));
        if (content != null) {
            return content.toString();
        }
        return null;
    }

    private static String getRXTNameFromShortName(String shortName) {
        return shortName + ".rxt";
    }

    private static String getGovernanceRelativePath(String absPath) {
        return absPath.split("/_system/governance")[1];
    }

    private static String getCalculatedRXTPath(String rxtName) {
        GenericArtifactUtil.getRXTNameFromShortName(rxtName);
        StringBuilder storage = new StringBuilder();
        storage.append(REL_RXT_BASE_PATH).append("/").append(rxtName).append(".rxt");
        return storage.toString();
    }

    public static String getArtifactViewRequestParams(String payload) throws Exception {
        String shortName = "";
        String singuLarLabel = "";
        String pluralLabel = "";
        OMElement element = GenericArtifactUtil.buildOMElement(payload);
        if (element != null) {
            shortName = element.getAttributeValue(new QName("shortName"));
            singuLarLabel = element.getAttributeValue(new QName("singularLabel"));
            pluralLabel = element.getAttributeValue(new QName("pluralLabel"));
        }
        String item = "governance_" + shortName + "_config_menu";
        String addEditItem = "governance_add_" + shortName + "_menu";
        return "region=region1" + "&" + "item=" + item + "&" + "key=" + shortName + "&" + "breadcrumb=" + pluralLabel.replaceAll(" ", "%20") + "&" + "add_edit_region=region3" + "&" + "add_edit_item=" + addEditItem + "&" + "lifecycleAttribute=null" + "&" + "add_edit_breadcrumb=" + singuLarLabel.replaceAll(" ", "%20") + "&" + "singularLabel=" + singuLarLabel.replaceAll(" ", "%20") + "&" + "pluralLabel=" + pluralLabel.replaceAll(" ", "%20");
    }
}

