/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.generic.services;

import java.io.StringReader;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.governance.api.common.dataobjects.GovernanceArtifact;
import org.wso2.carbon.governance.api.exception.GovernanceException;
import org.wso2.carbon.governance.api.generic.GenericArtifactManager;
import org.wso2.carbon.governance.api.generic.dataobjects.GenericArtifact;
import org.wso2.carbon.governance.api.generic.dataobjects.GenericArtifactImpl;
import org.wso2.carbon.governance.api.util.GovernanceArtifactConfiguration;
import org.wso2.carbon.governance.api.util.GovernanceUtils;
import org.wso2.carbon.governance.generic.beans.ArtifactBean;
import org.wso2.carbon.governance.generic.beans.ArtifactsBean;
import org.wso2.carbon.governance.generic.beans.ContentArtifactsBean;
import org.wso2.carbon.governance.generic.beans.StoragePathBean;
import org.wso2.carbon.governance.generic.util.GenericArtifactUtil;
import org.wso2.carbon.governance.generic.util.Util;
import org.wso2.carbon.governance.registry.extensions.utils.CommonUtil;
import org.wso2.carbon.registry.admin.api.governance.IManageGenericArtifactService;
import org.wso2.carbon.registry.api.RegistryException;
import org.wso2.carbon.registry.common.services.RegistryAbstractAdmin;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.ResourcePath;
import org.wso2.carbon.registry.core.config.RegistryContext;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.user.core.UserStoreException;

public class ManageGenericArtifactService
extends RegistryAbstractAdmin
implements IManageGenericArtifactService {
    private static final Log log = LogFactory.getLog(ManageGenericArtifactService.class);
    private static final String GOVERNANCE_ARTIFACT_CONFIGURATION_PATH = "/repository/components/org.wso2.carbon.governance/configuration/";

    public String addArtifact(String key, String info, String lifecycleAttribute) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        RegistryUtils.recordStatistics((Object[])new Object[]{key, info, lifecycleAttribute});
        Registry registry = this.getGovernanceUserRegistry();
        if (RegistryUtils.isRegistryReadOnly((RegistryContext)registry.getRegistryContext())) {
            return null;
        }
        try {
            String lifecycle;
            XMLInputFactory factory = XMLInputFactory.newInstance();
            factory.setProperty("javax.xml.stream.isCoalescing", true);
            XMLStreamReader reader = factory.createXMLStreamReader(new StringReader(info));
            GenericArtifactManager manager = new GenericArtifactManager(registry, key);
            GenericArtifact artifact = manager.newGovernanceArtifact(new StAXOMBuilder(reader).getDocumentElement());
            artifact.setContent(info.getBytes());
            artifact.setAttribute("resource.source", "AdminConsole");
            manager.addGenericArtifact(artifact);
            if (lifecycleAttribute != null && (lifecycle = artifact.getAttribute(lifecycleAttribute)) != null) {
                artifact.attachLifecycle(lifecycle);
            }
            return "/_system/governance" + artifact.getPath();
        }
        catch (Exception e) {
            String msg = "Unable to add artifact. ";
            if (e instanceof org.wso2.carbon.registry.core.exceptions.RegistryException) {
                throw (org.wso2.carbon.registry.core.exceptions.RegistryException)e;
            }
            if (e instanceof OMException) {
                msg = msg + "Unexpected character found in input-field name.";
                log.error((Object)msg, (Throwable)e);
                throw new org.wso2.carbon.registry.core.exceptions.RegistryException(msg, (Throwable)e);
            }
            throw new org.wso2.carbon.registry.core.exceptions.RegistryException(msg + (e.getCause() instanceof SQLException ? "" : e.getCause().getMessage()), (Throwable)e);
        }
    }

    public StoragePathBean getStoragePath(String key) {
        StoragePathBean bean = new StoragePathBean();
        try {
            GovernanceArtifactConfiguration configuration = GovernanceUtils.findGovernanceArtifactConfiguration((String)key, (Registry)this.getRootRegistry());
            bean.setStoragePath(configuration.getPathExpression());
            OMElement contentDefinition = configuration.getContentDefinition();
            Iterator fields = contentDefinition.getChildrenWithName(new QName("field"));
            LinkedList<String> names = new LinkedList<String>();
            LinkedList<String> labels = new LinkedList<String>();
            while (fields.hasNext()) {
                OMElement fieldElement = (OMElement)fields.next();
                OMElement nameElement = fieldElement.getFirstChildWithName(new QName("name"));
                String name = nameElement.getText();
                names.add(name);
                String label = nameElement.getAttributeValue(new QName("label"));
                labels.add(label != null ? label : name);
                bean.increment();
            }
            if (bean.getSize() > 0) {
                bean.setNames(names.toArray(new String[names.size()]));
                bean.setLabels(labels.toArray(new String[labels.size()]));
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            log.error((Object)"An error occurred while obtaining the storage path details.", (Throwable)e);
        }
        return bean;
    }

    private boolean nameMatches(GovernanceArtifact artifact, String criteria) throws GovernanceException {
        String name = this.getName(artifact);
        return name != null && name.contains(criteria);
    }

    private boolean lcMatches(GovernanceArtifact artifact, String LCName, String LCState, String LCInOut, String LCStateInOut) throws GovernanceException {
        String name = artifact.getLifecycleName();
        String state = artifact.getLifecycleState();
        if (LCName.equalsIgnoreCase("")) {
            return true;
        }
        if (!LCState.equalsIgnoreCase("")) {
            if (LCInOut.equalsIgnoreCase("in") && LCStateInOut.equalsIgnoreCase("in")) {
                return name != null && state != null && LCState.equalsIgnoreCase(state) && LCName.equalsIgnoreCase(name);
            }
            if (LCInOut.equalsIgnoreCase("in") && !LCStateInOut.equalsIgnoreCase("in")) {
                return name != null && state != null && !LCState.equalsIgnoreCase(state) && LCName.equalsIgnoreCase(name);
            }
            if (!LCInOut.equalsIgnoreCase("in") && LCStateInOut.equalsIgnoreCase("in")) {
                return name != null && state != null && LCState.equalsIgnoreCase(state) && !LCName.equalsIgnoreCase(name);
            }
            return name != null && state != null && !LCState.equalsIgnoreCase(state) && !LCName.equalsIgnoreCase(name);
        }
        if (LCInOut.equalsIgnoreCase("in")) {
            return name != null && LCName.equalsIgnoreCase(name);
        }
        return !LCName.equalsIgnoreCase(name);
    }

    private String getName(GovernanceArtifact artifact) {
        String local = artifact.getQName().getLocalPart();
        if (local != null && !"".equals(local)) {
            if (local.contains("\\.")) {
                return local.substring(0, local.lastIndexOf("\\."));
            }
            return local;
        }
        return local;
    }

    public ContentArtifactsBean listContentArtifacts(String mediaType) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        return this.listContentArtifactsByName(mediaType, null);
    }

    public ContentArtifactsBean listContentArtifactsByLC(String mediaType, String LCName, String LCState, String LCInOut, String LCStateInOut) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        GenericArtifact[] artifacts;
        RegistryUtils.recordStatistics((Object[])new Object[0]);
        if ("Any".equals(LCName)) {
            LCName = "*";
        }
        ContentArtifactsBean bean = new ContentArtifactsBean();
        UserRegistry registry = (UserRegistry)this.getGovernanceUserRegistry();
        GovernanceArtifactConfiguration configuration = GovernanceUtils.findGovernanceArtifactConfigurationByMediaType((String)mediaType, (Registry)this.getRootRegistry());
        GenericArtifactManager manager = new GenericArtifactManager((Registry)registry, configuration.getMediaType(), configuration.getArtifactNameAttribute(), configuration.getArtifactNamespaceAttribute(), configuration.getArtifactElementRoot(), configuration.getArtifactElementNamespace(), configuration.getPathExpression(), configuration.getRelationshipDefinitions());
        HashMap<String, List<String>> fields = new HashMap<String, List<String>>();
        if (LCName.length() > 0) {
            if (LCState.length() > 0) {
                fields.put(LCStateInOut.equalsIgnoreCase("in") ? "lcState" : "-lcState", Arrays.asList(LCState));
            }
            fields.put(LCInOut.equalsIgnoreCase("in") ? "lcName" : "-lcName", Arrays.asList(LCName));
        }
        if ((artifacts = manager.findGenericArtifacts(fields)) != null) {
            String[] names = new String[artifacts.length];
            String[] namespaces = new String[artifacts.length];
            boolean[] canDelete = new boolean[artifacts.length];
            String[] lifecycleName = new String[artifacts.length];
            String[] lifecycleState = new String[artifacts.length];
            String[] paths = new String[artifacts.length];
            for (GenericArtifact artifact : artifacts) {
                int i = bean.getSize();
                paths[i] = artifact.getPath();
                names[i] = artifact.getQName().getLocalPart();
                namespaces[i] = artifact.getQName().getNamespaceURI();
                lifecycleName[i] = artifact.getLifecycleName();
                lifecycleState[i] = artifact.getLifecycleState();
                if (registry.getUserRealm() != null && registry.getUserName() != null) {
                    try {
                        canDelete[i] = registry.getUserRealm().getAuthorizationManager().isUserAuthorized(registry.getUserName(), "/_system/governance" + paths[i], "http://www.wso2.org/projects/registry/actions/delete");
                    }
                    catch (UserStoreException userStoreException) {
                        // empty catch block
                    }
                }
                bean.increment();
            }
            bean.setName(names);
            bean.setNamespace(namespaces);
            bean.setPath(paths);
            bean.setCanDelete(canDelete);
            bean.setLCName(lifecycleName);
            bean.setLCState(lifecycleState);
        }
        return bean;
    }

    public ContentArtifactsBean listContentArtifactsByName(String mediaType, String criteria) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        RegistryUtils.recordStatistics((Object[])new Object[0]);
        ContentArtifactsBean bean = new ContentArtifactsBean();
        UserRegistry registry = (UserRegistry)this.getGovernanceUserRegistry();
        GovernanceArtifactConfiguration configuration = GovernanceUtils.findGovernanceArtifactConfigurationByMediaType((String)mediaType, (Registry)this.getRootRegistry());
        if (configuration == null) {
            return null;
        }
        GenericArtifactManager manager = new GenericArtifactManager((Registry)registry, configuration.getMediaType(), configuration.getArtifactNameAttribute(), configuration.getArtifactNamespaceAttribute(), configuration.getArtifactElementRoot(), configuration.getArtifactElementNamespace(), configuration.getPathExpression(), configuration.getRelationshipDefinitions());
        GenericArtifact[] artifacts = criteria == null ? manager.findGenericArtifacts(Collections.emptyMap()) : manager.findGenericArtifacts(Collections.singletonMap(configuration.getArtifactNameAttribute(), Arrays.asList(criteria)));
        if (artifacts != null) {
            String[] names = new String[artifacts.length];
            String[] namespaces = new String[artifacts.length];
            boolean[] canDelete = new boolean[artifacts.length];
            String[] lifecycleName = new String[artifacts.length];
            String[] lifecycleState = new String[artifacts.length];
            String[] paths = new String[artifacts.length];
            for (GenericArtifact artifact : artifacts) {
                int i = bean.getSize();
                paths[i] = artifact.getPath();
                names[i] = artifact.getQName().getLocalPart();
                namespaces[i] = artifact.getQName().getNamespaceURI();
                lifecycleName[i] = artifact.getLifecycleName();
                lifecycleState[i] = artifact.getLifecycleState();
                if (registry.getUserRealm() != null && registry.getUserName() != null) {
                    try {
                        canDelete[i] = registry.getUserRealm().getAuthorizationManager().isUserAuthorized(registry.getUserName(), "/_system/governance" + paths[i], "http://www.wso2.org/projects/registry/actions/delete");
                    }
                    catch (UserStoreException userStoreException) {
                        // empty catch block
                    }
                }
                bean.increment();
            }
            bean.setName(names);
            bean.setNamespace(namespaces);
            bean.setPath(paths);
            bean.setCanDelete(canDelete);
            bean.setLCName(lifecycleName);
            bean.setLCState(lifecycleState);
        }
        return bean;
    }

    private Map<String, List<String>> getFieldsList(GovernanceArtifact referenceArtifact, GovernanceArtifactConfiguration configuration) throws GovernanceException {
        if (referenceArtifact == null) {
            return Collections.emptyMap();
        }
        HashMap<String, List<String>> output = new HashMap<String, List<String>>();
        String[] keys = referenceArtifact.getAttributeKeys();
        boolean defaultNameMatched = false;
        boolean defaultNamespaceMatched = false;
        for (String key : keys) {
            String[] referenceValues;
            if ("operation".equals(key) || key.toLowerCase().contains("count") || (referenceValues = referenceArtifact.getAttributes(key)) == null) continue;
            if (!defaultNameMatched && key.equals(configuration.getArtifactNameAttribute()) && "C0E6D4A8-C446-4f01-99DB-70E212685A40".equalsIgnoreCase(referenceArtifact.getAttribute(configuration.getArtifactNameAttribute()))) {
                defaultNameMatched = true;
                continue;
            }
            if (!defaultNamespaceMatched && key.equals(configuration.getArtifactNamespaceAttribute()) && ".*".equals(referenceArtifact.getAttribute(configuration.getArtifactNamespaceAttribute()))) {
                defaultNamespaceMatched = true;
                continue;
            }
            output.put(key, Arrays.asList(referenceValues));
        }
        return output;
    }

    private GovernanceArtifactConfiguration loadAndFindGovernanceArtifactConfiguration(String key, Registry registry) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        List governanceArtifactConfigurations = GovernanceUtils.findGovernanceArtifactConfigurations((Registry)registry);
        GovernanceUtils.loadGovernanceArtifacts((UserRegistry)((UserRegistry)this.getGovernanceUserRegistry()), (List)governanceArtifactConfigurations);
        for (GovernanceArtifactConfiguration configuration : governanceArtifactConfigurations) {
            if (!key.equals(configuration.getKey())) continue;
            return configuration;
        }
        return null;
    }

    public ArtifactsBean listArtifacts(String key, String criteria) {
        RegistryUtils.recordStatistics((Object[])new Object[]{key, criteria});
        UserRegistry governanceRegistry = (UserRegistry)this.getGovernanceUserRegistry();
        ArtifactsBean bean = new ArtifactsBean();
        try {
            GenericArtifact referenceArtifact;
            GovernanceArtifactConfiguration configuration = this.loadAndFindGovernanceArtifactConfiguration(key, this.getRootRegistry());
            GenericArtifactManager manager = new GenericArtifactManager((Registry)governanceRegistry, configuration.getMediaType(), configuration.getArtifactNameAttribute(), configuration.getArtifactNamespaceAttribute(), configuration.getArtifactElementRoot(), configuration.getArtifactElementNamespace(), configuration.getPathExpression(), configuration.getRelationshipDefinitions());
            if (criteria != null) {
                XMLInputFactory factory = XMLInputFactory.newInstance();
                factory.setProperty("javax.xml.stream.isCoalescing", true);
                XMLStreamReader reader = factory.createXMLStreamReader(new StringReader(criteria));
                referenceArtifact = manager.newGovernanceArtifact(new StAXOMBuilder(reader).getDocumentElement());
            } else {
                referenceArtifact = null;
            }
            bean.setNames(configuration.getNamesOnListUI());
            bean.setTypes(configuration.getTypesOnListUI());
            bean.setKeys(configuration.getKeysOnListUI());
            String[] expressions = configuration.getExpressionsOnListUI();
            String[] keys = configuration.getKeysOnListUI();
            LinkedList<GenericArtifact> artifacts = new LinkedList<GenericArtifact>();
            artifacts.addAll(Arrays.asList(manager.findGenericArtifacts(this.getFieldsList((GovernanceArtifact)referenceArtifact, configuration))));
            LinkedList<ArtifactBean> artifactBeans = new LinkedList<ArtifactBean>();
            for (GovernanceArtifact governanceArtifact : artifacts) {
                boolean kk = false;
                ArtifactBean artifactBean = new ArtifactBean();
                ArrayList<String> paths = new ArrayList<String>();
                ArrayList<String> values = new ArrayList<String>();
                String path = "/_system/governance" + ((GenericArtifactImpl)governanceArtifact).getArtifactPath();
                artifactBean.setPath(path);
                for (int i = 0; i < expressions.length; ++i) {
                    if (expressions[i] != null) {
                        if (expressions[i].contains("@{storagePath}") && ((GenericArtifactImpl)governanceArtifact).getArtifactPath() != null) {
                            paths.add("/_system/governance" + GovernanceUtils.getPathFromPathExpression((String)expressions[i], (GovernanceArtifact)governanceArtifact, (String)((GenericArtifactImpl)governanceArtifact).getArtifactPath()));
                            continue;
                        }
                        if ("link".equals(bean.getTypes()[i])) {
                            paths.add(GovernanceUtils.getPathFromPathExpression((String)expressions[i], (GovernanceArtifact)governanceArtifact, (String)configuration.getPathExpression()));
                            continue;
                        }
                        paths.add("/_system/governance" + GovernanceUtils.getPathFromPathExpression((String)expressions[i], (GovernanceArtifact)governanceArtifact, (String)configuration.getPathExpression()));
                        continue;
                    }
                    paths.add("");
                }
                artifactBean.setValuesB(paths.toArray(new String[paths.size()]));
                for (String keyForValue : keys) {
                    if (keyForValue != null) {
                        values.add(governanceArtifact.getAttribute(keyForValue));
                        continue;
                    }
                    values.add("");
                }
                artifactBean.setValuesA(values.toArray(new String[values.size()]));
                artifactBean.setCanDelete(governanceRegistry.getUserRealm().getAuthorizationManager().isUserAuthorized(governanceRegistry.getUserName(), path, "http://www.wso2.org/projects/registry/actions/delete"));
                artifactBean.setLCName(((GenericArtifactImpl)governanceArtifact).getLcName());
                artifactBean.setLCState(((GenericArtifactImpl)governanceArtifact).getLcState());
                artifactBean.setCreatedDate(governanceRegistry.get(((GenericArtifactImpl)governanceArtifact).getArtifactPath()).getCreatedTime());
                artifactBean.setLastUpdatedDate(governanceRegistry.get(((GenericArtifactImpl)governanceArtifact).getArtifactPath()).getLastModified());
                artifactBean.setCreatedBy(governanceRegistry.get(((GenericArtifactImpl)governanceArtifact).getArtifactPath()).getAuthorUserName());
                artifactBean.setLastUpdatedBy(governanceRegistry.get(((GenericArtifactImpl)governanceArtifact).getArtifactPath()).getLastUpdaterUserName());
                artifactBeans.add(artifactBean);
            }
            bean.setArtifacts(artifactBeans.toArray(new ArtifactBean[artifactBeans.size()]));
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            log.error((Object)"An error occurred while obtaining the list of artifacts.", (Throwable)e);
        }
        return bean;
    }

    public ArtifactsBean listArtifactsByLC(String key, String LCName, String LCState, String LCInOut, String LCStateInOut) {
        RegistryUtils.recordStatistics((Object[])new Object[]{key});
        if ("Any".equals(LCName)) {
            LCName = "*";
        }
        UserRegistry governanceRegistry = (UserRegistry)this.getGovernanceUserRegistry();
        ArtifactsBean bean = new ArtifactsBean();
        try {
            GovernanceArtifactConfiguration configuration = this.loadAndFindGovernanceArtifactConfiguration(key, this.getRootRegistry());
            GenericArtifactManager manager = new GenericArtifactManager((Registry)governanceRegistry, configuration.getMediaType(), configuration.getArtifactNameAttribute(), configuration.getArtifactNamespaceAttribute(), configuration.getArtifactElementRoot(), configuration.getArtifactElementNamespace(), configuration.getPathExpression(), configuration.getRelationshipDefinitions());
            HashMap<String, List<String>> fields = new HashMap<String, List<String>>();
            if (LCName.length() > 0) {
                if (LCState.length() > 0) {
                    fields.put(LCStateInOut.equalsIgnoreCase("in") ? "lcState" : "-lcState", Arrays.asList(LCState.toLowerCase()));
                }
                fields.put(LCInOut.equalsIgnoreCase("in") ? "lcName" : "-lcName", Arrays.asList(LCName.toLowerCase()));
            }
            GenericArtifact[] artifacts = manager.findGenericArtifacts(fields);
            bean.setNames(configuration.getNamesOnListUI());
            bean.setTypes(configuration.getTypesOnListUI());
            bean.setKeys(configuration.getKeysOnListUI());
            String[] expressions = configuration.getExpressionsOnListUI();
            String[] keys = configuration.getKeysOnListUI();
            if (artifacts != null) {
                LinkedList<ArtifactBean> artifactBeans = new LinkedList<ArtifactBean>();
                for (GenericArtifact artifact : artifacts) {
                    ArtifactBean artifactBean = new ArtifactBean();
                    ArrayList<String> paths = new ArrayList<String>();
                    ArrayList<String> values = new ArrayList<String>();
                    String path = "/_system/governance" + artifact.getPath();
                    artifactBean.setPath(path);
                    for (String expression : expressions) {
                        if (expression != null) {
                            if (expression.contains("@{storagePath}") && artifact.getPath() != null) {
                                paths.add("/_system/governance" + GovernanceUtils.getPathFromPathExpression((String)expression, (GovernanceArtifact)artifact, (String)artifact.getPath()));
                                continue;
                            }
                            paths.add("/_system/governance" + GovernanceUtils.getPathFromPathExpression((String)expression, (GovernanceArtifact)artifact, (String)configuration.getPathExpression()));
                            continue;
                        }
                        paths.add("");
                    }
                    artifactBean.setValuesB(paths.toArray(new String[paths.size()]));
                    for (String keyForValue : keys) {
                        if (keyForValue != null) {
                            values.add(artifact.getAttribute(keyForValue));
                            continue;
                        }
                        values.add("");
                    }
                    artifactBean.setValuesA(values.toArray(new String[values.size()]));
                    artifactBean.setCanDelete(governanceRegistry.getUserRealm().getAuthorizationManager().isUserAuthorized(governanceRegistry.getUserName(), path, "http://www.wso2.org/projects/registry/actions/delete"));
                    artifactBean.setLCName(artifact.getLifecycleName());
                    artifactBean.setLCState(artifact.getLifecycleState());
                    artifactBean.setCreatedDate(governanceRegistry.get(((GenericArtifactImpl)artifact).getArtifactPath()).getCreatedTime());
                    artifactBean.setLastUpdatedDate(governanceRegistry.get(((GenericArtifactImpl)artifact).getArtifactPath()).getLastModified());
                    artifactBean.setCreatedBy(governanceRegistry.get(((GenericArtifactImpl)artifact).getArtifactPath()).getAuthorUserName());
                    artifactBean.setLastUpdatedBy(governanceRegistry.get(((GenericArtifactImpl)artifact).getArtifactPath()).getLastUpdaterUserName());
                    artifactBeans.add(artifactBean);
                }
                bean.setArtifacts(artifactBeans.toArray(new ArtifactBean[artifactBeans.size()]));
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            log.error((Object)"An error occurred while obtaining the list of artifacts.", (Throwable)e);
        }
        return bean;
    }

    public String editArtifact(String path, String key, String info, String lifecycleAttribute) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        RegistryUtils.recordStatistics((Object[])new Object[]{path, key, info, lifecycleAttribute});
        Registry registry = this.getGovernanceUserRegistry();
        if (RegistryUtils.isRegistryReadOnly((RegistryContext)registry.getRegistryContext())) {
            return null;
        }
        try {
            XMLInputFactory factory = XMLInputFactory.newInstance();
            factory.setProperty("javax.xml.stream.isCoalescing", true);
            XMLStreamReader reader = factory.createXMLStreamReader(new StringReader(info));
            GovernanceArtifactConfiguration configuration = this.loadAndFindGovernanceArtifactConfiguration(key, this.getRootRegistry());
            GenericArtifactManager manager = new GenericArtifactManager(registry, key);
            GenericArtifact artifact = manager.newGovernanceArtifact(new StAXOMBuilder(reader).getDocumentElement());
            String currentPath = path != null && path.length() > 0 ? path.substring("/_system/governance".length()) : GovernanceUtils.getPathFromPathExpression((String)configuration.getPathExpression(), (GovernanceArtifact)artifact);
            if (registry.resourceExists(currentPath)) {
                GovernanceArtifact oldArtifact = GovernanceUtils.retrieveGovernanceArtifactByPath((Registry)registry, (String)currentPath);
                if (!(oldArtifact instanceof GovernanceArtifact)) {
                    String msg = "The updated path is occupied by a non-generic artifact. path: " + currentPath + ".";
                    log.error((Object)msg);
                    throw new Exception(msg);
                }
                artifact.setId(oldArtifact.getId());
                artifact.setContent(info.getBytes());
                manager.updateGenericArtifact(artifact);
            } else {
                manager.addGenericArtifact(artifact);
            }
            if (lifecycleAttribute != null && !lifecycleAttribute.equals("null")) {
                String lifecycle = artifact.getAttribute(lifecycleAttribute);
                artifact.attachLifecycle(lifecycle);
            }
            return "/_system/governance" + artifact.getPath();
        }
        catch (Exception e) {
            String msg = "Unable to edit artifact. ";
            if (e instanceof org.wso2.carbon.registry.core.exceptions.RegistryException) {
                throw (org.wso2.carbon.registry.core.exceptions.RegistryException)e;
            }
            if (e instanceof OMException) {
                msg = msg + "Unexpected character found in input-field name.";
                log.error((Object)msg, (Throwable)e);
                throw new org.wso2.carbon.registry.core.exceptions.RegistryException(msg, (Throwable)e);
            }
            throw new org.wso2.carbon.registry.core.exceptions.RegistryException(msg + (e.getCause() instanceof SQLException ? "" : e.getCause().getMessage()), (Throwable)e);
        }
    }

    public String getArtifactContent(String path) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        Registry registry = this.getGovernanceUserRegistry();
        if (!registry.resourceExists(new ResourcePath(path).getPath())) {
            return null;
        }
        return RegistryUtils.decodeBytes((byte[])((byte[])registry.get(path).getContent()));
    }

    public String getArtifactUIConfiguration(String key) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        try {
            key = key.replaceAll("\\s+", "");
            Registry registry = this.getConfigSystemRegistry();
            return RegistryUtils.decodeBytes((byte[])((byte[])registry.get(GOVERNANCE_ARTIFACT_CONFIGURATION_PATH + key).getContent()));
        }
        catch (Exception e) {
            log.error((Object)"An error occurred while obtaining configuration", (Throwable)e);
            return null;
        }
    }

    public boolean setArtifactUIConfiguration(String key, String update) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        Registry registry = this.getConfigSystemRegistry();
        if (RegistryUtils.isRegistryReadOnly((RegistryContext)registry.getRegistryContext())) {
            return false;
        }
        try {
            Util.validateOMContent(Util.buildOMElement(update));
            String path = GOVERNANCE_ARTIFACT_CONFIGURATION_PATH + key;
            if (registry.resourceExists(path)) {
                Resource resource = registry.get(path);
                resource.setContent((Object)update);
                registry.put(path, resource);
            }
            return true;
        }
        catch (Exception e) {
            log.error((Object)"An error occurred while saving configuration", (Throwable)e);
            return false;
        }
    }

    public boolean canChange(String path) throws Exception {
        UserRegistry registry = (UserRegistry)this.getRootRegistry();
        if (registry.getUserName() != null && registry.getUserRealm() != null && registry.getUserRealm().getAuthorizationManager().isUserAuthorized(registry.getUserName(), path, "http://www.wso2.org/projects/registry/actions/add")) {
            Resource resource = registry.get(path);
            String property = resource.getProperty("registry.retention.writeLocked");
            return property == null || !Boolean.parseBoolean(property) || registry.getUserName().equals(resource.getProperty("registry.retention.user.name"));
        }
        return false;
    }

    public String[] getAvailableAspects() throws Exception {
        return GovernanceUtils.getAvailableAspects();
    }

    public ArtifactsBean listArtifactsByName(String key, String name) {
        RegistryUtils.recordStatistics((Object[])new Object[]{key});
        UserRegistry governanceRegistry = (UserRegistry)this.getGovernanceUserRegistry();
        ArtifactsBean bean = new ArtifactsBean();
        try {
            GovernanceArtifactConfiguration configuration = this.loadAndFindGovernanceArtifactConfiguration(key, this.getRootRegistry());
            GenericArtifactManager manager = new GenericArtifactManager((Registry)governanceRegistry, configuration.getMediaType(), configuration.getArtifactNameAttribute(), configuration.getArtifactNamespaceAttribute(), configuration.getArtifactElementRoot(), configuration.getArtifactElementNamespace(), configuration.getPathExpression(), configuration.getRelationshipDefinitions());
            GenericArtifact[] artifacts = manager.findGenericArtifacts(Collections.singletonMap(configuration.getArtifactNameAttribute(), Arrays.asList(name)));
            bean.setNames(configuration.getNamesOnListUI());
            bean.setTypes(configuration.getTypesOnListUI());
            String[] expressions = configuration.getExpressionsOnListUI();
            String[] keys = configuration.getKeysOnListUI();
            if (artifacts != null) {
                LinkedList<ArtifactBean> artifactBeans = new LinkedList<ArtifactBean>();
                for (GenericArtifact artifact : artifacts) {
                    ArtifactBean artifactBean = new ArtifactBean();
                    ArrayList<String> paths = new ArrayList<String>();
                    ArrayList<String> values = new ArrayList<String>();
                    String path = "/_system/governance" + artifact.getPath();
                    artifactBean.setPath(path);
                    for (String expression : expressions) {
                        if (expression != null) {
                            if (expression.contains("@{storagePath}") && artifact.getPath() != null) {
                                paths.add("/_system/governance" + GovernanceUtils.getPathFromPathExpression((String)expression, (GovernanceArtifact)artifact, (String)artifact.getPath()));
                                continue;
                            }
                            paths.add("/_system/governance" + GovernanceUtils.getPathFromPathExpression((String)expression, (GovernanceArtifact)artifact, (String)configuration.getPathExpression()));
                            continue;
                        }
                        paths.add("");
                    }
                    artifactBean.setValuesB(paths.toArray(new String[paths.size()]));
                    for (String keyForValue : keys) {
                        if (keyForValue != null) {
                            values.add(artifact.getAttribute(keyForValue));
                            continue;
                        }
                        values.add("");
                    }
                    artifactBean.setValuesA(values.toArray(new String[values.size()]));
                    artifactBean.setCanDelete(governanceRegistry.getUserRealm().getAuthorizationManager().isUserAuthorized(governanceRegistry.getUserName(), path, "http://www.wso2.org/projects/registry/actions/delete"));
                    artifactBean.setLCName(artifact.getLifecycleName());
                    artifactBean.setLCState(artifact.getLifecycleState());
                    artifactBean.setCreatedDate(governanceRegistry.get(((GenericArtifactImpl)artifact).getArtifactPath()).getCreatedTime());
                    artifactBean.setLastUpdatedDate(governanceRegistry.get(((GenericArtifactImpl)artifact).getArtifactPath()).getLastModified());
                    artifactBean.setCreatedBy(governanceRegistry.get(((GenericArtifactImpl)artifact).getArtifactPath()).getAuthorUserName());
                    artifactBean.setLastUpdatedBy(governanceRegistry.get(((GenericArtifactImpl)artifact).getArtifactPath()).getLastUpdaterUserName());
                    artifactBeans.add(artifactBean);
                }
                bean.setArtifacts(artifactBeans.toArray(new ArtifactBean[artifactBeans.size()]));
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            log.error((Object)"An error occurred while obtaining the list of artifacts.", (Throwable)e);
        }
        return bean;
    }

    public boolean addRXTResource(String rxtConfig, String path) throws org.wso2.carbon.registry.core.exceptions.RegistryException {
        boolean result = GenericArtifactUtil.addRXTResource(path, rxtConfig, this.getGovernanceUserRegistry());
        this.setArtifactUIConfiguration(GenericArtifactUtil.getRXTKeyFromContent(rxtConfig), GenericArtifactUtil.getArtifactUIContentFromConfig(rxtConfig));
        return result;
    }

    public String getRxtAbsPathFromRxtName(String rxtName) {
        return "/_system/governance/repository/components/org.wso2.carbon.governance/types" + "/" + rxtName + ".rxt";
    }

    public String getArtifactViewRequestParams(String key) throws Exception {
        return GenericArtifactUtil.getArtifactViewRequestParams(this.getArtifactContent(GenericArtifactUtil.REL_RXT_BASE_PATH + "/" + key + ".rxt"));
    }

    public String[] getAllLifeCycleState(String LCName) {
        String[] LifeCycleStates = null;
        try {
            LifeCycleStates = CommonUtil.getAllLifeCycleStates((Registry)this.getRootRegistry(), (String)LCName);
        }
        catch (RegistryException e) {
            log.error((Object)("An error occurred while obtaining the list of states in " + LCName), (Throwable)e);
        }
        return LifeCycleStates;
    }
}

