/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.flow.internal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.event.flow.internal.EventFlowServiceValueHolder;
import org.wso2.carbon.event.processor.core.EventProcessorService;
import org.wso2.carbon.event.publisher.core.EventPublisherService;
import org.wso2.carbon.event.receiver.core.EventReceiverService;
import org.wso2.carbon.event.stream.core.EventStreamService;

@Component(name="eventFlowService.component", immediate=true)
public class EventFlowServiceDS {
    private static final Log log = LogFactory.getLog(EventFlowServiceDS.class);

    @Activate
    protected void activate(ComponentContext context) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Successfully deployed Event Flow Service.");
        }
    }

    @Reference(name="eventStreamManager.service", service=EventStreamService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetEventStreamService")
    protected void setEventStreamService(EventStreamService eventStreamService) {
        EventFlowServiceValueHolder.registerEventStreamService(eventStreamService);
    }

    protected void unsetEventStreamService(EventStreamService eventStreamService) {
        EventFlowServiceValueHolder.registerEventStreamService(null);
    }

    @Reference(name="eventProcessor.service", service=EventProcessorService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetEventProcessorService")
    protected void setEventProcessorService(EventProcessorService eventProcessorService) {
        EventFlowServiceValueHolder.registerEventProcessorService(eventProcessorService);
    }

    protected void unsetEventProcessorService(EventProcessorService eventProcessorService) {
        EventFlowServiceValueHolder.registerEventProcessorService(null);
    }

    @Reference(name="eventReceiver.service", service=EventReceiverService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetEventReceiverService")
    protected void setEventReceiverService(EventReceiverService eventReceiverService) {
        EventFlowServiceValueHolder.registerEventReceiverService(eventReceiverService);
    }

    protected void unsetEventReceiverService(EventReceiverService eventReceiverService) {
        EventFlowServiceValueHolder.registerEventReceiverService(null);
    }

    @Reference(name="eventPublisher.service", service=EventPublisherService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetEventPublisherService")
    protected void setEventPublisherService(EventPublisherService eventPublisherService) {
        EventFlowServiceValueHolder.registerEventPublisherService(eventPublisherService);
    }

    protected void unsetEventPublisherService(EventPublisherService eventPublisherService) {
        EventFlowServiceValueHolder.registerEventPublisherService(null);
    }
}

