/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.flow;

import java.util.List;
import java.util.Map;
import org.apache.axis2.AxisFault;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.event.flow.internal.EventFlowServiceValueHolder;
import org.wso2.carbon.event.processor.core.ExecutionPlanConfiguration;
import org.wso2.carbon.event.processor.core.StreamConfiguration;
import org.wso2.carbon.event.publisher.core.config.EventPublisherConfiguration;
import org.wso2.carbon.event.receiver.core.config.EventReceiverConfiguration;

public class EventFlowAdminService
extends AbstractAdmin {
    private static final Log log = LogFactory.getLog(EventFlowAdminService.class);

    public String getEventFlow() throws AxisFault {
        try {
            String url;
            AxisConfiguration axisConfiguration = this.getAxisConfig();
            int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
            List eventReceiverConfigurations = EventFlowServiceValueHolder.getEventReceiverService().getAllActiveEventReceiverConfigurations();
            List eventPublisherConfigurations = EventFlowServiceValueHolder.getEventPublisherService().getAllActiveEventPublisherConfigurations();
            List streamIds = EventFlowServiceValueHolder.getEventStreamService().getStreamIds();
            Map executionPlanConfigurations = EventFlowServiceValueHolder.getEventProcessorService().getAllActiveExecutionConfigurations();
            StringBuilder eventFlow = new StringBuilder(" '{ \"nodes\": [ ");
            for (EventReceiverConfiguration receiverConfiguration : eventReceiverConfigurations) {
                url = "../eventreceiver/eventReceiver_details.jsp?ordinal=1&eventReceiverName=" + receiverConfiguration.getEventReceiverName();
                eventFlow.append("  { \"id\": \"").append(receiverConfiguration.getEventReceiverName().toUpperCase()).append("_ER").append("\", \"label\":\"").append(receiverConfiguration.getEventReceiverName()).append("\", \"url\":\"").append(url).append("\", \"nodeclass\": \"ER\" },");
            }
            for (String name : executionPlanConfigurations.keySet()) {
                url = "../eventprocessor/execution_plan_details.jsp?ordinal=1&execPlan=" + name;
                eventFlow.append("  { \"id\": \"").append(name.toUpperCase()).append("_EXP").append("\", \"label\":\"").append(name).append("\", \"url\":\"").append(url).append("\", \"nodeclass\": \"EXP\" },");
            }
            for (EventPublisherConfiguration publisherConfiguration : eventPublisherConfigurations) {
                url = "../eventpublisher/eventPublisher_details.jsp?ordinal=1&eventPublisherName=" + publisherConfiguration.getEventPublisherName();
                eventFlow.append("  { \"id\": \"").append(publisherConfiguration.getEventPublisherName().toUpperCase()).append("_EP").append("\", \"label\":\"").append(publisherConfiguration.getEventPublisherName()).append("\", \"url\":\"").append(url).append("\", \"nodeclass\": \"EP\" },");
            }
            for (String streamId : streamIds) {
                url = "../eventstream/eventStreamDetails.jsp?ordinal=1&eventStreamWithVersion=" + streamId;
                eventFlow.append("  { \"id\": \"").append(streamId.replaceAll("\\.", "_").replaceAll(":", "_").toUpperCase()).append("_ES").append("\", \"label\":\"").append(streamId).append("\", \"url\":\"").append(url).append("\", \"nodeclass\": \"ES\" },");
            }
            eventFlow = new StringBuilder(eventFlow.substring(0, eventFlow.length() - 1));
            eventFlow.append("], \"edges\": [ ");
            for (EventReceiverConfiguration receiverConfiguration : eventReceiverConfigurations) {
                eventFlow.append("  { \"from\": \"").append(receiverConfiguration.getEventReceiverName().toUpperCase()).append("_ER").append("\", \"to\":\"").append((receiverConfiguration.getToStreamName() + ":" + receiverConfiguration.getToStreamVersion()).replaceAll("\\.", "_").replaceAll(":", "_").toUpperCase()).append("_ES").append("\" },");
            }
            for (ExecutionPlanConfiguration executionPlanConfiguration : executionPlanConfigurations.values()) {
                for (StreamConfiguration streamConfiguration : executionPlanConfiguration.getImportedStreams()) {
                    eventFlow.append("  { \"from\": \"").append(streamConfiguration.getStreamId().replaceAll("\\.", "_").replaceAll(":", "_").toUpperCase()).append("_ES").append("\", \"to\":\"").append(executionPlanConfiguration.getName().toUpperCase()).append("_EXP").append("\" },");
                }
                for (StreamConfiguration streamConfiguration : executionPlanConfiguration.getExportedStreams()) {
                    eventFlow.append("  { \"to\": \"").append(streamConfiguration.getStreamId().replaceAll("\\.", "_").replaceAll(":", "_").toUpperCase()).append("_ES").append("\", \"from\":\"").append(executionPlanConfiguration.getName().toUpperCase()).append("_EXP").append("\" },");
                }
            }
            for (EventPublisherConfiguration publisherConfiguration : eventPublisherConfigurations) {
                eventFlow.append("  { \"from\": \"").append((publisherConfiguration.getFromStreamName() + ":" + publisherConfiguration.getFromStreamVersion()).replaceAll("\\.", "_").replaceAll(":", "_").toUpperCase()).append("_ES").append("\", \"to\":\"").append(publisherConfiguration.getEventPublisherName().toUpperCase()).append("_EP").append("\" },");
            }
            eventFlow = new StringBuilder(eventFlow.substring(0, eventFlow.length() - 1));
            eventFlow.append("]}'");
            return eventFlow.toString();
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new AxisFault("Exception:" + e.getMessage());
        }
    }
}

