/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.entitlement.wsxacml;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.security.PrivateKey;
import java.security.cert.CertificateEncodingException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.rpc.receivers.RPCMessageReceiver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.Init;
import org.joda.time.DateTime;
import org.opensaml.core.config.InitializationException;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectBuilder;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.Marshaller;
import org.opensaml.core.xml.io.MarshallerFactory;
import org.opensaml.core.xml.io.Unmarshaller;
import org.opensaml.core.xml.io.UnmarshallerFactory;
import org.opensaml.saml.common.SAMLVersion;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.core.Statement;
import org.opensaml.saml.saml2.core.impl.AssertionBuilder;
import org.opensaml.saml.saml2.core.impl.IssuerBuilder;
import org.opensaml.saml.saml2.core.impl.ResponseBuilder;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.x509.BasicX509Credential;
import org.opensaml.security.x509.X509Credential;
import org.opensaml.xacml.ctx.RequestType;
import org.opensaml.xacml.ctx.ResponseType;
import org.opensaml.xacml.profile.saml.XACMLAuthzDecisionQueryType;
import org.opensaml.xacml.profile.saml.XACMLAuthzDecisionStatementType;
import org.opensaml.xacml.profile.saml.impl.XACMLAuthzDecisionStatementTypeImplBuilder;
import org.opensaml.xmlsec.signature.KeyInfo;
import org.opensaml.xmlsec.signature.Signature;
import org.opensaml.xmlsec.signature.X509Certificate;
import org.opensaml.xmlsec.signature.X509Data;
import org.opensaml.xmlsec.signature.support.SignatureException;
import org.opensaml.xmlsec.signature.support.SignatureValidator;
import org.opensaml.xmlsec.signature.support.Signer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;
import org.wso2.carbon.core.util.KeyStoreManager;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.entitlement.EntitlementException;
import org.wso2.carbon.identity.entitlement.wsxacml.X509CredentialImpl;
import org.wso2.carbon.identity.entitlement.wsxacml.XACMLHandler;
import org.wso2.carbon.identity.saml.common.util.SAMLInitializer;

public class WSXACMLMessageReceiver
extends RPCMessageReceiver {
    private static Log log = LogFactory.getLog(WSXACMLMessageReceiver.class);
    private static boolean isBootStrapped = false;
    private static OMNamespace xacmlContextNS = OMAbstractFactory.getOMFactory().createOMNamespace("urn:oasis:names:tc:xacml:2.0:context:schema:os", "xacml-context");

    public static void doBootstrap() {
        if (!isBootStrapped) {
            try {
                SAMLInitializer.doBootstrap();
                isBootStrapped = true;
            }
            catch (InitializationException e) {
                log.error((Object)"Error in bootstrapping the OpenSAML3 library", (Throwable)e);
            }
        }
    }

    private static Issuer createIssuer() {
        IssuerBuilder issuer = (IssuerBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilder(Issuer.DEFAULT_ELEMENT_NAME);
        Issuer issuerObject = issuer.buildObject();
        issuerObject.setValue("https://identity.carbon.wso2.org");
        issuerObject.setSPProvidedID("SPPProvierId");
        return issuerObject;
    }

    private static Response setSignature(Response response, String signatureAlgorithm, X509Credential cred) throws EntitlementException {
        WSXACMLMessageReceiver.doBootstrap();
        try {
            Signature signature = (Signature)WSXACMLMessageReceiver.buildXMLObject(Signature.DEFAULT_ELEMENT_NAME);
            signature.setSigningCredential((Credential)cred);
            signature.setSignatureAlgorithm(signatureAlgorithm);
            signature.setCanonicalizationAlgorithm("http://www.w3.org/2001/10/xml-exc-c14n#");
            try {
                KeyInfo keyInfo = (KeyInfo)WSXACMLMessageReceiver.buildXMLObject(KeyInfo.DEFAULT_ELEMENT_NAME);
                X509Data data = (X509Data)WSXACMLMessageReceiver.buildXMLObject(X509Data.DEFAULT_ELEMENT_NAME);
                X509Certificate cert = (X509Certificate)WSXACMLMessageReceiver.buildXMLObject(X509Certificate.DEFAULT_ELEMENT_NAME);
                String value = Base64.getEncoder().encodeToString(cred.getEntityCertificate().getEncoded());
                cert.setValue(value);
                data.getX509Certificates().add(cert);
                keyInfo.getX509Datas().add(data);
                signature.setKeyInfo(keyInfo);
            }
            catch (CertificateEncodingException e) {
                throw new EntitlementException("errorGettingCert");
            }
            response.setSignature(signature);
            ArrayList<Signature> signatureList = new ArrayList<Signature>();
            signatureList.add(signature);
            MarshallerFactory marshallerFactory = XMLObjectProviderRegistrySupport.getMarshallerFactory();
            Marshaller marshaller = marshallerFactory.getMarshaller((XMLObject)response);
            marshaller.marshall((XMLObject)response);
            Init.init();
            Signer.signObjects(signatureList);
            return response;
        }
        catch (Exception e) {
            throw new EntitlementException("Error When signing the assertion.", e);
        }
    }

    private static XMLObject buildXMLObject(QName objectQName) throws EntitlementException {
        XMLObjectBuilder builder = XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilder(objectQName);
        if (builder == null) {
            throw new EntitlementException("Unable to retrieve builder for object QName " + objectQName);
        }
        return builder.buildObject(objectQName.getNamespaceURI(), objectQName.getLocalPart(), objectQName.getPrefix());
    }

    private static BasicX509Credential createBasicCredentials() {
        java.security.cert.X509Certificate certificate = null;
        PrivateKey issuerPK = null;
        KeyStoreManager keyMan = KeyStoreManager.getInstance((int)-1234);
        try {
            certificate = keyMan.getDefaultPrimaryCertificate();
            issuerPK = keyMan.getDefaultPrivateKey();
        }
        catch (Exception e) {
            log.error((Object)"Error occurred while getting the KeyStore from KeyManger.", (Throwable)e);
        }
        BasicX509Credential basicCredential = new BasicX509Credential(certificate, issuerPK);
        return basicCredential;
    }

    private static void setXACMLNamespace(Iterator iterator) {
        while (iterator.hasNext()) {
            OMElement omElement2 = (OMElement)iterator.next();
            omElement2.setNamespace(xacmlContextNS);
            if (!omElement2.getChildElements().hasNext()) continue;
            WSXACMLMessageReceiver.setXACMLNamespace(omElement2.getChildElements());
        }
    }

    public void invokeBusinessLogic(MessageContext inMessageContext, MessageContext outMessageContext) throws AxisFault {
        try {
            String serviceClass;
            OMElement xacmlAuthzDecisionQueryElement = inMessageContext.getEnvelope().getBody().getFirstElement();
            String xacmlAuthzDecisionQuery = xacmlAuthzDecisionQueryElement.toString();
            String xacmlRequest = this.extractXACMLRequest(xacmlAuthzDecisionQuery);
            try {
                serviceClass = inMessageContext.getAxisService().getParameterValue("XACMLHandlerImplClass").toString().trim();
            }
            catch (NullPointerException e) {
                log.error((Object)"WS-XACML ServiceClass not specified in service context");
                throw new AxisFault("WS-XACML ServiceClass not specified in service context");
            }
            if (serviceClass == null || serviceClass.length() == 0) {
                log.error((Object)"WS-XACML ServiceClass not specified in service context");
                throw new AxisFault("WS-XACML ServiceClass not specified in service context");
            }
            XACMLHandler xacmlHandler = (XACMLHandler)Class.forName(serviceClass).newInstance();
            xacmlRequest = xacmlRequest.replaceAll("xacml-context:", "");
            String xacmlResponse = xacmlHandler.XACMLAuthzDecisionQuery(xacmlRequest);
            String samlResponse = this.secureXACMLResponse(xacmlResponse);
            OMElement samlResponseElement = AXIOMUtil.stringToOM((String)samlResponse);
            SOAPEnvelope outSOAPEnvelope = this.createDefaultSOAPEnvelope(inMessageContext);
            if (outSOAPEnvelope == null) {
                throw new Exception("SOAP envelope can not be null");
            }
            outSOAPEnvelope.getBody().addChild((OMNode)samlResponseElement);
            outMessageContext.setEnvelope(outSOAPEnvelope);
        }
        catch (Exception e) {
            log.error((Object)"Error occurred while evaluating XACML request.", (Throwable)e);
            throw new AxisFault("Error occurred while evaluating XACML request.", (Throwable)e);
        }
    }

    private SOAPEnvelope createDefaultSOAPEnvelope(MessageContext inMsgCtx) {
        String soapNamespace = inMsgCtx.getEnvelope().getNamespace().getNamespaceURI();
        SOAPFactory soapFactory = null;
        if (soapNamespace.equals("http://schemas.xmlsoap.org/soap/envelope/")) {
            soapFactory = OMAbstractFactory.getSOAP11Factory();
        } else if (soapNamespace.equals("http://www.w3.org/2003/05/soap-envelope")) {
            soapFactory = OMAbstractFactory.getSOAP12Factory();
        } else {
            log.error((Object)"Unknown SOAP Envelope");
        }
        if (soapFactory != null) {
            return soapFactory.getDefaultEnvelope();
        }
        return null;
    }

    private String extractXACMLRequest(String decisionQuery) throws Exception {
        RequestType xacmlRequest = null;
        WSXACMLMessageReceiver.doBootstrap();
        String queryString = null;
        try {
            XACMLAuthzDecisionQueryType xacmlAuthzDecisionQuery = (XACMLAuthzDecisionQueryType)this.unmarshall(decisionQuery);
            if (this.validateIssuer(xacmlAuthzDecisionQuery.getIssuer())) {
                if (this.validateSignature(xacmlAuthzDecisionQuery.getSignature())) {
                    xacmlRequest = xacmlAuthzDecisionQuery.getRequest();
                } else {
                    log.debug((Object)"The submitted signature is not valid!");
                }
            } else {
                log.debug((Object)"The submitted issuer is not valid!");
            }
            if (xacmlRequest != null) {
                queryString = this.marshall((XMLObject)xacmlRequest);
                queryString = queryString.replace("<?xml version=\"1.0\" encoding=\"UTF-8\"?>", "").replace("\n", "");
            }
            return queryString;
        }
        catch (Exception e) {
            log.error((Object)"Error unmarshalling the XACMLAuthzDecisionQuery.", (Throwable)e);
            throw new Exception("Error unmarshalling the XACMLAuthzDecisionQuery.", e);
        }
    }

    public XMLObject unmarshall(String xmlString) throws EntitlementException {
        try {
            WSXACMLMessageReceiver.doBootstrap();
            DocumentBuilderFactory documentBuilderFactory = IdentityUtil.getSecuredDocumentBuilderFactory();
            DocumentBuilder docBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = docBuilder.parse(new ByteArrayInputStream(xmlString.trim().getBytes()));
            Element element = document.getDocumentElement();
            UnmarshallerFactory unmarshallerFactory = XMLObjectProviderRegistrySupport.getUnmarshallerFactory();
            Unmarshaller unmarshaller = unmarshallerFactory.getUnmarshaller(element);
            return unmarshaller.unmarshall(element);
        }
        catch (Exception e) {
            log.error((Object)"Error in constructing XML(SAML or XACML) Object from the encoded String", (Throwable)e);
            throw new EntitlementException("Error in constructing XML(SAML or XACML) from the encoded String ", e);
        }
    }

    private boolean validateIssuer(Issuer issuer) {
        boolean isValidated = false;
        if (issuer.getValue().equals("https://identity.carbon.wso2.org") && issuer.getSPProvidedID().equals("SPPProvierId")) {
            isValidated = true;
        }
        return isValidated;
    }

    private String marshall(XMLObject xmlObject) throws EntitlementException {
        try {
            WSXACMLMessageReceiver.doBootstrap();
            System.setProperty("javax.xml.parsers.DocumentBuilderFactory", "org.apache.xerces.jaxp.DocumentBuilderFactoryImpl");
            MarshallerFactory marshallerFactory = XMLObjectProviderRegistrySupport.getMarshallerFactory();
            Marshaller marshaller = marshallerFactory.getMarshaller(xmlObject);
            Element element = marshaller.marshall(xmlObject);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
            DOMImplementationLS impl = (DOMImplementationLS)((Object)registry.getDOMImplementation("LS"));
            LSSerializer writer = impl.createLSSerializer();
            LSOutput output = impl.createLSOutput();
            output.setByteStream(byteArrayOutputStream);
            writer.write(element, output);
            return byteArrayOutputStream.toString();
        }
        catch (Exception e) {
            log.error((Object)"Error Serializing the SAML Response");
            throw new EntitlementException("Error Serializing the SAML Response", e);
        }
    }

    private boolean validateSignature(Signature signature) throws Exception {
        boolean isSignatureValid = false;
        try {
            SignatureValidator.validate((Signature)signature, (Credential)this.getPublicX509CredentialImpl());
            isSignatureValid = true;
        }
        catch (SignatureException e) {
            log.warn((Object)("Signature validation failed for the public X509 credential: " + this.getPublicX509CredentialImpl()), (Throwable)e);
        }
        catch (Exception e) {
            throw new Exception("Error in getting public X509Credentials to validate signature.", e);
        }
        return isSignatureValid;
    }

    private X509CredentialImpl getPublicX509CredentialImpl() throws Exception {
        try {
            KeyStoreManager keyStoreManager = KeyStoreManager.getInstance((int)-1234);
            java.security.cert.X509Certificate cert = keyStoreManager.getDefaultPrimaryCertificate();
            X509CredentialImpl credentialImpl = new X509CredentialImpl(cert);
            return credentialImpl;
        }
        catch (Exception e) {
            log.error((Object)"Error instantiating an org.wso2.carbon.identity.entitlement.wsxacml.X509CredentialImpl object for the public cert.", (Throwable)e);
            throw new Exception("Error instantiating an org.wso2.carbon.identity.entitlement.wsxacml.X509CredentialImpl object for the public cert.", e);
        }
    }

    public String secureXACMLResponse(String xacmlResponse) throws Exception {
        ResponseType responseType;
        WSXACMLMessageReceiver.doBootstrap();
        try {
            responseType = (ResponseType)this.unmarshall(this.formatResponse(xacmlResponse));
        }
        catch (Exception e) {
            log.error((Object)"Error while unmarshalling the formatted XACML response.", (Throwable)e);
            throw new EntitlementException("Error while unmarshalling the formatted XACML response.", e);
        }
        XACMLAuthzDecisionStatementTypeImplBuilder xacmlauthz = (XACMLAuthzDecisionStatementTypeImplBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilder(XACMLAuthzDecisionStatementType.TYPE_NAME_XACML20);
        XACMLAuthzDecisionStatementType xacmlAuthzDecisionStatement = (XACMLAuthzDecisionStatementType)xacmlauthz.buildObject(Statement.DEFAULT_ELEMENT_NAME, XACMLAuthzDecisionStatementType.TYPE_NAME_XACML20);
        xacmlAuthzDecisionStatement.setResponse(responseType);
        AssertionBuilder assertionBuilder = (AssertionBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilder(Assertion.DEFAULT_ELEMENT_NAME);
        DateTime currentTime = new DateTime();
        Assertion assertion = assertionBuilder.buildObject();
        assertion.setVersion(SAMLVersion.VERSION_20);
        assertion.setIssuer(WSXACMLMessageReceiver.createIssuer());
        assertion.setIssueInstant(currentTime);
        assertion.getStatements().add(xacmlAuthzDecisionStatement);
        ResponseBuilder builder = (ResponseBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilder(Response.DEFAULT_ELEMENT_NAME);
        Response response = builder.buildObject();
        response.getAssertions().add(assertion);
        response.setIssuer(WSXACMLMessageReceiver.createIssuer());
        DateTime issueInstant = new DateTime();
        response.setIssueInstant(issueInstant);
        response = WSXACMLMessageReceiver.setSignature(response, "http://www.w3.org/2000/09/xmldsig#rsa-sha1", (X509Credential)WSXACMLMessageReceiver.createBasicCredentials());
        try {
            String responseString = this.marshall((XMLObject)response);
            responseString = responseString.replace("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n", "");
            return responseString;
        }
        catch (EntitlementException e) {
            log.error((Object)"Error occurred while marshalling the SAML Response.", (Throwable)e);
            throw new Exception("Error occurred while marshalling the SAML Response.", e);
        }
    }

    private String formatResponse(String xacmlResponse) throws Exception {
        OMElement omElemnt;
        xacmlResponse = xacmlResponse.replace("\n", "");
        try {
            omElemnt = AXIOMUtil.stringToOM((String)xacmlResponse);
            omElemnt.setNamespace(xacmlContextNS);
            if (omElemnt.getChildren() != null) {
                Iterator childIterator = omElemnt.getChildElements();
                WSXACMLMessageReceiver.setXACMLNamespace(childIterator);
            }
        }
        catch (Exception e) {
            log.error((Object)"Error while generating the OMElement from the XACML request.", (Throwable)e);
            throw new Exception("Error while generating the OMElement from the XACML request.", e);
        }
        return omElemnt.toString();
    }
}

