/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.entitlement.thrift;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.thrift.TException;
import org.wso2.carbon.identity.entitlement.EntitlementService;
import org.wso2.carbon.identity.entitlement.dto.AttributeDTO;
import org.wso2.carbon.identity.entitlement.dto.EntitledResultSetDTO;
import org.wso2.carbon.identity.entitlement.thrift.EntitlementException;
import org.wso2.carbon.identity.entitlement.thrift.EntitlementService;
import org.wso2.carbon.identity.thrift.authentication.ThriftAuthenticatorService;

public class ThriftEntitlementServiceImpl
implements EntitlementService.Iface {
    private static Log log = LogFactory.getLog(ThriftEntitlementServiceImpl.class);
    private static ThriftAuthenticatorService thriftAuthenticatorService;
    private static EntitlementService entitlementService;

    public static void init(ThriftAuthenticatorService authenticatorService) {
        thriftAuthenticatorService = authenticatorService;
        entitlementService = new EntitlementService();
    }

    @Override
    public String getDecision(String request, String sessionId) throws EntitlementException, TException {
        try {
            if (thriftAuthenticatorService != null && entitlementService != null) {
                if (thriftAuthenticatorService.isAuthenticated(sessionId)) {
                    try {
                        return entitlementService.getDecision(request);
                    }
                    catch (Exception e) {
                        String error = "Error while evaluating XACML decision from thrift service";
                        log.error((Object)error, (Throwable)e);
                        throw new EntitlementException(error);
                    }
                }
                String authErrorMsg = "User is not authenticated. Please login first.";
                log.error((Object)authErrorMsg);
                throw new EntitlementException(authErrorMsg);
            }
            String initErrorMsg = "Thrift Authenticator service or Entitlement service is not initialized.";
            log.error((Object)initErrorMsg);
            throw new EntitlementException(initErrorMsg);
        }
        catch (Exception e) {
            String errorMsg = "Error occurred when invoking the Thrift based Entitlement Service.";
            log.error((Object)errorMsg, (Throwable)e);
            throw new EntitlementException(errorMsg);
        }
    }

    @Override
    public String getDecisionByAttributes(String subject, String resource, String action, List<String> environment, String sessionID) throws EntitlementException, TException {
        try {
            if (thriftAuthenticatorService != null && entitlementService != null) {
                if (thriftAuthenticatorService.isAuthenticated(sessionID)) {
                    try {
                        return entitlementService.getDecisionByAttributes(subject, resource, action, environment.toArray(new String[environment.size()]));
                    }
                    catch (Exception e) {
                        String error = "Error while evaluating XACML decision from thrift service";
                        log.error((Object)error, (Throwable)e);
                        throw new EntitlementException(error);
                    }
                }
                String authErrorMsg = "User is not authenticated. Please login first.";
                log.error((Object)authErrorMsg);
                throw new EntitlementException(authErrorMsg);
            }
            String initErrorMsg = "Thrift Authenticator service or Entitlement service is not initialized.";
            log.error((Object)initErrorMsg);
            throw new EntitlementException(initErrorMsg);
        }
        catch (Exception e) {
            String errorMsg = "Error occurred when invoking the Thrift based Entitlement Service.";
            log.error((Object)errorMsg, (Throwable)e);
            throw new EntitlementException(errorMsg);
        }
    }

    public EntitledResultSetDTO getEntitledAttributes(String subjectName, String resourceName, String subjectId, String action, boolean enableChildSearch, String sessionID) throws EntitlementException, TException {
        try {
            if (thriftAuthenticatorService != null && entitlementService != null) {
                if (thriftAuthenticatorService.isAuthenticated(sessionID)) {
                    try {
                        return entitlementService.getEntitledAttributes(subjectName, resourceName, subjectId, action, enableChildSearch);
                    }
                    catch (Exception e) {
                        String error = "Error while evaluating XACML decision from thrift service";
                        log.error((Object)error, (Throwable)e);
                        throw new EntitlementException(error);
                    }
                }
                String authErrorMsg = "User is not authenticated. Please login first.";
                log.error((Object)authErrorMsg);
                throw new EntitlementException(authErrorMsg);
            }
            String initErrorMsg = "Thrift Authenticator service or Entitlement service is not initialized.";
            log.error((Object)initErrorMsg);
            throw new EntitlementException(initErrorMsg);
        }
        catch (Exception e) {
            String errorMsg = "Error occurred when invoking the Thrift based Entitlement Service.";
            log.error((Object)errorMsg, (Throwable)e);
            throw new EntitlementException(errorMsg);
        }
    }

    public EntitledResultSetDTO getAllEntitlements(String identifier, AttributeDTO[] givenAttributes, String sessionID) throws EntitlementException, TException {
        try {
            if (thriftAuthenticatorService != null && entitlementService != null) {
                if (thriftAuthenticatorService.isAuthenticated(sessionID)) {
                    try {
                        return entitlementService.getAllEntitlements(identifier, givenAttributes);
                    }
                    catch (Exception e) {
                        String error = "Error while evaluating XACML decision from thrift service";
                        log.error((Object)error, (Throwable)e);
                        throw new EntitlementException(error);
                    }
                }
                String authErrorMsg = "User is not authenticated. Please login first.";
                log.error((Object)authErrorMsg);
                throw new EntitlementException(authErrorMsg);
            }
            String initErrorMsg = "Thrift Authenticator service or Entitlement service is not initialized.";
            log.error((Object)initErrorMsg);
            throw new EntitlementException(initErrorMsg);
        }
        catch (Exception e) {
            String errorMsg = "Error occurred when invoking the Thrift based Entitlement Service.";
            log.error((Object)errorMsg, (Throwable)e);
            throw new EntitlementException(errorMsg);
        }
    }
}

