/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.entitlement.policy.version;

import java.util.ArrayList;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.identity.entitlement.EntitlementException;
import org.wso2.carbon.identity.entitlement.dto.PolicyDTO;
import org.wso2.carbon.identity.entitlement.internal.EntitlementServiceComponent;
import org.wso2.carbon.identity.entitlement.pap.store.PAPPolicyStore;
import org.wso2.carbon.identity.entitlement.pap.store.PAPPolicyStoreReader;
import org.wso2.carbon.identity.entitlement.policy.version.PolicyVersionManager;
import org.wso2.carbon.registry.api.Collection;
import org.wso2.carbon.registry.api.RegistryException;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.ResourceNotFoundException;
import org.wso2.carbon.registry.core.utils.RegistryUtils;

public class DefaultPolicyVersionManager
implements PolicyVersionManager {
    private static Log log = LogFactory.getLog(DefaultPolicyVersionManager.class);
    private static int DEFAULT_MAX_VERSION = 5;
    private int maxVersions;

    @Override
    public void init(Properties properties) {
        try {
            this.maxVersions = Integer.parseInt(properties.getProperty("maxVersions"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.maxVersions == 0) {
            this.maxVersions = DEFAULT_MAX_VERSION;
        }
    }

    @Override
    public PolicyDTO getPolicy(String policyId, String version) throws EntitlementException {
        if (version == null || version.trim().length() == 0) {
            Registry registry = EntitlementServiceComponent.getGovernanceRegistry(CarbonContext.getThreadLocalCarbonContext().getTenantId());
            try {
                Collection collection = (Collection)registry.get("/repository/identity/entitlement/policy/version/" + policyId);
                if (collection != null) {
                    version = collection.getProperty("version");
                }
            }
            catch (RegistryException e) {
                log.error((Object)e);
                throw new EntitlementException("Invalid policy version");
            }
        }
        PAPPolicyStore policyStore = new PAPPolicyStore();
        PAPPolicyStoreReader reader = new PAPPolicyStoreReader(policyStore);
        Resource resource = policyStore.getPolicy(version, "/repository/identity/entitlement/policy/version/" + policyId + "/");
        if (resource == null) {
            throw new EntitlementException("Invalid policy version");
        }
        return reader.readPolicyDTO(resource);
    }

    @Override
    public String createVersion(PolicyDTO policyDTO) throws EntitlementException {
        PAPPolicyStore policyStore = new PAPPolicyStore();
        Registry registry = EntitlementServiceComponent.getGovernanceRegistry(CarbonContext.getThreadLocalCarbonContext().getTenantId());
        String version = "0";
        try {
            Collection collection = null;
            try {
                collection = (Collection)registry.get("/repository/identity/entitlement/policy/version/" + policyDTO.getPolicyId());
            }
            catch (ResourceNotFoundException resourceNotFoundException) {
                // empty catch block
            }
            if (collection != null) {
                version = collection.getProperty("version");
            } else {
                collection = registry.newCollection();
                collection.setProperty("version", "1");
                registry.put("/repository/identity/entitlement/policy/version/" + policyDTO.getPolicyId(), (org.wso2.carbon.registry.api.Resource)collection);
            }
            int versionInt = Integer.parseInt(version);
            String policyPath = "/repository/identity/entitlement/policy/version/" + policyDTO.getPolicyId() + "/";
            if (versionInt > this.maxVersions) {
                int olderVersion = versionInt - this.maxVersions;
                if (registry.resourceExists(policyPath + olderVersion)) {
                    registry.delete(policyPath + olderVersion);
                }
            }
            version = Integer.toString(versionInt + 1);
            policyDTO.setVersion(version);
            policyStore.addOrUpdatePolicy(policyDTO, version, policyPath);
            collection.setProperty("version", version);
            registry.put("/repository/identity/entitlement/policy/version/" + policyDTO.getPolicyId(), (org.wso2.carbon.registry.api.Resource)collection);
        }
        catch (RegistryException e) {
            log.error((Object)"Error while creating new version of policy", (Throwable)e);
        }
        return version;
    }

    @Override
    public void deletePolicy(String policyId) throws EntitlementException {
        Registry registry = EntitlementServiceComponent.getGovernanceRegistry(CarbonContext.getThreadLocalCarbonContext().getTenantId());
        try {
            if (registry.resourceExists("/repository/identity/entitlement/policy/version/" + policyId)) {
                registry.delete("/repository/identity/entitlement/policy/version/" + policyId);
            }
        }
        catch (RegistryException e) {
            log.error((Object)"Error while deleting all versions of policy", (Throwable)e);
        }
    }

    @Override
    public String[] getVersions(String policyId) throws EntitlementException {
        ArrayList<String> versions = new ArrayList<String>();
        Registry registry = EntitlementServiceComponent.getGovernanceRegistry(CarbonContext.getThreadLocalCarbonContext().getTenantId());
        Collection collection = null;
        try {
            try {
                collection = (Collection)registry.get("/repository/identity/entitlement/policy/version/" + policyId);
            }
            catch (ResourceNotFoundException resourceNotFoundException) {
                // empty catch block
            }
            if (collection != null && collection.getChildren() != null) {
                String[] children;
                for (String child : children = collection.getChildren()) {
                    versions.add(RegistryUtils.getResourceName((String)child));
                }
            }
        }
        catch (RegistryException e) {
            log.error((Object)"Error while creating new version of policy", (Throwable)e);
        }
        return versions.toArray(new String[versions.size()]);
    }
}

