/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.entitlement.policy.store;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.identity.entitlement.EntitlementException;
import org.wso2.carbon.identity.entitlement.dto.AttributeDTO;
import org.wso2.carbon.identity.entitlement.dto.PolicyDTO;
import org.wso2.carbon.identity.entitlement.dto.PolicyStoreDTO;
import org.wso2.carbon.identity.entitlement.internal.EntitlementServiceComponent;
import org.wso2.carbon.identity.entitlement.policy.finder.AbstractPolicyFinderModule;
import org.wso2.carbon.identity.entitlement.policy.finder.registry.RegistryPolicyReader;
import org.wso2.carbon.identity.entitlement.policy.store.PolicyStoreManageModule;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.session.UserRegistry;

public class RegistryPolicyStoreManageModule
extends AbstractPolicyFinderModule
implements PolicyStoreManageModule {
    private static final String MODULE_NAME = "Registry Policy Finder Module";
    private static final String PROPERTY_POLICY_STORE_PATH = "policyStorePath";
    private static final String PROPERTY_ATTRIBUTE_SEPARATOR = "attributeValueSeparator";
    private static final String DEFAULT_POLICY_STORE_PATH = "/repository/identity/entitlement/policy/pdp/";
    private static final String KEY_VALUE_POLICY_META_DATA = "policyMetaData";
    private static Log log = LogFactory.getLog(RegistryPolicyStoreManageModule.class);
    private String policyStorePath;

    @Override
    public void init(Properties properties) {
        this.policyStorePath = properties.getProperty(PROPERTY_POLICY_STORE_PATH);
        if (this.policyStorePath == null) {
            this.policyStorePath = DEFAULT_POLICY_STORE_PATH;
        }
    }

    @Override
    public void addPolicy(PolicyStoreDTO policy) throws EntitlementException {
        int tenantId = CarbonContext.getThreadLocalCarbonContext().getTenantId();
        if (policy == null || StringUtils.isBlank((String)policy.getPolicyId())) {
            throw new EntitlementException("Policy can not be null");
        }
        try {
            int order;
            UserRegistry registry = EntitlementServiceComponent.getRegistryService().getGovernanceSystemRegistry(tenantId);
            Collection policyCollection = registry.resourceExists(this.policyStorePath) ? (Collection)registry.get(this.policyStorePath) : registry.newCollection();
            registry.put(this.policyStorePath, (Resource)policyCollection);
            String policyPath = this.policyStorePath + policy.getPolicyId();
            Resource resource = registry.resourceExists(policyPath) ? registry.get(policyPath) : registry.newResource();
            if (policy.getPolicy() != null && policy.getPolicy().trim().length() != 0) {
                resource.setContent((Object)policy.getPolicy());
                resource.setMediaType("application/xacml-policy+xml");
                AttributeDTO[] attributeDTOs = policy.getAttributeDTOs();
                if (attributeDTOs != null) {
                    this.setAttributesAsProperties(attributeDTOs, resource);
                }
            }
            if (policy.isSetActive()) {
                resource.setProperty("active", Boolean.toString(policy.isActive()));
            }
            if (policy.isSetOrder() && (order = policy.getPolicyOrder()) > 0) {
                resource.setProperty("order", Integer.toString(order));
            }
            if (resource.getContent() == null) {
                log.info((Object)("Prevented adding null content to resource " + policyPath));
                return;
            }
            registry.put(policyPath, resource);
        }
        catch (RegistryException e) {
            log.error((Object)"Error while persisting policy", (Throwable)e);
            throw new EntitlementException("Error while persisting policy", e);
        }
    }

    @Override
    public boolean isPolicyExist(String policyId) {
        int tenantId = CarbonContext.getThreadLocalCarbonContext().getTenantId();
        if (policyId == null || policyId.trim().length() == 0) {
            return false;
        }
        try {
            UserRegistry registry = EntitlementServiceComponent.getRegistryService().getGovernanceSystemRegistry(tenantId);
            String policyPath = this.policyStorePath + policyId;
            return registry.resourceExists(policyPath);
        }
        catch (RegistryException e) {
            return false;
        }
    }

    @Override
    public void updatePolicy(PolicyStoreDTO policy) throws EntitlementException {
        this.addPolicy(policy);
    }

    @Override
    public boolean deletePolicy(String policyIdentifier) {
        int tenantId = CarbonContext.getThreadLocalCarbonContext().getTenantId();
        if (policyIdentifier == null || policyIdentifier.trim().length() == 0) {
            return false;
        }
        try {
            UserRegistry registry = EntitlementServiceComponent.getRegistryService().getGovernanceSystemRegistry(tenantId);
            String policyPath = this.policyStorePath + policyIdentifier;
            registry.delete(policyPath);
            return true;
        }
        catch (RegistryException e) {
            log.error((Object)e);
            return false;
        }
    }

    @Override
    public String getModuleName() {
        return MODULE_NAME;
    }

    @Override
    public String getPolicy(String policyId) {
        try {
            PolicyDTO dto = this.getPolicyReader().readPolicy(policyId);
            return dto.getPolicy();
        }
        catch (Exception e) {
            log.error((Object)("Policy with identifier " + policyId + " can not be retrieved from registry policy finder module"), (Throwable)e);
            return null;
        }
    }

    @Override
    public int getPolicyOrder(String policyId) {
        try {
            PolicyDTO dto = this.getPolicyReader().readPolicy(policyId);
            return dto.getPolicyOrder();
        }
        catch (Exception e) {
            log.error((Object)("Policy with identifier " + policyId + " can not be retrieved from registry policy finder module"), (Throwable)e);
            return -1;
        }
    }

    @Override
    public String[] getActivePolicies() {
        log.debug((Object)("Retrieving of Active policies are started. " + new Date()));
        ArrayList<String> policies = new ArrayList<String>();
        try {
            PolicyDTO[] policyDTOs;
            for (PolicyDTO dto : policyDTOs = this.getPolicyReader().readAllPolicies(true, true)) {
                if (dto.getPolicy() == null) continue;
                policies.add(dto.getPolicy());
            }
        }
        catch (Exception e) {
            log.error((Object)"Policies can not be retrieved from registry policy finder module", (Throwable)e);
        }
        log.debug((Object)("Retrieving of Active policies are finished.   " + new Date()));
        return policies.toArray(new String[policies.size()]);
    }

    @Override
    public String[] getOrderedPolicyIdentifiers() {
        log.debug((Object)("Retrieving of Order Policy Ids are started. " + new Date()));
        ArrayList<String> policies = new ArrayList<String>();
        try {
            PolicyDTO[] policyDTOs;
            for (PolicyDTO dto : policyDTOs = this.getPolicyReader().readAllPolicies(false, true)) {
                if (dto.getPolicy() == null) continue;
                policies.add(dto.getPolicyId());
            }
        }
        catch (Exception e) {
            log.error((Object)"Policies can not be retrieved from registry policy finder module", (Throwable)e);
        }
        log.debug((Object)("Retrieving of Order Policy Ids are finish. " + new Date()));
        return policies.toArray(new String[policies.size()]);
    }

    @Override
    public String[] getPolicyIdentifiers() {
        String[] policyIds = null;
        try {
            policyIds = this.getPolicyReader().getAllPolicyIds();
        }
        catch (Exception e) {
            log.error((Object)"Policy identifiers can not be retrieved from registry policy finder module", (Throwable)e);
        }
        return policyIds;
    }

    @Override
    public String getReferencedPolicy(String policyId) {
        try {
            PolicyDTO dto = this.getPolicyReader().readPolicy(policyId);
            if (dto != null && dto.getPolicy() != null && !dto.isActive()) {
                return dto.getPolicy();
            }
        }
        catch (EntitlementException e) {
            log.error((Object)("Error while retrieving reference policy " + policyId));
        }
        return null;
    }

    @Override
    public Map<String, Set<AttributeDTO>> getSearchAttributes(String identifier, Set<AttributeDTO> givenAttribute) {
        PolicyDTO[] policyDTOs = null;
        HashMap<String, HashSet<AttributeDTO>> attributeMap = null;
        try {
            policyDTOs = this.getPolicyReader().readAllPolicies(true, true);
        }
        catch (Exception e) {
            log.error((Object)"Policies can not be retrieved from registry policy finder module", (Throwable)e);
        }
        if (policyDTOs != null) {
            attributeMap = new HashMap<String, HashSet<AttributeDTO>>();
            for (PolicyDTO policyDTO : policyDTOs) {
                HashSet<AttributeDTO> attributeDTOs = new HashSet<AttributeDTO>(Arrays.asList(policyDTO.getAttributeDTOs()));
                String[] policyIdRef = policyDTO.getPolicyIdReferences();
                String[] policySetIdRef = policyDTO.getPolicySetIdReferences();
                if (policyIdRef != null && policyIdRef.length > 0 || policySetIdRef != null && policySetIdRef.length > 0) {
                    for (PolicyDTO dto : policyDTOs) {
                        if (policyIdRef != null) {
                            for (String policyId : policyIdRef) {
                                if (!dto.getPolicyId().equals(policyId)) continue;
                                attributeDTOs.addAll(Arrays.asList(dto.getAttributeDTOs()));
                            }
                        }
                        for (String policySetId : policySetIdRef) {
                            if (!dto.getPolicyId().equals(policySetId)) continue;
                            attributeDTOs.addAll(Arrays.asList(dto.getAttributeDTOs()));
                        }
                    }
                }
                attributeMap.put(policyDTO.getPolicyId(), attributeDTOs);
            }
        }
        return attributeMap;
    }

    @Override
    public int getSupportedSearchAttributesScheme() {
        return 3;
    }

    @Override
    public boolean isDefaultCategoriesSupported() {
        return true;
    }

    private RegistryPolicyReader getPolicyReader() {
        UserRegistry registry = null;
        int tenantId = CarbonContext.getThreadLocalCarbonContext().getTenantId();
        try {
            registry = EntitlementServiceComponent.getRegistryService().getGovernanceSystemRegistry(tenantId);
        }
        catch (RegistryException e) {
            log.error((Object)("Error while obtaining registry for tenant :  " + tenantId), (Throwable)e);
        }
        return new RegistryPolicyReader((Registry)registry, this.policyStorePath);
    }

    private void setAttributesAsProperties(AttributeDTO[] attributeDTOs, Resource resource) {
        int attributeElementNo = 0;
        if (attributeDTOs != null) {
            for (AttributeDTO attributeDTO : attributeDTOs) {
                resource.setProperty(KEY_VALUE_POLICY_META_DATA + attributeElementNo, attributeDTO.getCategory() + "," + attributeDTO.getAttributeValue() + "," + attributeDTO.getAttributeId() + "," + attributeDTO.getAttributeDataType());
                ++attributeElementNo;
            }
        }
    }

    @Override
    public boolean isPolicyOrderingSupport() {
        return true;
    }

    @Override
    public boolean isPolicyDeActivationSupport() {
        return true;
    }
}

