/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.entitlement.policy.store;

import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.entitlement.EntitlementException;
import org.wso2.carbon.identity.entitlement.dto.PolicyDTO;
import org.wso2.carbon.identity.entitlement.dto.PolicyStoreDTO;
import org.wso2.carbon.identity.entitlement.internal.EntitlementServiceComponent;
import org.wso2.carbon.identity.entitlement.policy.store.PolicyDataStore;
import org.wso2.carbon.identity.entitlement.policy.store.PolicyStoreManageModule;
import org.wso2.carbon.identity.entitlement.policy.store.RegistryPolicyStoreManageModule;

public class PolicyStoreManager {
    private PolicyStoreManageModule policyStoreStore = null;
    private PolicyDataStore policyDataStore = null;
    private static Log log = LogFactory.getLog(PolicyStoreManager.class);

    public PolicyStoreManager(PolicyDataStore policyDataStore) {
        Map<PolicyStoreManageModule, Properties> policyCollections = EntitlementServiceComponent.getEntitlementConfig().getPolicyStore();
        this.policyStoreStore = policyCollections != null && policyCollections.size() > 0 ? policyCollections.entrySet().iterator().next().getKey() : new RegistryPolicyStoreManageModule();
        this.policyDataStore = policyDataStore;
    }

    public void addPolicy(PolicyDTO policyDTO) throws EntitlementException {
        PolicyStoreDTO dto = new PolicyStoreDTO();
        dto.setPolicyId(policyDTO.getPolicyId());
        dto.setPolicy(policyDTO.getPolicy());
        dto.setActive(policyDTO.isActive());
        dto.setPolicyOrder(policyDTO.getPolicyOrder());
        dto.setAttributeDTOs(policyDTO.getAttributeDTOs());
        if (this.policyStoreStore.isPolicyExist(policyDTO.getPolicyId())) {
            dto.setSetActive(false);
            dto.setSetOrder(false);
        } else {
            dto.setSetOrder(true);
            dto.setSetActive(true);
        }
        this.policyStoreStore.addPolicy(dto);
        this.policyDataStore.setPolicyData(policyDTO.getPolicyId(), dto);
        RegistryPolicyStoreManageModule.invalidateCache(dto.getPolicyId(), "UPDATE");
    }

    public void updatePolicy(PolicyDTO policyDTO) throws EntitlementException {
        if (!this.policyStoreStore.isPolicyExist(policyDTO.getPolicyId())) {
            throw new EntitlementException("Policy is not exist in the Policy Store : PolicyId " + policyDTO.getPolicyId());
        }
        PolicyStoreDTO dto = new PolicyStoreDTO();
        dto.setPolicyId(policyDTO.getPolicyId());
        dto.setPolicy(policyDTO.getPolicy());
        dto.setActive(policyDTO.isActive());
        dto.setPolicyOrder(policyDTO.getPolicyOrder());
        dto.setAttributeDTOs(policyDTO.getAttributeDTOs());
        dto.setSetActive(false);
        dto.setSetOrder(false);
        this.policyStoreStore.updatePolicy(dto);
        RegistryPolicyStoreManageModule.invalidateCache(dto.getPolicyId(), "UPDATE");
    }

    public void enableDisablePolicy(PolicyDTO policyDTO) throws EntitlementException {
        if (!this.policyStoreStore.isPolicyExist(policyDTO.getPolicyId())) {
            throw new EntitlementException("Policy is not exist in the Policy Store : PolicyId " + policyDTO.getPolicyId());
        }
        PolicyStoreDTO dto = new PolicyStoreDTO();
        dto.setPolicyId(policyDTO.getPolicyId());
        dto.setPolicy(policyDTO.getPolicy());
        dto.setActive(policyDTO.isActive());
        dto.setSetActive(true);
        if (this.policyStoreStore.isPolicyDeActivationSupport()) {
            this.policyStoreStore.updatePolicy(dto);
        }
        this.policyDataStore.setPolicyData(policyDTO.getPolicyId(), dto);
        if (policyDTO.isActive()) {
            RegistryPolicyStoreManageModule.invalidateCache(dto.getPolicyId(), "ENABLE");
        } else {
            RegistryPolicyStoreManageModule.invalidateCache(dto.getPolicyId(), "DISABLE");
        }
    }

    public void orderPolicy(PolicyDTO policyDTO) throws EntitlementException {
        if (!this.policyStoreStore.isPolicyExist(policyDTO.getPolicyId())) {
            throw new EntitlementException("Policy is not exist in the Policy Store : PolicyId " + policyDTO.getPolicyId());
        }
        PolicyStoreDTO dto = new PolicyStoreDTO();
        dto.setPolicyId(policyDTO.getPolicyId());
        dto.setPolicy(policyDTO.getPolicy());
        dto.setPolicyOrder(policyDTO.getPolicyOrder());
        dto.setSetOrder(true);
        if (this.policyStoreStore.isPolicyOrderingSupport()) {
            this.policyStoreStore.updatePolicy(dto);
        }
        this.policyDataStore.setPolicyData(policyDTO.getPolicyId(), dto);
        RegistryPolicyStoreManageModule.invalidateCache(dto.getPolicyId(), "ORDER");
    }

    public void removePolicy(PolicyDTO policyDTO) throws EntitlementException {
        if (!this.policyStoreStore.isPolicyExist(policyDTO.getPolicyId())) {
            throw new EntitlementException("Policy is not exist in the Policy Store : PolicyId " + policyDTO.getPolicyId());
        }
        this.policyStoreStore.deletePolicy(policyDTO.getPolicyId());
        this.policyDataStore.removePolicyData(policyDTO.getPolicyId());
        RegistryPolicyStoreManageModule.invalidateCache(policyDTO.getPolicyId(), "DELETE");
    }

    public PolicyDTO getPolicy(String policyId) {
        PolicyDTO policyDTO = new PolicyDTO();
        policyDTO.setPolicyId(policyId);
        String policy = this.policyStoreStore.getPolicy(policyId);
        PolicyStoreDTO storeDTO = this.policyDataStore.getPolicyData(policyId);
        if (policy != null) {
            policyDTO.setPolicy(policy);
            policyDTO.setActive(storeDTO.isActive());
            policyDTO.setPolicyOrder(storeDTO.getPolicyOrder());
        }
        return policyDTO;
    }

    public String[] getPolicyIds() {
        return this.policyStoreStore.getOrderedPolicyIdentifiers();
    }

    public PolicyDTO[] getLightPolicies() {
        ArrayList<PolicyDTO> policyDTOs = new ArrayList<PolicyDTO>();
        String[] policies = this.policyStoreStore.getOrderedPolicyIdentifiers();
        if (policies != null) {
            for (String policy : policies) {
                PolicyDTO policyDTO = new PolicyDTO();
                policyDTO.setPolicyId(policy);
                PolicyStoreDTO storeDTO = this.policyDataStore.getPolicyData(policy);
                policyDTO.setActive(storeDTO.isActive());
                policyDTO.setPolicyOrder(storeDTO.getPolicyOrder());
                policyDTOs.add(policyDTO);
            }
        }
        return policyDTOs.toArray(new PolicyDTO[policyDTOs.size()]);
    }

    public PolicyStoreDTO[] getAllPolicyData() {
        return this.policyDataStore.getPolicyData();
    }
}

