/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.entitlement.policy.store;

import java.util.ArrayList;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.balana.combine.PolicyCombiningAlgorithm;
import org.wso2.balana.combine.xacml3.DenyOverridesPolicyAlg;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.identity.entitlement.EntitlementException;
import org.wso2.carbon.identity.entitlement.EntitlementUtil;
import org.wso2.carbon.identity.entitlement.dto.PolicyStoreDTO;
import org.wso2.carbon.identity.entitlement.internal.EntitlementServiceComponent;
import org.wso2.carbon.identity.entitlement.pdp.EntitlementEngine;
import org.wso2.carbon.identity.entitlement.policy.store.PolicyDataStore;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;

public class DefaultPolicyDataStore
implements PolicyDataStore {
    public static final String POLICY_COMBINING_PREFIX_1 = "urn:oasis:names:tc:xacml:1.0:policy-combining-algorithm:";
    public static final String POLICY_COMBINING_PREFIX_3 = "urn:oasis:names:tc:xacml:3.0:policy-combining-algorithm:";
    private static Log log = LogFactory.getLog(DefaultPolicyDataStore.class);
    private String policyDataCollection = "/repository/identity/entitlement/policy/data/";

    @Override
    public void init(Properties properties) throws EntitlementException {
    }

    @Override
    public PolicyCombiningAlgorithm getGlobalPolicyAlgorithm() {
        block7: {
            String algorithm = null;
            try {
                Registry registry = this.getGovernanceRegistry();
                if (registry.resourceExists(this.policyDataCollection)) {
                    Collection collection = (Collection)registry.get(this.policyDataCollection);
                    algorithm = collection.getProperty("globalPolicyCombiningAlgorithm");
                }
                if (algorithm == null || algorithm.trim().length() == 0) {
                    algorithm = EntitlementServiceComponent.getEntitlementConfig().getEngineProperties().getProperty("PDP.Global.Policy.Combining.Algorithm");
                    log.info((Object)"Using Global policy combining algorithm that is defined in configuration file.");
                    try {
                        return EntitlementUtil.getPolicyCombiningAlgorithm(algorithm);
                    }
                    catch (Exception e) {
                        log.debug((Object)e);
                    }
                }
                if (algorithm != null && algorithm.trim().length() > 0) {
                    algorithm = "first-applicable".equals(algorithm) || "only-one-applicable".equals(algorithm) ? POLICY_COMBINING_PREFIX_1 + algorithm : POLICY_COMBINING_PREFIX_3 + algorithm;
                    return EntitlementUtil.getPolicyCombiningAlgorithm(algorithm);
                }
            }
            catch (EntitlementException | RegistryException e) {
                if (!log.isDebugEnabled()) break block7;
                log.debug((Object)"Exception while getting Global Policy Algorithm from policy data store.", e);
            }
        }
        log.warn((Object)"Global policy combining algorithm is not defined. Therefore using default one");
        return new DenyOverridesPolicyAlg();
    }

    @Override
    public void setGlobalPolicyAlgorithm(String policyCombiningAlgorithm) throws EntitlementException {
        Registry registry = this.getGovernanceRegistry();
        try {
            Collection policyCollection = registry.resourceExists(this.policyDataCollection) ? (Collection)registry.get(this.policyDataCollection) : registry.newCollection();
            policyCollection.setProperty("globalPolicyCombiningAlgorithm", policyCombiningAlgorithm);
            registry.put(this.policyDataCollection, (Resource)policyCollection);
            EntitlementEngine.getInstance().invalidatePolicyCache();
        }
        catch (RegistryException e) {
            log.error((Object)"Error while updating Global combing algorithm in policy store ", (Throwable)e);
            throw new EntitlementException("Error while updating combing algorithm in policy store");
        }
    }

    @Override
    public String getGlobalPolicyAlgorithmName() {
        String algorithm = null;
        try {
            Registry registry = this.getGovernanceRegistry();
            if (registry.resourceExists(this.policyDataCollection)) {
                Collection collection = (Collection)registry.get(this.policyDataCollection);
                algorithm = collection.getProperty("globalPolicyCombiningAlgorithm");
            }
        }
        catch (RegistryException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)e);
            }
        }
        catch (EntitlementException e) {
            log.error((Object)"Error while getting Global Policy Combining Algorithm Name.", (Throwable)e);
        }
        if (algorithm == null) {
            algorithm = "deny-overrides";
        }
        return algorithm;
    }

    @Override
    public String[] getAllGlobalPolicyAlgorithmNames() {
        return new String[]{"deny-overrides", "permit-overrides", "first-applicable", "ordered-deny-overrides", "ordered-permit-overrides", "only-one-applicable"};
    }

    @Override
    public PolicyStoreDTO getPolicyData(String policyId) {
        PolicyStoreDTO dataDTO = new PolicyStoreDTO();
        try {
            Registry registry = this.getGovernanceRegistry();
            String path = this.policyDataCollection + policyId;
            if (registry.resourceExists(path)) {
                Resource resource = registry.get(path);
                String order = resource.getProperty("order");
                String active = resource.getProperty("active");
                if (order != null && order.trim().length() > 0) {
                    dataDTO.setPolicyOrder(Integer.parseInt(order));
                }
                dataDTO.setActive(Boolean.parseBoolean(active));
            }
        }
        catch (RegistryException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)e);
            }
        }
        catch (EntitlementException e) {
            log.error((Object)("Error while getting policy data for policyId: " + policyId), (Throwable)e);
        }
        return dataDTO;
    }

    @Override
    public PolicyStoreDTO[] getPolicyData() {
        ArrayList<PolicyStoreDTO> policyStoreDTOs = new ArrayList<PolicyStoreDTO>();
        try {
            Registry registry = this.getGovernanceRegistry();
            if (registry.resourceExists(this.policyDataCollection)) {
                String[] paths;
                Collection collection = (Collection)registry.get(this.policyDataCollection);
                for (String path : paths = collection.getChildren()) {
                    if (!registry.resourceExists(path)) continue;
                    PolicyStoreDTO dataDTO = new PolicyStoreDTO();
                    Resource resource = registry.get(path);
                    String order = resource.getProperty("order");
                    String active = resource.getProperty("active");
                    String id = path.substring(path.lastIndexOf("/") + 1);
                    dataDTO.setPolicyId(id);
                    if (order != null && order.trim().length() > 0) {
                        dataDTO.setPolicyOrder(Integer.parseInt(order));
                    }
                    dataDTO.setActive(Boolean.parseBoolean(active));
                    policyStoreDTOs.add(dataDTO);
                }
            }
        }
        catch (RegistryException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)e);
            }
        }
        catch (EntitlementException e) {
            log.error((Object)"Error while getting all policy data.", (Throwable)e);
        }
        return policyStoreDTOs.toArray(new PolicyStoreDTO[policyStoreDTOs.size()]);
    }

    @Override
    public void setPolicyData(String policyId, PolicyStoreDTO policyDataDTO) throws EntitlementException {
        Registry registry = this.getGovernanceRegistry();
        try {
            int order;
            String path = this.policyDataCollection + policyId;
            Object resource = registry.resourceExists(path) ? registry.get(path) : registry.newCollection();
            if (policyDataDTO.isSetActive()) {
                resource.setProperty("active", Boolean.toString(policyDataDTO.isActive()));
            }
            if (policyDataDTO.isSetOrder() && (order = policyDataDTO.getPolicyOrder()) > 0) {
                resource.setProperty("order", Integer.toString(order));
            }
            registry.put(path, (Resource)resource);
        }
        catch (RegistryException e) {
            log.error((Object)"Error while updating Policy data in policy store ", (Throwable)e);
            throw new EntitlementException("Error while updating Policy data in policy store");
        }
    }

    @Override
    public void removePolicyData(String policyId) throws EntitlementException {
        Registry registry = this.getGovernanceRegistry();
        try {
            String path = this.policyDataCollection + policyId;
            if (registry.resourceExists(path)) {
                registry.delete(path);
            }
        }
        catch (RegistryException e) {
            log.error((Object)"Error while deleting Policy data in policy store ", (Throwable)e);
            throw new EntitlementException("Error while deleting Policy data in policy store");
        }
    }

    private Registry getGovernanceRegistry() throws EntitlementException {
        int tenantId = CarbonContext.getThreadLocalCarbonContext().getTenantId();
        Registry registry = EntitlementServiceComponent.getGovernanceRegistry(tenantId);
        if (registry == null) {
            throw new EntitlementException("Unable to get governance registry for tenant: " + tenantId);
        }
        return registry;
    }
}

