/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.entitlement.policy.search;

import org.apache.axis2.clustering.ClusteringCommand;
import org.apache.axis2.clustering.ClusteringFault;
import org.apache.axis2.clustering.ClusteringMessage;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.identity.core.util.IdentityTenantUtil;
import org.wso2.carbon.identity.entitlement.pdp.EntitlementEngine;

public class PolicySearchCacheInvalidationClusteringMessage
extends ClusteringMessage {
    private static Log log = LogFactory.getLog(PolicySearchCacheInvalidationClusteringMessage.class);
    private static final long serialVersionUID = -5025603871368248102L;
    private int tenantId;

    public PolicySearchCacheInvalidationClusteringMessage(int tenantId) {
        this.tenantId = tenantId;
    }

    public ClusteringCommand getResponse() {
        return null;
    }

    public void execute(ConfigurationContext configurationContext) throws ClusteringFault {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Received PolicySearchCacheInvalidationClusteringMessage.");
        }
        int tenantIdInThreadLocalContext = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        try {
            PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(this.tenantId, true);
            EntitlementEngine.getInstance().getPolicySearch().getPolicySearchCache().clearCache();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Local policy search cache is cleared for the tenant: " + IdentityTenantUtil.getTenantDomain((int)this.tenantId) + "."));
            }
        }
        finally {
            PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(tenantIdInThreadLocalContext, true);
        }
    }
}

