/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.entitlement.policy.search;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.balana.ctx.AbstractRequestCtx;
import org.wso2.balana.ctx.AbstractResult;
import org.wso2.balana.ctx.ResponseCtx;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.identity.entitlement.EntitlementException;
import org.wso2.carbon.identity.entitlement.EntitlementUtil;
import org.wso2.carbon.identity.entitlement.cache.PolicySearchCache;
import org.wso2.carbon.identity.entitlement.dto.AttributeDTO;
import org.wso2.carbon.identity.entitlement.dto.EntitledAttributesDTO;
import org.wso2.carbon.identity.entitlement.dto.EntitledResultSetDTO;
import org.wso2.carbon.identity.entitlement.internal.EntitlementServiceComponent;
import org.wso2.carbon.identity.entitlement.pdp.EntitlementEngine;
import org.wso2.carbon.identity.entitlement.policy.finder.PolicyFinderModule;
import org.wso2.carbon.identity.entitlement.policy.search.SearchResult;

public class PolicySearch {
    private static Log log = LogFactory.getLog(PolicySearch.class);
    private List<PolicyFinderModule> finderModules = null;
    private boolean cachingEnable;
    private PolicySearchCache policySearchCache = null;

    public PolicySearch(boolean cachingEnable, int cachingInterval) {
        Map<PolicyFinderModule, Properties> finderModules = EntitlementServiceComponent.getEntitlementConfig().getPolicyFinderModules();
        if (finderModules != null) {
            this.finderModules = new ArrayList<PolicyFinderModule>(finderModules.keySet());
        }
        this.cachingEnable = cachingEnable;
        this.policySearchCache = new PolicySearchCache(cachingInterval);
    }

    public EntitledResultSetDTO getEntitledAttributes(String subjectName, String resourceName, String subjectId, String action, boolean enableChildSearch) throws EntitlementException {
        AttributeDTO subjectAttributeDTO;
        SearchResult searchResult;
        String cacheKey = "";
        if (this.cachingEnable && (searchResult = this.policySearchCache.getFromCache(cacheKey = (subjectId != null ? subjectId : "") + (subjectName != null ? subjectName : "") + (resourceName != null ? resourceName : "") + (action != null ? action : "") + enableChildSearch)) != null) {
            return searchResult.getResultSetDTO();
        }
        boolean hierarchicalResource = false;
        EntitledResultSetDTO resultSetDTO = new EntitledResultSetDTO();
        HashSet<EntitledAttributesDTO> resultSet = new HashSet<EntitledAttributesDTO>();
        if (subjectName != null && subjectName.trim().length() > 0) {
            subjectAttributeDTO = new AttributeDTO();
            subjectAttributeDTO.setCategory("urn:oasis:names:tc:xacml:1.0:subject-category:access-subject");
            subjectAttributeDTO.setAttributeValue(subjectName);
            subjectAttributeDTO.setAttributeDataType("http://www.w3.org/2001/XMLSchema#string");
            if (subjectId != null && subjectId.trim().length() > 0) {
                subjectAttributeDTO.setAttributeId(subjectId);
            } else {
                subjectAttributeDTO.setAttributeId("urn:oasis:names:tc:xacml:1.0:subject:subject-id");
            }
        } else {
            throw new EntitlementException("Error : subject value can not be null");
        }
        if (this.getResponse(Arrays.asList(subjectAttributeDTO))) {
            EntitledAttributesDTO dto = new EntitledAttributesDTO();
            dto.setAllActions(true);
            dto.setAllResources(true);
            EntitledResultSetDTO setDTO = new EntitledResultSetDTO();
            setDTO.setEntitledAttributesDTOs(new EntitledAttributesDTO[]{dto});
            return setDTO;
        }
        for (PolicyFinderModule module : this.finderModules) {
            if (!module.isDefaultCategoriesSupported() || 3 != module.getSupportedSearchAttributesScheme()) continue;
            Map<String, Set<AttributeDTO>> requestMap = module.getSearchAttributes(null, new HashSet<AttributeDTO>(Arrays.asList(subjectAttributeDTO)));
            for (Map.Entry<String, Set<AttributeDTO>> entry : requestMap.entrySet()) {
                Set<AttributeDTO> attributeDTOs = entry.getValue();
                if (attributeDTOs == null) continue;
                HashSet<AttributeDTO> actions = new HashSet<AttributeDTO>();
                HashSet<AttributeDTO> resources = new HashSet<AttributeDTO>();
                HashSet<AttributeDTO> requestAttributes = new HashSet<AttributeDTO>();
                if (resourceName != null && resourceName.trim().length() > 0) {
                    AttributeDTO resourceAttribute = new AttributeDTO();
                    resourceAttribute.setAttributeValue(resourceName);
                    resourceAttribute.setAttributeDataType("http://www.w3.org/2001/XMLSchema#string");
                    resourceAttribute.setAttributeId("urn:oasis:names:tc:xacml:1.0:resource:resource-id");
                    resourceAttribute.setCategory("urn:oasis:names:tc:xacml:3.0:attribute-category:resource");
                    resources.add(resourceAttribute);
                    hierarchicalResource = true;
                }
                AttributeDTO resourceScopeAttribute = new AttributeDTO();
                resourceScopeAttribute.setAttributeValue("Descendants");
                resourceScopeAttribute.setAttributeDataType("http://www.w3.org/2001/XMLSchema#string");
                resourceScopeAttribute.setAttributeId("urn:oasis:names:tc:xacml:1.0:resource:scope");
                resourceScopeAttribute.setCategory("urn:oasis:names:tc:xacml:3.0:attribute-category:resource");
                for (AttributeDTO attributeDTO : attributeDTOs) {
                    if ("urn:oasis:names:tc:xacml:3.0:attribute-category:environment".equals(attributeDTO.getCategory()) || "Environment".equals(attributeDTO.getCategory())) {
                        requestAttributes.add(attributeDTO);
                        attributeDTO.setAttributeId("urn:oasis:names:tc:xacml:1.0:environment:environment-id");
                        requestAttributes.add(attributeDTO);
                        continue;
                    }
                    if ("urn:oasis:names:tc:xacml:3.0:attribute-category:action".equals(attributeDTO.getCategory()) || "Action".equals(attributeDTO.getCategory())) {
                        if (action != null && action.trim().length() > 0) {
                            attributeDTO.setAttributeValue(action);
                        }
                        actions.add(attributeDTO);
                        attributeDTO.setAttributeId("urn:oasis:names:tc:xacml:1.0:action:action-id");
                        actions.add(attributeDTO);
                        continue;
                    }
                    if (!"urn:oasis:names:tc:xacml:3.0:attribute-category:resource".equals(attributeDTO.getCategory()) && !"Resource".equals(attributeDTO.getCategory()) || hierarchicalResource) continue;
                    attributeDTO.setAttributeId("urn:oasis:names:tc:xacml:1.0:resource:resource-id");
                    resources.add(attributeDTO);
                }
                if (resultSetDTO.getMessage() != null) continue;
                ArrayList<String> entitledActions = new ArrayList<String>();
                for (AttributeDTO actionDTO : actions) {
                    ArrayList<AttributeDTO> currentRequestAttributes = new ArrayList<AttributeDTO>();
                    currentRequestAttributes.add(subjectAttributeDTO);
                    currentRequestAttributes.add(actionDTO);
                    if (!this.getResponse(currentRequestAttributes)) continue;
                    EntitledAttributesDTO dto = new EntitledAttributesDTO();
                    dto.setAllResources(true);
                    dto.setAction(actionDTO.getAttributeValue());
                    resultSet.add(dto);
                    entitledActions.add(actionDTO.getAttributeValue());
                }
                for (AttributeDTO resource : resources) {
                    if (!"urn:oasis:names:tc:xacml:3.0:attribute-category:resource".equals(resource.getCategory()) && !"Resource".equals(resource.getCategory())) continue;
                    boolean allActionsAllowed = false;
                    int noOfRequests = 1;
                    if (enableChildSearch) {
                        noOfRequests = 0;
                    }
                    while (noOfRequests < 2) {
                        ArrayList<AttributeDTO> currentRequestAttributes = new ArrayList<AttributeDTO>();
                        for (AttributeDTO dto : requestAttributes) {
                            currentRequestAttributes.add(dto);
                        }
                        if (noOfRequests < 1) {
                            currentRequestAttributes.add(resourceScopeAttribute);
                        }
                        currentRequestAttributes.add(subjectAttributeDTO);
                        currentRequestAttributes.add(resource);
                        if (this.getResponse(currentRequestAttributes)) {
                            EntitledAttributesDTO dto = new EntitledAttributesDTO();
                            dto.setResourceName(resource.getAttributeValue());
                            dto.setAllActions(true);
                            resultSet.add(dto);
                            allActionsAllowed = true;
                        }
                        ++noOfRequests;
                    }
                    if (allActionsAllowed) continue;
                    for (AttributeDTO actionAttributeDTO : actions) {
                        if (entitledActions.contains(actionAttributeDTO.getAttributeValue())) continue;
                        noOfRequests = 1;
                        if (enableChildSearch) {
                            noOfRequests = 0;
                        }
                        while (noOfRequests < 2) {
                            ArrayList<AttributeDTO> currentRequestAttributes = new ArrayList<AttributeDTO>();
                            for (AttributeDTO dto : requestAttributes) {
                                currentRequestAttributes.add(dto);
                            }
                            if (noOfRequests < 1) {
                                currentRequestAttributes.add(resourceScopeAttribute);
                            }
                            currentRequestAttributes.add(subjectAttributeDTO);
                            currentRequestAttributes.add(resource);
                            currentRequestAttributes.add(actionAttributeDTO);
                            if (this.getResponse(currentRequestAttributes)) {
                                EntitledAttributesDTO dto = new EntitledAttributesDTO();
                                dto.setResourceName(resource.getAttributeValue());
                                dto.setAction(actionAttributeDTO.getAttributeValue());
                                resultSet.add(dto);
                            }
                            ++noOfRequests;
                        }
                    }
                }
            }
        }
        resultSetDTO.setEntitledAttributesDTOs(resultSet.toArray(new EntitledAttributesDTO[resultSet.size()]));
        if (this.cachingEnable) {
            SearchResult result = new SearchResult();
            result.setResultSetDTO(resultSetDTO);
            this.policySearchCache.addToCache(cacheKey, result);
            if (log.isDebugEnabled()) {
                int tenantId = CarbonContext.getThreadLocalCarbonContext().getTenantId();
                log.debug((Object)("PDP Decision Cache Updated for tenantId " + tenantId));
            }
        }
        return resultSetDTO;
    }

    public EntitledResultSetDTO getEntitledAttributes(String identifier, AttributeDTO[] givenAttributes) {
        String cacheKey = "";
        if (this.cachingEnable) {
            int hashCode = 0;
            for (AttributeDTO dto : givenAttributes) {
                hashCode += 31 * dto.hashCode();
            }
            cacheKey = identifier + hashCode;
            SearchResult searchResult = this.policySearchCache.getFromCache(cacheKey);
            if (searchResult != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"PDP Search Cache Hit");
                }
                return searchResult.getResultSetDTO();
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"PDP Search Cache Miss");
            }
        }
        EntitledResultSetDTO result = new EntitledResultSetDTO();
        HashSet<EntitledAttributesDTO> resultAttributes = new HashSet<EntitledAttributesDTO>();
        HashSet<AttributeDTO> attributeDTOs = new HashSet<AttributeDTO>(Arrays.asList(givenAttributes));
        for (PolicyFinderModule finderModule : this.finderModules) {
            int supportedSearchScheme;
            Map<String, Set<AttributeDTO>> attributesMap = finderModule.getSearchAttributes(identifier, attributeDTOs);
            Set<List<AttributeDTO>> requestSet = this.getPossibleRequests(attributesMap, supportedSearchScheme = finderModule.getSupportedSearchAttributesScheme());
            if (requestSet == null) {
                log.error((Object)("Invalid Search scheme in policy finder : " + finderModule.getModuleName()));
                continue;
            }
            for (List<AttributeDTO> attributeDTOList : requestSet) {
                if (!this.getResponse(attributeDTOList)) continue;
                EntitledAttributesDTO dto = new EntitledAttributesDTO();
                dto.setAttributeDTOs(attributeDTOList.toArray(new AttributeDTO[attributeDTOList.size()]));
                resultAttributes.add(dto);
            }
        }
        result.setAdvanceResult(true);
        result.setEntitledAttributesDTOs(resultAttributes.toArray(new EntitledAttributesDTO[resultAttributes.size()]));
        if (this.cachingEnable) {
            SearchResult searchResult = new SearchResult();
            searchResult.setResultSetDTO(result);
            this.policySearchCache.addToCache(cacheKey, searchResult);
            if (log.isDebugEnabled()) {
                int tenantId = CarbonContext.getThreadLocalCarbonContext().getTenantId();
                log.debug((Object)("PDP Decision Cache Updated for tenantId " + tenantId));
            }
        }
        return result;
    }

    public void clearCache() {
        this.policySearchCache.clearCache();
    }

    public PolicySearchCache getPolicySearchCache() {
        return this.policySearchCache;
    }

    private Set<List<AttributeDTO>> getPossibleRequests(Map<String, Set<AttributeDTO>> attributesMap, int supportedSearchScheme) {
        if (0 == supportedSearchScheme) {
            if (attributesMap.entrySet() != null) {
                return this.getAllCombinations(attributesMap.entrySet().iterator().next().getValue());
            }
        } else {
            if (1 == supportedSearchScheme) {
                return this.getAllCombinationsWithCategory(attributesMap);
            }
            if (2 == supportedSearchScheme) {
                HashSet<List<AttributeDTO>> requestSet = new HashSet<List<AttributeDTO>>();
                for (Map.Entry<String, Set<AttributeDTO>> entry : attributesMap.entrySet()) {
                    requestSet.addAll(this.getAllCombinations(entry.getValue()));
                }
                return requestSet;
            }
            if (3 == supportedSearchScheme) {
                HashSet<List<AttributeDTO>> requestSet = new HashSet<List<AttributeDTO>>();
                for (Map.Entry<String, Set<AttributeDTO>> entry : attributesMap.entrySet()) {
                    HashMap<String, Set<AttributeDTO>> map = new HashMap<String, Set<AttributeDTO>>();
                    for (AttributeDTO dto : entry.getValue()) {
                        if (!map.containsKey(dto.getCategory())) {
                            HashSet<AttributeDTO> attributeDTOSet = new HashSet<AttributeDTO>();
                            attributeDTOSet.add(dto);
                            map.put(dto.getCategory(), attributeDTOSet);
                        }
                        ((Set)map.get(dto.getCategory())).add(dto);
                    }
                    requestSet.addAll(this.getAllCombinationsWithCategory(map));
                }
                return requestSet;
            }
            if (4 == supportedSearchScheme) {
                HashSet<List<AttributeDTO>> requestSet = new HashSet<List<AttributeDTO>>();
                for (Map.Entry<String, Set<AttributeDTO>> entry : attributesMap.entrySet()) {
                    requestSet.add(new ArrayList(entry.getValue()));
                }
                return requestSet;
            }
        }
        return null;
    }

    private Set<List<AttributeDTO>> getAllCombinations(Set<AttributeDTO> allAttributes) {
        HashSet<List<AttributeDTO>> requestSet = new HashSet<List<AttributeDTO>>();
        if (allAttributes.isEmpty()) {
            requestSet.add(new ArrayList());
            return requestSet;
        }
        ArrayList<AttributeDTO> list = new ArrayList<AttributeDTO>(allAttributes);
        AttributeDTO head = (AttributeDTO)list.get(0);
        HashSet<AttributeDTO> rest = new HashSet<AttributeDTO>(list.subList(1, list.size()));
        for (List<AttributeDTO> set : this.getAllCombinations(rest)) {
            ArrayList<AttributeDTO> newSet = new ArrayList<AttributeDTO>();
            newSet.add(head);
            newSet.addAll(set);
            requestSet.add(newSet);
            requestSet.add(set);
        }
        return requestSet;
    }

    private Set<List<AttributeDTO>> getAllCombinationsWithCategory(Map<String, Set<AttributeDTO>> attributesMap) {
        HashSet<List<AttributeDTO>> requestSet = new HashSet<List<AttributeDTO>>();
        ArrayList<String> categories = new ArrayList<String>(attributesMap.keySet());
        if (!categories.isEmpty()) {
            String category = (String)categories.get(0);
            Set<AttributeDTO> attributeDTOs = attributesMap.get(category);
            for (AttributeDTO dto : attributeDTOs) {
                ArrayList<AttributeDTO> dtoList = new ArrayList<AttributeDTO>();
                dtoList.add(dto);
                if (categories.get(1) == null) continue;
                this.processCombinations(1, categories, attributesMap, dtoList, requestSet);
            }
        }
        return requestSet;
    }

    private void processCombinations(int i, List<String> categories, Map<String, Set<AttributeDTO>> attributesMap, List<AttributeDTO> dtoList, Set<List<AttributeDTO>> requestSet) {
        if (categories.size() > i) {
            String category = categories.get(i);
            ++i;
            if (category != null) {
                ArrayList<AttributeDTO> currentList = new ArrayList<AttributeDTO>(dtoList);
                Set<AttributeDTO> attributeDTOs = attributesMap.get(category);
                for (AttributeDTO dto : attributeDTOs) {
                    dtoList.add(dto);
                    this.processCombinations(i, categories, attributesMap, dtoList, requestSet);
                    requestSet.add(dtoList);
                    dtoList = new ArrayList<AttributeDTO>(currentList);
                }
            }
        }
    }

    private boolean getResponse(List<AttributeDTO> requestAttributes) {
        AbstractRequestCtx requestCtx = EntitlementUtil.createRequestContext(requestAttributes);
        ResponseCtx responseCtx = EntitlementEngine.getInstance().evaluateByContext(requestCtx);
        if (responseCtx != null) {
            Set results = responseCtx.getResults();
            for (AbstractResult result : results) {
                if (result.getDecision() != 0) continue;
                return true;
            }
        }
        return false;
    }
}

