/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.entitlement.policy.publisher;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.core.util.CryptoException;
import org.wso2.carbon.core.util.CryptoUtil;
import org.wso2.carbon.identity.entitlement.EntitlementException;
import org.wso2.carbon.identity.entitlement.PAPStatusDataHandler;
import org.wso2.carbon.identity.entitlement.dto.PublisherDataHolder;
import org.wso2.carbon.identity.entitlement.dto.PublisherPropertyDTO;
import org.wso2.carbon.identity.entitlement.internal.EntitlementServiceComponent;
import org.wso2.carbon.identity.entitlement.policy.publisher.CarbonPDPPublisher;
import org.wso2.carbon.identity.entitlement.policy.publisher.PolicyPublishExecutor;
import org.wso2.carbon.identity.entitlement.policy.publisher.PolicyPublisherModule;
import org.wso2.carbon.identity.entitlement.policy.publisher.PublisherVerificationModule;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;

public class PolicyPublisher {
    public static final String SUBSCRIBER_ID = "subscriberId";
    public static final String SUBSCRIBER_DISPLAY_NAME = "Subscriber Id";
    private static Log log = LogFactory.getLog(PolicyPublisher.class);
    Set<PolicyPublisherModule> publisherModules = new HashSet<PolicyPublisherModule>();
    Set<PAPStatusDataHandler> papStatusDataHandlers = new HashSet<PAPStatusDataHandler>();
    PublisherVerificationModule verificationModule = null;
    private Registry registry = EntitlementServiceComponent.getGovernanceRegistry(CarbonContext.getThreadLocalCarbonContext().getTenantId());

    public PolicyPublisher() {
        Map<PublisherVerificationModule, Properties> prePublisherModules;
        Map<PolicyPublisherModule, Properties> publisherModules = EntitlementServiceComponent.getEntitlementConfig().getPolicyPublisherModules();
        if (publisherModules != null && !publisherModules.isEmpty()) {
            this.publisherModules.addAll(publisherModules.keySet());
        }
        if ((prePublisherModules = EntitlementServiceComponent.getEntitlementConfig().getPublisherVerificationModule()) != null && !prePublisherModules.isEmpty()) {
            this.verificationModule = prePublisherModules.keySet().iterator().next();
        }
        CarbonPDPPublisher publisher = new CarbonPDPPublisher();
        this.publisherModules.add(publisher);
        PublisherDataHolder holder = new PublisherDataHolder(publisher.getModuleName());
        PublisherPropertyDTO dto = new PublisherPropertyDTO();
        dto.setId(SUBSCRIBER_ID);
        dto.setDisplayName(SUBSCRIBER_DISPLAY_NAME);
        dto.setValue("PDP Subscriber");
        holder.setPropertyDTOs(new PublisherPropertyDTO[]{dto});
        try {
            PublisherDataHolder pdpDataHolder = null;
            try {
                pdpDataHolder = this.retrieveSubscriber("PDP Subscriber", false);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (pdpDataHolder == null) {
                this.persistSubscriber(holder, false);
            }
        }
        catch (EntitlementException entitlementException) {
            // empty catch block
        }
    }

    public void publishPolicy(String[] policyIds, String version, String action, boolean enabled, int order, String[] subscriberIds, String verificationCode) throws EntitlementException {
        boolean toPDP = false;
        if (subscriberIds == null) {
            toPDP = true;
        }
        PolicyPublishExecutor executor = new PolicyPublishExecutor(policyIds, version, action, enabled, order, subscriberIds, this, toPDP, verificationCode);
        executor.setTenantDomain(CarbonContext.getThreadLocalCarbonContext().getTenantDomain());
        executor.setTenantId(CarbonContext.getThreadLocalCarbonContext().getTenantId());
        executor.setUserName(CarbonContext.getThreadLocalCarbonContext().getUsername());
        executor.run();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void persistSubscriber(PublisherDataHolder holder, boolean update) throws EntitlementException {
        String subscriberId = null;
        if (holder == null || holder.getPropertyDTOs() == null) {
            log.error((Object)"Publisher data can not be null");
            throw new EntitlementException("Publisher data can not be null");
        }
        for (PublisherPropertyDTO dto : holder.getPropertyDTOs()) {
            if (!SUBSCRIBER_ID.equals(dto.getId())) continue;
            subscriberId = dto.getValue();
        }
        if (subscriberId == null) {
            log.error((Object)"Subscriber Id can not be null");
            throw new EntitlementException("Subscriber Id can not be null");
        }
        try {
            Resource resource;
            if (this.registry.resourceExists("/repository/identity/entitlement/publisher/")) {
                Collection policyCollection = this.registry.newCollection();
                this.registry.put("/repository/identity/entitlement/publisher/", (Resource)policyCollection);
            }
            String subscriberPath = "/repository/identity/entitlement/publisher//" + subscriberId;
            PublisherDataHolder oldHolder = null;
            if (this.registry.resourceExists(subscriberPath)) {
                if (!update) throw new EntitlementException("Subscriber ID already exists");
                resource = this.registry.get(subscriberPath);
                oldHolder = new PublisherDataHolder(resource, false);
            } else {
                resource = this.registry.newResource();
            }
            this.populateProperties(holder, oldHolder, resource);
            this.registry.put(subscriberPath, resource);
            return;
        }
        catch (RegistryException e) {
            log.error((Object)"Error while persisting subscriber details", (Throwable)e);
            throw new EntitlementException("Error while persisting subscriber details", e);
        }
    }

    public void deleteSubscriber(String subscriberId) throws EntitlementException {
        if (subscriberId == null) {
            log.error((Object)"Subscriber Id can not be null");
            throw new EntitlementException("Subscriber Id can not be null");
        }
        if ("PDP Subscriber".equals(subscriberId.trim())) {
            log.error((Object)"Can not delete PDP publisher");
            throw new EntitlementException("Can not delete PDP publisher");
        }
        try {
            String subscriberPath = "/repository/identity/entitlement/publisher//" + subscriberId;
            if (this.registry.resourceExists(subscriberPath)) {
                this.registry.delete(subscriberPath);
            }
        }
        catch (RegistryException e) {
            log.error((Object)"Error while deleting subscriber details", (Throwable)e);
            throw new EntitlementException("Error while deleting subscriber details", e);
        }
    }

    public PublisherDataHolder retrieveSubscriber(String id, boolean returnSecrets) throws EntitlementException {
        try {
            if (this.registry.resourceExists("/repository/identity/entitlement/publisher//" + id)) {
                Resource resource = this.registry.get("/repository/identity/entitlement/publisher//" + id);
                return new PublisherDataHolder(resource, returnSecrets);
            }
        }
        catch (RegistryException e) {
            log.error((Object)("Error while retrieving subscriber detail of id : " + id), (Throwable)e);
            throw new EntitlementException("Error while retrieving subscriber detail of id : " + id, e);
        }
        throw new EntitlementException("No Subscriber is defined for given Id");
    }

    public String[] retrieveSubscriberIds(String searchString) throws EntitlementException {
        try {
            if (this.registry.resourceExists("/repository/identity/entitlement/publisher//")) {
                Resource resource = this.registry.get("/repository/identity/entitlement/publisher//");
                Collection collection = (Collection)resource;
                ArrayList<String> list = new ArrayList<String>();
                if (collection.getChildCount() > 0) {
                    searchString = searchString.replace("*", ".*");
                    Pattern pattern = Pattern.compile(searchString, 2);
                    for (String path : collection.getChildren()) {
                        Resource childResource;
                        String id = path.substring(path.lastIndexOf("/") + 1);
                        Matcher matcher = pattern.matcher(id);
                        if (!matcher.matches() || (childResource = this.registry.get(path)) == null || childResource.getProperty(SUBSCRIBER_ID) == null) continue;
                        list.add(childResource.getProperty(SUBSCRIBER_ID));
                    }
                }
                return list.toArray(new String[list.size()]);
            }
        }
        catch (RegistryException e) {
            log.error((Object)"Error while retrieving subscriber of ids", (Throwable)e);
            throw new EntitlementException("Error while retrieving subscriber ids", e);
        }
        return null;
    }

    private void populateProperties(PublisherDataHolder holder, PublisherDataHolder oldHolder, Resource resource) {
        PublisherPropertyDTO[] propertyDTOs;
        for (PublisherPropertyDTO dto : propertyDTOs = holder.getPropertyDTOs()) {
            if (dto.getId() == null || dto.getValue() == null || dto.getValue().trim().length() <= 0) continue;
            ArrayList<String> list = new ArrayList<String>();
            if (dto.isSecret()) {
                PublisherPropertyDTO propertyDTO = null;
                if (oldHolder != null) {
                    propertyDTO = oldHolder.getPropertyDTO(dto.getId());
                }
                if (propertyDTO == null || !propertyDTO.getValue().equalsIgnoreCase(dto.getValue())) {
                    try {
                        String encryptedValue = CryptoUtil.getDefaultCryptoUtil().encryptAndBase64Encode(dto.getValue().getBytes());
                        dto.setValue(encryptedValue);
                    }
                    catch (CryptoException e) {
                        log.error((Object)"Error while encrypting secret value of subscriber. Secret would not be persist.", (Throwable)e);
                        continue;
                    }
                }
            }
            list.add(dto.getValue());
            list.add(dto.getDisplayName());
            list.add(Integer.toString(dto.getDisplayOrder()));
            list.add(Boolean.toString(dto.isRequired()));
            list.add(Boolean.toString(dto.isSecret()));
            resource.setProperty(dto.getId(), list);
        }
        resource.setProperty("EntitlementModuleName", holder.getModuleName());
    }

    public Set<PolicyPublisherModule> getPublisherModules() {
        return this.publisherModules;
    }

    public Set<PAPStatusDataHandler> getPapStatusDataHandlers() {
        return this.papStatusDataHandlers;
    }

    public void setPapStatusDataHandlers(Set<PAPStatusDataHandler> papStatusDataHandlers) {
        this.papStatusDataHandlers = papStatusDataHandlers;
    }

    public PublisherVerificationModule getVerificationModule() {
        return this.verificationModule;
    }
}

