/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.entitlement.policy.publisher;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.identity.entitlement.EntitlementException;
import org.wso2.carbon.identity.entitlement.PAPStatusDataHandler;
import org.wso2.carbon.identity.entitlement.dto.PolicyDTO;
import org.wso2.carbon.identity.entitlement.dto.PublisherDataHolder;
import org.wso2.carbon.identity.entitlement.dto.StatusHolder;
import org.wso2.carbon.identity.entitlement.internal.EntitlementServiceComponent;
import org.wso2.carbon.identity.entitlement.pap.EntitlementAdminEngine;
import org.wso2.carbon.identity.entitlement.policy.publisher.AbstractPolicyPublisherModule;
import org.wso2.carbon.identity.entitlement.policy.publisher.CarbonPDPPublisher;
import org.wso2.carbon.identity.entitlement.policy.publisher.PolicyPublisher;
import org.wso2.carbon.identity.entitlement.policy.publisher.PolicyPublisherModule;
import org.wso2.carbon.identity.entitlement.policy.publisher.PublisherVerificationModule;
import org.wso2.carbon.identity.entitlement.policy.version.PolicyVersionManager;
import org.wso2.carbon.registry.api.RegistryException;
import org.wso2.carbon.registry.api.Resource;
import org.wso2.carbon.registry.core.Registry;

public class PolicyPublishExecutor {
    private static Log log = LogFactory.getLog(PolicyPublishExecutor.class);
    private String[] policyIds;
    private String[] subscriberIds;
    private PolicyPublisher publisher;
    private String version;
    private String action;
    private String verificationCode;
    private boolean toPDP;
    private String tenantDomain;
    private int tenantId;
    private String userName;
    private int order;
    private boolean enabled;

    public PolicyPublishExecutor(String[] policyIds, String version, String action, boolean enabled, int order, String[] subscriberIds, PolicyPublisher publisher, boolean toPDP, String verificationCode) {
        this.policyIds = policyIds;
        if (toPDP) {
            this.subscriberIds = new String[]{"PDPSubscriber"};
        }
        this.subscriberIds = subscriberIds;
        this.action = action;
        this.version = version;
        this.publisher = publisher;
        this.toPDP = toPDP;
        this.order = order;
        this.enabled = enabled;
        this.verificationCode = verificationCode;
    }

    public void run() {
        PrivilegedCarbonContext.startTenantFlow();
        PrivilegedCarbonContext context = PrivilegedCarbonContext.getThreadLocalCarbonContext();
        context.setTenantDomain(this.tenantDomain);
        context.setTenantId(this.tenantId);
        context.setUsername(this.userName);
        try {
            this.publish();
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }

    public void publish() {
        if ((this.policyIds == null || this.policyIds.length > 0) && this.verificationCode != null) {
            this.loadVerificationCode(this.verificationCode);
        }
        String newVerificationCode = null;
        ArrayList<String> notPublishedSubscribers = new ArrayList<String>();
        PolicyPublisherModule policyPublisherModule = null;
        Set<PolicyPublisherModule> publisherModules = this.publisher.getPublisherModules();
        if (publisherModules == null) {
            return;
        }
        PublisherDataHolder holder = null;
        Set<PAPStatusDataHandler> papStatusDataHandler = this.publisher.getPapStatusDataHandlers();
        for (String subscriberId : this.subscriberIds) {
            ArrayList<StatusHolder> subscriberHolders = new ArrayList<StatusHolder>();
            ArrayList<StatusHolder> policyHolders = new ArrayList<StatusHolder>();
            if (this.toPDP) {
                policyPublisherModule = new CarbonPDPPublisher();
                holder = new PublisherDataHolder(policyPublisherModule.getModuleName());
            } else {
                try {
                    holder = this.publisher.retrieveSubscriber(subscriberId, true);
                }
                catch (EntitlementException e) {
                    log.error((Object)("Subscriber details can not be retrieved. So skip publishing policies for subscriber : " + subscriberId));
                }
                if (holder != null) {
                    for (PolicyPublisherModule publisherModule : publisherModules) {
                        if (!publisherModule.getModuleName().equals(holder.getModuleName())) continue;
                        policyPublisherModule = publisherModule;
                        if (!(policyPublisherModule instanceof AbstractPolicyPublisherModule)) break;
                        try {
                            ((AbstractPolicyPublisherModule)policyPublisherModule).init(holder);
                            break;
                        }
                        catch (Exception e) {
                            subscriberHolders.add(new StatusHolder("PUBLISH_POLICY", subscriberId, this.version, "More than one Policy", this.action, false, e.getMessage()));
                        }
                    }
                }
            }
            if (policyPublisherModule == null) {
                subscriberHolders.add(new StatusHolder("PUBLISH_POLICY", subscriberId, this.version, "More than one Policy", this.action, false, "No policy publish module is defined for subscriber : " + subscriberId));
                continue;
            }
            try {
                PublisherVerificationModule verificationModule = this.publisher.getVerificationModule();
                if (verificationModule != null && !verificationModule.doVerify(this.verificationCode)) {
                    newVerificationCode = verificationModule.getVerificationCode(holder);
                    notPublishedSubscribers.add(subscriberId);
                    break;
                }
            }
            catch (EntitlementException e) {
                log.error((Object)"Error while calling the post verification publisher module", (Throwable)e);
            }
            for (String policyId : this.policyIds) {
                PolicyDTO policyDTO = null;
                if ("CREATE".equalsIgnoreCase(this.action) || "UPDATE".equalsIgnoreCase(this.action)) {
                    PolicyVersionManager manager = EntitlementAdminEngine.getInstance().getVersionManager();
                    try {
                        policyDTO = manager.getPolicy(policyId, this.version);
                    }
                    catch (EntitlementException entitlementException) {}
                } else {
                    policyDTO = new PolicyDTO();
                    policyDTO.setPolicyId(policyId);
                    policyDTO.setVersion(this.version);
                    policyDTO.setPolicyOrder(this.order);
                }
                if (policyDTO == null) {
                    subscriberHolders.add(new StatusHolder("PUBLISH_POLICY", subscriberId, this.version, policyId, this.action, false, "Can not found policy under policy id : " + policyId));
                    policyHolders.add(new StatusHolder("PUBLISH_POLICY", policyId, this.version, subscriberId, this.action, false, "Can not found policy under policy id : " + policyId));
                    continue;
                }
                try {
                    policyPublisherModule.publish(policyDTO, this.action, this.enabled, this.order);
                    subscriberHolders.add(new StatusHolder("PUBLISH_POLICY", subscriberId, this.version, policyId, this.action));
                    policyHolders.add(new StatusHolder("PUBLISH_POLICY", policyId, this.version, subscriberId, this.action));
                }
                catch (Exception e) {
                    subscriberHolders.add(new StatusHolder("PUBLISH_POLICY", subscriberId, this.version, policyId, this.action, false, e.getMessage()));
                    policyHolders.add(new StatusHolder("PUBLISH_POLICY", policyId, this.version, subscriberId, this.action, false, e.getMessage()));
                }
                for (PAPStatusDataHandler module : papStatusDataHandler) {
                    try {
                        module.handle("POLICY", policyId, policyHolders);
                        policyHolders = new ArrayList();
                    }
                    catch (EntitlementException e) {
                        log.error((Object)"Error while calling post publishers", (Throwable)e);
                    }
                }
            }
            for (PAPStatusDataHandler module : papStatusDataHandler) {
                try {
                    module.handle("SUBSCRIBER", subscriberId, subscriberHolders);
                    subscriberHolders = new ArrayList();
                }
                catch (EntitlementException e) {
                    log.error((Object)"Error while calling post publishers", (Throwable)e);
                }
            }
        }
        if (newVerificationCode != null) {
            this.persistVerificationCode(newVerificationCode, notPublishedSubscribers.toArray(new String[notPublishedSubscribers.size()]));
        }
    }

    private void persistVerificationCode(String verificationCode, String[] subscriberIds) {
        Registry registry = EntitlementServiceComponent.getGovernanceRegistry(CarbonContext.getThreadLocalCarbonContext().getTenantId());
        try {
            Resource resource = registry.newResource();
            resource.setProperty("subscriberIds", Arrays.asList(subscriberIds));
            resource.setProperty("policyIds", Arrays.asList(this.policyIds));
            resource.setProperty("action", this.action);
            resource.setProperty("version", this.version);
            resource.setProperty("order", Integer.toString(this.order));
            registry.put("/repository/identity/entitlement/publisher/verification/" + verificationCode, resource);
        }
        catch (RegistryException e) {
            log.error((Object)"Error while persisting verification code", (Throwable)e);
        }
    }

    private void loadVerificationCode(String verificationCode) {
        Registry registry = EntitlementServiceComponent.getGovernanceRegistry(CarbonContext.getThreadLocalCarbonContext().getTenantId());
        try {
            String order;
            String action;
            String version;
            Resource resource = registry.get("/repository/identity/entitlement/publisher/verification/" + verificationCode);
            List list = resource.getPropertyValues("subscriberIds");
            if (list != null) {
                this.subscriberIds = list.toArray(new String[list.size()]);
            }
            if ((list = resource.getPropertyValues("policyIds")) != null) {
                this.policyIds = list.toArray(new String[list.size()]);
            }
            if ((version = resource.getProperty("version")) != null) {
                this.version = version;
            }
            if ((action = resource.getProperty("action")) != null) {
                this.action = action;
            }
            if ((order = resource.getProperty("order")) != null) {
                this.order = Integer.parseInt(order);
            }
        }
        catch (RegistryException e) {
            log.error((Object)"Error while loading verification code", (Throwable)e);
        }
    }

    public void setTenantId(int tenantId) {
        this.tenantId = tenantId;
    }

    public void setTenantDomain(String tenantDomain) {
        this.tenantDomain = tenantDomain;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }
}

