/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.entitlement.policy.publisher;

import java.util.Properties;
import org.wso2.carbon.identity.entitlement.EntitlementException;
import org.wso2.carbon.identity.entitlement.dto.PolicyDTO;
import org.wso2.carbon.identity.entitlement.pap.EntitlementAdminEngine;
import org.wso2.carbon.identity.entitlement.policy.publisher.PolicyPublisherModule;
import org.wso2.carbon.identity.entitlement.policy.store.PolicyStoreManager;

public class CarbonPDPPublisher
implements PolicyPublisherModule {
    @Override
    public void init(Properties properties) {
    }

    @Override
    public Properties loadProperties() {
        return new Properties();
    }

    @Override
    public String getModuleName() {
        return "PDP Publisher";
    }

    @Override
    public void publish(PolicyDTO policyDTO, String action, boolean enabled, int order) throws EntitlementException {
        PolicyStoreManager manager = EntitlementAdminEngine.getInstance().getPolicyStoreManager();
        if ("CREATE".equals(action)) {
            policyDTO.setPolicyOrder(order);
            policyDTO.setActive(enabled);
            manager.addPolicy(policyDTO);
        } else if ("DELETE".equals(action)) {
            manager.removePolicy(policyDTO);
        } else if ("UPDATE".equals(action)) {
            manager.updatePolicy(policyDTO);
        } else if ("ENABLE".equals(action)) {
            policyDTO.setActive(true);
            manager.enableDisablePolicy(policyDTO);
        } else if ("DISABLE".equals(action)) {
            policyDTO.setActive(false);
            manager.enableDisablePolicy(policyDTO);
        } else if ("ORDER".equals(action)) {
            policyDTO.setPolicyOrder(order);
            manager.orderPolicy(policyDTO);
        }
    }
}

