/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.entitlement.policy.publisher;

import java.util.HashMap;
import java.util.Properties;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.axis2.transport.http.HttpTransportProperties;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.entitlement.EntitlementException;
import org.wso2.carbon.identity.entitlement.dto.PolicyDTO;
import org.wso2.carbon.identity.entitlement.dto.PublisherDataHolder;
import org.wso2.carbon.identity.entitlement.dto.PublisherPropertyDTO;
import org.wso2.carbon.identity.entitlement.policy.publisher.AbstractPolicyPublisherModule;

public class CarbonBasicPolicyPublisherModule
extends AbstractPolicyPublisherModule {
    private static final String MODULE_NAME = "Carbon Basic Auth Policy Publisher Module";
    private static Log log = LogFactory.getLog(CarbonBasicPolicyPublisherModule.class);
    private ConfigurationContext configCtx;
    private String serverUrl;
    private String serverUserName;
    private String serverPassword;

    @Override
    public void init(PublisherDataHolder propertyHolder) throws EntitlementException {
        PublisherPropertyDTO[] propertyDTOs;
        for (PublisherPropertyDTO dto : propertyDTOs = propertyHolder.getPropertyDTOs()) {
            if ("subscriberURL".equals(dto.getId())) {
                this.serverUrl = dto.getValue();
                continue;
            }
            if ("subscriberUserName".equals(dto.getId())) {
                this.serverUserName = dto.getValue();
                continue;
            }
            if (!"subscriberPassword".equals(dto.getId())) continue;
            this.serverPassword = dto.getValue();
        }
        try {
            this.configCtx = ConfigurationContextFactory.createConfigurationContextFromFileSystem(null, null);
        }
        catch (AxisFault axisFault) {
            log.error((Object)"Error while initializing module", (Throwable)axisFault);
            throw new EntitlementException("Error while initializing module", axisFault);
        }
    }

    @Override
    public String getModuleName() {
        return MODULE_NAME;
    }

    @Override
    public Properties loadProperties() {
        Properties properties = new Properties();
        HashMap<String, String> dataMap1 = new HashMap<String, String>();
        dataMap1.put("required", "true");
        dataMap1.put("displayName", "Subscriber URL");
        dataMap1.put("order", "1");
        HashMap<String, String> dataMap2 = new HashMap<String, String>();
        dataMap2.put("required", "true");
        dataMap2.put("displayName", "Subscriber User Name");
        dataMap2.put("order", "2");
        HashMap<String, String> dataMap3 = new HashMap<String, String>();
        dataMap3.put("required", "true");
        dataMap3.put("displayName", "Subscriber Password");
        dataMap3.put("order", "3");
        dataMap3.put("password", "true");
        properties.put("subscriberURL", dataMap1);
        properties.put("subscriberUserName", dataMap2);
        properties.put("subscriberPassword", dataMap3);
        return properties;
    }

    @Override
    public void publishNew(PolicyDTO policyDTO) throws EntitlementException {
        String body = "<xsd:addPolicy xmlns:xsd=\"http://org.apache.axis2/xsd\" xmlns:xsd1=\"http://dto.entitlement.identity.carbon.wso2.org/xsd\">  <xsd:policyDTO>  <xsd1:active>" + Boolean.toString(policyDTO.isActive()) + "</xsd1:active>  <xsd1:policy><![CDATA[" + policyDTO.getPolicy() + "]]>  </xsd1:policy>  <xsd1:policyId>" + policyDTO.getPolicyId() + "</xsd1:policyId>  <xsd1:policyOrder>" + policyDTO.getPolicyOrder() + "</xsd1:policyOrder>  <xsd1:promote>true</xsd1:promote>  </xsd:policyDTO>  </xsd:addPolicy>";
        this.doSend(body);
    }

    @Override
    public void order(PolicyDTO policyDTO) throws EntitlementException {
        String body = "<xsd:orderPolicy xmlns:xsd=\"http://org.apache.axis2/xsd\"><xsd:policyId>" + policyDTO.getPolicyId() + "</xsd:policyId><xsd:newOrder>" + policyDTO.getPolicyOrder() + "</xsd:newOrder></xsd:orderPolicy>";
        this.doSend(body);
    }

    @Override
    public void disable(PolicyDTO policyDTO) throws EntitlementException {
        String body = "<xsd:enableDisablePolicy  xmlns:xsd=\"http://org.apache.axis2/xsd\"><xsd:policyId>" + policyDTO.getPolicyId() + "</xsd:policyId><xsd:enable>false</xsd:enable></xsd:enableDisablePolicy>";
        this.doSend(body);
    }

    @Override
    public void enable(PolicyDTO policyDTO) throws EntitlementException {
        String body = "<xsd:enableDisablePolicy  xmlns:xsd=\"http://org.apache.axis2/xsd\"><xsd:policyId>" + policyDTO.getPolicyId() + "</xsd:policyId><xsd:enable>true</xsd:enable></xsd:enableDisablePolicy>";
        this.doSend(body);
    }

    @Override
    public void update(PolicyDTO policyDTO) throws EntitlementException {
        String body = "<xsd:updatePolicy xmlns:xsd=\"http://org.apache.axis2/xsd\" xmlns:xsd1=\"http://dto.entitlement.identity.carbon.wso2.org/xsd\">  <xsd:policyDTO>  <xsd1:policy><![CDATA[" + policyDTO.getPolicy() + "]]>  </xsd1:policy>  <xsd:policyId>" + policyDTO.getPolicyId() + "</xsd:policyId>  <xsd1:promote>true</xsd1:promote>  </xsd:policyDTO>  </xsd:updatePolicy>";
        this.doSend(body);
    }

    @Override
    public void delete(PolicyDTO policyDTO) throws EntitlementException {
        String body = "<xsd:dePromotePolicy xmlns:xsd=\"http://org.apache.axis2/xsd\"><xsd:policyId>" + policyDTO.getPolicyId() + "</xsd:policyId></xsd:dePromotePolicy>";
        this.doSend(body);
    }

    private void doSend(String body) throws EntitlementException {
        if (this.serverUrl != null) {
            this.serverUrl = this.serverUrl.trim();
            if (!this.serverUrl.endsWith("/")) {
                this.serverUrl = this.serverUrl + "/";
            }
        }
        String serverEndPoint = this.serverUrl + "EntitlementPolicyAdminService";
        ServiceClient client = null;
        try {
            MultiThreadedHttpConnectionManager httpConnectionManager = new MultiThreadedHttpConnectionManager();
            HttpClient httpClient = new HttpClient((HttpConnectionManager)httpConnectionManager);
            client = new ServiceClient(this.configCtx, null);
            Options option = client.getOptions();
            option.setManageSession(true);
            HttpTransportProperties.Authenticator authenticator = new HttpTransportProperties.Authenticator();
            authenticator.setUsername(this.serverUserName);
            authenticator.setPassword(this.serverPassword);
            authenticator.setPreemptiveAuthentication(true);
            option.setProperty("_NTLM_DIGEST_BASIC_AUTHENTICATION_", (Object)authenticator);
            option.setProperty("TransportURL", (Object)serverEndPoint);
            option.setProperty("REUSE_HTTP_CLIENT", (Object)"true");
            option.setProperty("CACHED_HTTP_CLIENT", (Object)httpClient);
            client.sendRobust(AXIOMUtil.stringToOM((String)body));
        }
        catch (AxisFault axisFault) {
            log.error((Object)("Policy publish fails due : " + axisFault.getMessage()), (Throwable)axisFault);
            throw new EntitlementException("Policy publish fails due : " + axisFault.getMessage());
        }
        catch (XMLStreamException e) {
            log.error((Object)("Policy publish fails due : " + e.getMessage()), (Throwable)e);
            throw new EntitlementException("Policy publish fails due : " + e.getMessage());
        }
        finally {
            if (client != null) {
                try {
                    client.cleanupTransport();
                    client.cleanup();
                }
                catch (AxisFault axisFault) {
                    log.error((Object)"Error while cleaning HTTP client", (Throwable)axisFault);
                }
            }
        }
    }
}

