/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.entitlement.policy.publisher;

import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.entitlement.EntitlementException;
import org.wso2.carbon.identity.entitlement.dto.PolicyDTO;
import org.wso2.carbon.identity.entitlement.dto.PublisherDataHolder;
import org.wso2.carbon.identity.entitlement.dto.PublisherPropertyDTO;
import org.wso2.carbon.identity.entitlement.internal.EntitlementServiceComponent;
import org.wso2.carbon.identity.entitlement.policy.publisher.PolicyPublisherModule;

public abstract class AbstractPolicyPublisherModule
implements PolicyPublisherModule {
    protected static final String REQUIRED = "required";
    protected static final String DISPLAY_NAME = "displayName";
    protected static final String ORDER = "order";
    protected static final String SECRET = "password";
    private static Log log = LogFactory.getLog(AbstractPolicyPublisherModule.class);

    @Override
    public void init(Properties properties) {
        ArrayList<PublisherPropertyDTO> propertyDTOs = new ArrayList<PublisherPropertyDTO>();
        if (properties == null || properties.size() == 0) {
            properties = this.loadProperties();
        }
        if (properties != null) {
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                Object value = entry.getValue();
                if (!(value instanceof Map)) {
                    return;
                }
                Map attributeMap = (Map)value;
                PublisherPropertyDTO dto = new PublisherPropertyDTO();
                dto.setModule(this.getModuleName());
                dto.setId((String)entry.getKey());
                if (attributeMap.get(DISPLAY_NAME) != null) {
                    dto.setDisplayName((String)attributeMap.get(DISPLAY_NAME));
                } else {
                    log.error((Object)"Invalid policy publisher configuration : Display name can not be null");
                }
                if (attributeMap.get(ORDER) != null) {
                    dto.setDisplayOrder(Integer.parseInt((String)attributeMap.get(ORDER)));
                }
                if (attributeMap.get(REQUIRED) != null) {
                    dto.setRequired(Boolean.parseBoolean((String)attributeMap.get(REQUIRED)));
                }
                if (attributeMap.get(SECRET) != null) {
                    dto.setSecret(Boolean.parseBoolean((String)attributeMap.get(SECRET)));
                }
                propertyDTOs.add(dto);
            }
        }
        PublisherPropertyDTO preDefined1 = new PublisherPropertyDTO();
        preDefined1.setId("subscriberId");
        preDefined1.setModule(this.getModuleName());
        preDefined1.setDisplayName("Subscriber Id");
        preDefined1.setRequired(true);
        preDefined1.setDisplayOrder(0);
        propertyDTOs.add(preDefined1);
        PublisherDataHolder holder = new PublisherDataHolder(this.getModuleName());
        holder.setPropertyDTOs(propertyDTOs.toArray(new PublisherPropertyDTO[propertyDTOs.size()]));
        EntitlementServiceComponent.getEntitlementConfig().addModulePropertyHolder(PolicyPublisherModule.class.getName(), holder);
    }

    @Override
    public Properties loadProperties() {
        return null;
    }

    @Override
    public void publish(PolicyDTO policyDTO, String action, boolean enabled, int order) throws EntitlementException {
        if ("CREATE".equals(action)) {
            policyDTO.setPolicyOrder(order);
            policyDTO.setActive(enabled);
            this.publishNew(policyDTO);
        } else if ("DELETE".equals(action)) {
            this.delete(policyDTO);
        } else if ("UPDATE".equals(action)) {
            this.update(policyDTO);
        } else if ("ENABLE".equals(action)) {
            policyDTO.setActive(true);
            this.enable(policyDTO);
        } else if ("DISABLE".equals(action)) {
            policyDTO.setActive(false);
            this.disable(policyDTO);
        } else if ("ORDER".equals(action)) {
            policyDTO.setPolicyOrder(order);
            this.order(policyDTO);
        } else {
            throw new EntitlementException("Unsupported publishing action. Action is : " + action);
        }
    }

    public abstract void init(PublisherDataHolder var1) throws EntitlementException;

    public abstract void publishNew(PolicyDTO var1) throws EntitlementException;

    public abstract void update(PolicyDTO var1) throws EntitlementException;

    public abstract void delete(PolicyDTO var1) throws EntitlementException;

    public abstract void order(PolicyDTO var1) throws EntitlementException;

    public abstract void disable(PolicyDTO var1) throws EntitlementException;

    public abstract void enable(PolicyDTO var1) throws EntitlementException;
}

