/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.entitlement.policy.finder.registry;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.balana.AbstractPolicy;
import org.wso2.carbon.identity.entitlement.EntitlementException;
import org.wso2.carbon.identity.entitlement.PolicyOrderComparator;
import org.wso2.carbon.identity.entitlement.dto.PolicyDTO;
import org.wso2.carbon.identity.entitlement.pap.PAPPolicyReader;
import org.wso2.carbon.identity.entitlement.policy.PolicyAttributeBuilder;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;

public class RegistryPolicyReader {
    private static Log log = LogFactory.getLog(RegistryPolicyReader.class);
    private Registry registry;
    private String policyStorePath;

    public RegistryPolicyReader(Registry registry, String policyStorePath) {
        this.registry = registry;
        this.policyStorePath = policyStorePath;
    }

    public PolicyDTO readPolicy(String policyId) throws EntitlementException {
        Resource resource = null;
        resource = this.getPolicyResource(policyId);
        if (resource == null) {
            return new PolicyDTO();
        }
        return this.readPolicy(resource);
    }

    public PolicyDTO[] readAllPolicies(boolean active, boolean order) throws EntitlementException {
        Resource[] resources = null;
        resources = this.getAllPolicyResource();
        if (resources == null) {
            return new PolicyDTO[0];
        }
        ArrayList<PolicyDTO> policyDTOList = new ArrayList<PolicyDTO>();
        for (Resource resource : resources) {
            PolicyDTO policyDTO = this.readPolicy(resource);
            if (active) {
                if (!policyDTO.isActive()) continue;
                policyDTOList.add(policyDTO);
                continue;
            }
            policyDTOList.add(policyDTO);
        }
        PolicyDTO[] policyDTOs = policyDTOList.toArray(new PolicyDTO[policyDTOList.size()]);
        if (order) {
            Arrays.sort(policyDTOs, new PolicyOrderComparator());
        }
        return policyDTOs;
    }

    public String[] getAllPolicyIds() throws EntitlementException {
        String path = null;
        Collection collection = null;
        String[] children = null;
        ArrayList<String> resources = new ArrayList<String>();
        if (log.isDebugEnabled()) {
            log.debug((Object)"Retrieving all entitlement policies");
        }
        try {
            path = this.policyStorePath;
            if (!this.registry.resourceExists(path)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Trying to access an entitlement policy which does not exist");
                }
                return null;
            }
            collection = (Collection)this.registry.get(path);
            for (String child : children = collection.getChildren()) {
                String id = child.substring(child.lastIndexOf("/") + 1);
                resources.add(id);
            }
        }
        catch (RegistryException e) {
            log.error((Object)"Error while retrieving entitlement policy resources", (Throwable)e);
            throw new EntitlementException("Error while retrieving entitlement policy resources", e);
        }
        return resources.toArray(new String[resources.size()]);
    }

    private PolicyDTO readPolicy(Resource resource) throws EntitlementException {
        String policy = null;
        AbstractPolicy absPolicy = null;
        PolicyDTO dto = null;
        try {
            if (resource.getContent() == null) {
                throw new EntitlementException("Error while loading entitlement policy. Policy content is null");
            }
            policy = new String((byte[])resource.getContent(), Charset.forName("UTF-8"));
            absPolicy = PAPPolicyReader.getInstance(null).getPolicy(policy);
            dto = new PolicyDTO();
            dto.setPolicyId(absPolicy.getId().toASCIIString());
            dto.setPolicy(policy);
            String policyOrder = resource.getProperty("order");
            if (policyOrder != null) {
                dto.setPolicyOrder(Integer.parseInt(policyOrder));
            } else {
                dto.setPolicyOrder(0);
            }
            String policyActive = resource.getProperty("active");
            if (policyActive != null) {
                dto.setActive(Boolean.parseBoolean(policyActive));
            }
            PolicyAttributeBuilder policyAttributeBuilder = new PolicyAttributeBuilder();
            dto.setAttributeDTOs(policyAttributeBuilder.getPolicyMetaDataFromRegistryProperties(resource.getProperties()));
            return dto;
        }
        catch (RegistryException e) {
            log.error((Object)"Error while loading entitlement policy", (Throwable)e);
            throw new EntitlementException("Error while loading entitlement policy", e);
        }
    }

    public String readPolicyCombiningAlgorithm() throws EntitlementException {
        try {
            Collection policyCollection = null;
            if (this.registry.resourceExists(this.policyStorePath)) {
                policyCollection = (Collection)this.registry.get(this.policyStorePath);
            }
            if (policyCollection != null) {
                return policyCollection.getProperty("globalPolicyCombiningAlgorithm");
            }
            return null;
        }
        catch (RegistryException e) {
            log.error((Object)"Error while reading policy combining algorithm", (Throwable)e);
            throw new EntitlementException("Error while reading policy combining algorithm", e);
        }
    }

    private Resource getPolicyResource(String policyId) throws EntitlementException {
        String path = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Retrieving entitlement policy");
        }
        try {
            path = this.policyStorePath + policyId;
            if (!this.registry.resourceExists(path)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Trying to access an entitlement policy which does not exist");
                }
                return null;
            }
            return this.registry.get(path);
        }
        catch (RegistryException e) {
            log.error((Object)("Error while retrieving entitlement policy : " + policyId), (Throwable)e);
            throw new EntitlementException("Error while retrieving entitlement policy : " + policyId, e);
        }
    }

    private Resource[] getAllPolicyResource() throws EntitlementException {
        String path = null;
        Collection collection = null;
        ArrayList<Resource> resources = new ArrayList<Resource>();
        String[] children = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Retrieving all entitlement policies");
        }
        try {
            path = this.policyStorePath;
            if (!this.registry.resourceExists(path)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Trying to access an entitlement policy which does not exist");
                }
                return null;
            }
            collection = (Collection)this.registry.get(path);
            for (String aChildren : children = collection.getChildren()) {
                resources.add(this.registry.get(aChildren));
            }
        }
        catch (RegistryException e) {
            log.error((Object)"Error while retrieving entitlement policy", (Throwable)e);
            throw new EntitlementException("Error while retrieving entitlement policies", e);
        }
        return resources.toArray(new Resource[resources.size()]);
    }
}

