/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.entitlement.policy.finder;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.balana.AbstractPolicy;
import org.wso2.balana.Policy;
import org.wso2.balana.PolicyMetaData;
import org.wso2.balana.PolicySet;
import org.wso2.balana.VersionConstraints;
import org.wso2.balana.combine.PolicyCombiningAlgorithm;
import org.wso2.balana.ctx.EvaluationCtx;
import org.wso2.balana.ctx.Status;
import org.wso2.balana.finder.PolicyFinder;
import org.wso2.balana.finder.PolicyFinderResult;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.identity.entitlement.EntitlementException;
import org.wso2.carbon.identity.entitlement.PolicyOrderComparator;
import org.wso2.carbon.identity.entitlement.cache.PolicyStatus;
import org.wso2.carbon.identity.entitlement.dto.PolicyDTO;
import org.wso2.carbon.identity.entitlement.internal.EntitlementServiceComponent;
import org.wso2.carbon.identity.entitlement.pdp.EntitlementEngine;
import org.wso2.carbon.identity.entitlement.policy.PolicyReader;
import org.wso2.carbon.identity.entitlement.policy.collection.PolicyCollection;
import org.wso2.carbon.identity.entitlement.policy.collection.SimplePolicyCollection;
import org.wso2.carbon.identity.entitlement.policy.finder.PolicyFinderModule;
import org.wso2.carbon.identity.entitlement.policy.store.DefaultPolicyDataStore;
import org.wso2.carbon.identity.entitlement.policy.store.PolicyDataStore;

public class CarbonPolicyFinder
extends org.wso2.balana.finder.PolicyFinderModule {
    private static Log log = LogFactory.getLog(CarbonPolicyFinder.class);
    public PolicyReader policyReader;
    private List<PolicyFinderModule> finderModules = null;
    private PolicyCollection policyCollection;
    private List<PolicyDTO> policyCollectionOrder = new ArrayList<PolicyDTO>();
    private PolicyFinder finder;
    private volatile boolean initFinish;
    private LinkedHashMap<URI, AbstractPolicy> policyReferenceCache = null;
    private int maxReferenceCacheEntries = 10;

    public void init(PolicyFinder finder) {
        this.initFinish = false;
        this.finder = finder;
        this.init();
        this.policyReferenceCache.clear();
    }

    private synchronized void init() {
        if (this.initFinish) {
            return;
        }
        log.info((Object)("Initializing of policy store is started at :  " + new Date()));
        String maxEntries = EntitlementServiceComponent.getEntitlementConfig().getEngineProperties().getProperty("PDP.References.MaxPolicyEntries");
        if (maxEntries != null) {
            try {
                this.maxReferenceCacheEntries = Integer.parseInt(maxEntries.trim());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.policyReferenceCache = new LinkedHashMap<URI, AbstractPolicy>(){

            @Override
            protected boolean removeEldestEntry(Map.Entry eldest) {
                return this.size() > CarbonPolicyFinder.this.maxReferenceCacheEntries;
            }
        };
        PolicyCombiningAlgorithm policyCombiningAlgorithm = null;
        Map<PolicyFinderModule, Properties> finderModules = EntitlementServiceComponent.getEntitlementConfig().getPolicyFinderModules();
        if (finderModules != null) {
            this.finderModules = new ArrayList<PolicyFinderModule>(finderModules.keySet());
        }
        PolicyCollection tempPolicyCollection = null;
        Map<PolicyCollection, Properties> policyCollections = EntitlementServiceComponent.getEntitlementConfig().getPolicyCollections();
        tempPolicyCollection = policyCollections != null && policyCollections.size() > 0 ? policyCollections.entrySet().iterator().next().getKey() : new SimplePolicyCollection();
        this.policyReader = PolicyReader.getInstance(this.finder);
        if (this.finderModules != null && this.finderModules.size() > 0) {
            Map<PolicyDataStore, Properties> dataStoreModules = EntitlementServiceComponent.getEntitlementConfig().getPolicyDataStore();
            PolicyDataStore policyDataStore = dataStoreModules != null && dataStoreModules.size() > 0 ? dataStoreModules.entrySet().iterator().next().getKey() : new DefaultPolicyDataStore();
            policyCombiningAlgorithm = policyDataStore.getGlobalPolicyAlgorithm();
            tempPolicyCollection.setPolicyCombiningAlgorithm(policyCombiningAlgorithm);
            for (PolicyFinderModule finderModule : this.finderModules) {
                log.info((Object)("Start retrieving policies from " + finderModule + " at : " + new Date()));
                String[] policies = finderModule.getActivePolicies();
                for (int a = 0; a < policies.length; ++a) {
                    String policy = policies[a];
                    AbstractPolicy abstractPolicy = this.policyReader.getPolicy(policy);
                    if (abstractPolicy == null) continue;
                    PolicyDTO policyDTO = new PolicyDTO();
                    policyDTO.setPolicyId(abstractPolicy.getId().toString());
                    policyDTO.setPolicyOrder(a);
                    this.policyCollectionOrder.add(policyDTO);
                    tempPolicyCollection.addPolicy(abstractPolicy);
                }
                log.info((Object)("Finish retrieving policies from " + finderModule + " at : " + new Date()));
            }
        } else {
            log.warn((Object)"No Carbon policy finder modules are registered");
        }
        this.policyCollection = tempPolicyCollection;
        this.initFinish = true;
        log.info((Object)("Initializing of policy store is finished at :  " + new Date()));
    }

    public String getIdentifier() {
        return super.getIdentifier();
    }

    public boolean isRequestSupported() {
        return true;
    }

    public boolean isIdReferenceSupported() {
        return true;
    }

    private void orderPolicyCache() {
        LinkedHashMap policyMap = this.policyCollection.getPolicyMap();
        Collections.sort(this.policyCollectionOrder, new PolicyOrderComparator());
        LinkedHashMap newPolicyMap = new LinkedHashMap();
        Iterator<PolicyDTO> policyDTOIterator = this.policyCollectionOrder.iterator();
        while (policyDTOIterator.hasNext()) {
            try {
                URI policyURI = new URI(policyDTOIterator.next().getPolicyId());
                newPolicyMap.put(policyURI, policyMap.get(policyURI));
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PolicyFinderResult findPolicy(EvaluationCtx context) {
        if (EntitlementEngine.getInstance().getPolicyCache().isInvalidate()) {
            this.init(this.finder);
            this.policyReferenceCache.clear();
            EntitlementEngine.getInstance().clearDecisionCache();
            EntitlementEngine.getInstance().resetCacheInvalidateState();
            if (log.isDebugEnabled()) {
                int tenantId = CarbonContext.getThreadLocalCarbonContext().getTenantId();
                log.debug((Object)("Invalidation cache message is received. Re-initialized policy finder module of current node and invalidate decision caching for tenantId : " + tenantId));
            }
        } else {
            Collection<PolicyStatus> policies = EntitlementEngine.getInstance().getPolicyCache().getInvalidatedPolicies();
            if (policies != null && policies.size() > 0) {
                Collection<PolicyStatus> collection = policies;
                synchronized (collection) {
                    boolean isReorder = false;
                    this.policyReferenceCache.clear();
                    EntitlementEngine.getInstance().clearDecisionCache();
                    for (PolicyStatus policyStatus : policies) {
                        PolicyDTO policyDTO;
                        int order;
                        if ("DELETE".equals(policyStatus.getPolicyAction())) {
                            this.policyCollection.deletePolicy(policyStatus.getPolicyId());
                            this.policyCollectionOrder.remove(new PolicyDTO(policyStatus.getPolicyId()));
                            continue;
                        }
                        if ("UPDATE".equals(policyStatus.getPolicyAction())) {
                            AbstractPolicy abstractPolicy = this.loadPolicy(policyStatus.getPolicyId());
                            this.policyCollection.addPolicy(abstractPolicy);
                            continue;
                        }
                        if ("CREATE".equals(policyStatus.getPolicyAction())) {
                            AbstractPolicy abstractPolicy = this.loadPolicy(policyStatus.getPolicyId());
                            this.policyCollection.addPolicy(abstractPolicy);
                            isReorder = true;
                            continue;
                        }
                        if (!"ORDER".equals(policyStatus.getPolicyAction()) || (order = this.getPolicyOrder(policyStatus.getPolicyId())) == -1 || this.policyCollectionOrder.indexOf(policyDTO = new PolicyDTO(policyStatus.getPolicyId())) == -1) continue;
                        this.policyCollectionOrder.get(this.policyCollectionOrder.indexOf(policyDTO)).setPolicyOrder(order);
                        isReorder = true;
                    }
                    if (isReorder) {
                        this.orderPolicyCache();
                    }
                    policies.clear();
                }
            }
        }
        try {
            AbstractPolicy policy = this.policyCollection.getEffectivePolicy(context);
            if (policy == null) {
                return new PolicyFinderResult();
            }
            return new PolicyFinderResult(policy);
        }
        catch (EntitlementException e) {
            ArrayList<String> code = new ArrayList<String>();
            code.add("urn:oasis:names:tc:xacml:1.0:status:processing-error");
            Status status = new Status(code, e.getMessage());
            return new PolicyFinderResult(status);
        }
    }

    private AbstractPolicy loadPolicy(String policyId) {
        if (this.finderModules != null) {
            for (PolicyFinderModule finderModule : this.finderModules) {
                AbstractPolicy policy;
                String policyString = finderModule.getPolicy(policyId);
                if (policyString == null || (policy = this.policyReader.getPolicy(policyString)) == null) continue;
                return policy;
            }
        }
        return null;
    }

    private int getPolicyOrder(String policyId) {
        int order;
        block1: {
            PolicyFinderModule finderModule;
            order = -1;
            if (this.finderModules == null) break block1;
            Iterator<PolicyFinderModule> iterator = this.finderModules.iterator();
            while (iterator.hasNext() && (order = (finderModule = iterator.next()).getPolicyOrder(policyId)) == -1) {
            }
        }
        return order;
    }

    public PolicyFinderResult findPolicy(URI idReference, int type, VersionConstraints constraints, PolicyMetaData parentMetaData) {
        AbstractPolicy policy = this.policyReferenceCache.get(idReference);
        if (policy == null && this.finderModules != null) {
            for (PolicyFinderModule finderModule : this.finderModules) {
                String policyString = finderModule.getReferencedPolicy(idReference.toString());
                if (policyString == null || (policy = this.policyReader.getPolicy(policyString)) == null) continue;
                this.policyReferenceCache.put(idReference, policy);
                break;
            }
        }
        if (policy != null && (type == 0 ? policy instanceof Policy : policy instanceof PolicySet)) {
            return new PolicyFinderResult(policy);
        }
        return new PolicyFinderResult();
    }

    public void clearPolicyCache() {
        EntitlementEngine.getInstance().getPolicyCache().clear();
    }
}

