/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.entitlement.policy.finder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.entitlement.PolicyOrderComparator;
import org.wso2.carbon.identity.entitlement.dto.AttributeDTO;
import org.wso2.carbon.identity.entitlement.dto.PolicyStoreDTO;
import org.wso2.carbon.identity.entitlement.pap.EntitlementAdminEngine;
import org.wso2.carbon.identity.entitlement.pdp.EntitlementEngine;
import org.wso2.carbon.identity.entitlement.policy.finder.PolicyFinderModule;

public abstract class AbstractPolicyFinderModule
implements PolicyFinderModule {
    private static Log log = LogFactory.getLog(AbstractPolicyFinderModule.class);

    public static void invalidateCache(String policyId, String action) {
        EntitlementEngine.getInstance().getPolicyCache().invalidateCache(policyId, action);
        EntitlementEngine.getInstance().clearDecisionCache();
        EntitlementEngine.getInstance().getPolicySearch().getPolicySearchCache().invalidateCache();
    }

    public static void invalidateCache() {
        EntitlementEngine.getInstance().clearDecisionCache();
        EntitlementEngine.getInstance().invalidatePolicyCache();
        EntitlementEngine.getInstance().getPolicySearch().getPolicySearchCache().invalidateCache();
    }

    @Override
    public String[] getOrderedPolicyIdentifiers() {
        log.debug((Object)("Start retrieving ordered policy identifiers at : " + new Date()));
        String[] policyIdentifiers = this.getPolicyIdentifiers();
        if (policyIdentifiers != null && !this.isPolicyOrderingSupport()) {
            PolicyStoreDTO[] policyDTOs = EntitlementAdminEngine.getInstance().getPolicyStoreManager().getAllPolicyData();
            Arrays.sort(policyDTOs, new PolicyOrderComparator());
            ArrayList<String> list = new ArrayList<String>();
            ArrayList<String> finalList = new ArrayList<String>();
            list.addAll(Arrays.asList(policyIdentifiers));
            for (PolicyStoreDTO dto : policyDTOs) {
                list.remove(dto.getPolicyId());
                finalList.add(dto.getPolicyId());
            }
            finalList.addAll(list);
            return finalList.toArray(new String[finalList.size()]);
        }
        log.debug((Object)("Finish retrieving ordered policy identifiers at : " + new Date()));
        return policyIdentifiers;
    }

    @Override
    public String[] getActivePolicies() {
        log.debug((Object)("Start retrieving active policies at : " + new Date()));
        ArrayList<String> policies = new ArrayList<String>();
        String[] policyIdentifiers = this.getOrderedPolicyIdentifiers();
        if (policyIdentifiers != null) {
            for (String identifier : policyIdentifiers) {
                if (!this.isPolicyDeActivationSupport()) {
                    String policy;
                    PolicyStoreDTO data = EntitlementAdminEngine.getInstance().getPolicyDataStore().getPolicyData(identifier);
                    if (data == null || !data.isActive() || (policy = this.getPolicy(identifier)) == null) continue;
                    policies.add(policy);
                    continue;
                }
                String policy = this.getPolicy(identifier);
                if (policy == null) continue;
                policies.add(policy);
            }
        }
        log.debug((Object)("Finish retrieving active policies at : " + new Date()));
        return policies.toArray(new String[policies.size()]);
    }

    @Override
    public boolean isDefaultCategoriesSupported() {
        return true;
    }

    @Override
    public boolean isPolicyOrderingSupport() {
        return false;
    }

    @Override
    public boolean isPolicyDeActivationSupport() {
        return false;
    }

    @Override
    public Map<String, Set<AttributeDTO>> getSearchAttributes(String identifier, Set<AttributeDTO> givenAttribute) {
        return null;
    }

    @Override
    public int getSupportedSearchAttributesScheme() {
        return 0;
    }

    protected abstract String[] getPolicyIdentifiers();
}

