/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.entitlement.policy.collection;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.balana.AbstractPolicy;
import org.wso2.balana.MatchResult;
import org.wso2.balana.Policy;
import org.wso2.balana.PolicySet;
import org.wso2.balana.VersionConstraints;
import org.wso2.balana.combine.PolicyCombiningAlgorithm;
import org.wso2.balana.ctx.EvaluationCtx;
import org.wso2.carbon.identity.entitlement.EntitlementException;
import org.wso2.carbon.identity.entitlement.policy.collection.PolicyCollection;

public class SimplePolicyCollection
implements PolicyCollection {
    private static Log log = LogFactory.getLog(SimplePolicyCollection.class);
    private LinkedHashMap<URI, AbstractPolicy> policyCollection = new LinkedHashMap();
    private PolicyCombiningAlgorithm combiningAlg;
    private URI parentId;

    @Override
    public void init(Properties properties) throws Exception {
        String parentIdProperty = properties.getProperty("parentId");
        if (parentIdProperty != null) {
            this.parentId = new URI(parentIdProperty);
        }
    }

    @Override
    public boolean addPolicy(AbstractPolicy policy) {
        return this.addPolicy(policy.getId(), policy);
    }

    @Override
    public AbstractPolicy getEffectivePolicy(EvaluationCtx context) throws EntitlementException {
        ArrayList<AbstractPolicy> list = new ArrayList<AbstractPolicy>();
        for (Map.Entry<URI, AbstractPolicy> entry : this.policyCollection.entrySet()) {
            AbstractPolicy policy = entry.getValue();
            MatchResult match = policy.match(context);
            int result = match.getResult();
            if (result == 2) {
                log.error((Object)match.getStatus().getMessage());
                throw new EntitlementException(match.getStatus().getMessage());
            }
            if (result != 0) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Matching XACML policy found " + policy.getId().toString()));
            }
            if (this.combiningAlg == null && list.size() > 0) {
                log.error((Object)"Too many applicable top-level policies");
                throw new EntitlementException("Too many applicable top-level policies");
            }
            list.add(policy);
        }
        switch (list.size()) {
            case 0: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"No matching XACML policy found");
                }
                return null;
            }
            case 1: {
                return (AbstractPolicy)list.get(0);
            }
        }
        return new PolicySet(this.parentId, this.combiningAlg, null, list);
    }

    @Override
    public AbstractPolicy getPolicy(URI policyId) {
        return this.policyCollection.get(policyId);
    }

    @Override
    public AbstractPolicy getPolicy(URI identifier, int type, VersionConstraints constraints) {
        AbstractPolicy policy = this.policyCollection.get(identifier);
        if (policy != null && (type == 0 ? policy instanceof Policy : policy instanceof PolicySet)) {
            return policy;
        }
        return null;
    }

    private synchronized boolean addPolicy(URI identifier, AbstractPolicy policy) {
        return this.policyCollection.put(identifier, policy) != null;
    }

    @Override
    public void setPolicyCombiningAlgorithm(PolicyCombiningAlgorithm algorithm) {
        this.combiningAlg = algorithm;
    }

    @Override
    public boolean deletePolicy(String policyId) {
        try {
            return this.policyCollection.remove(new URI(policyId)) != null;
        }
        catch (URISyntaxException ex) {
            return false;
        }
    }

    @Override
    public LinkedHashMap getPolicyMap() {
        return this.policyCollection;
    }

    @Override
    public void setPolicyMap(LinkedHashMap policyMap) {
        this.policyCollection = policyMap;
    }
}

