/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.entitlement.policy.collection;

import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.balana.AbstractPolicy;
import org.wso2.balana.AbstractTarget;
import org.wso2.balana.MatchResult;
import org.wso2.balana.Policy;
import org.wso2.balana.PolicySet;
import org.wso2.balana.VersionConstraints;
import org.wso2.balana.combine.PolicyCombiningAlgorithm;
import org.wso2.balana.ctx.EvaluationCtx;
import org.wso2.balana.ctx.Status;
import org.wso2.balana.xacml2.Target;
import org.wso2.balana.xacml2.TargetSection;
import org.wso2.carbon.identity.entitlement.EntitlementException;
import org.wso2.carbon.identity.entitlement.EntitlementLRUCache;
import org.wso2.carbon.identity.entitlement.policy.collection.PolicyCollection;

public class DefaultPolicyCollection
implements PolicyCollection {
    private static final AbstractTarget target;
    private static Log log;
    private LinkedHashMap<String, TreeSet<AbstractPolicy>> policies;
    private VersionComparator versionComparator = new VersionComparator();
    private PolicyCombiningAlgorithm combiningAlg;
    private URI parentId;
    private int maxInMemoryPolicies;

    public DefaultPolicyCollection(PolicyCombiningAlgorithm combiningAlg, int maxInMemoryPolicies) {
        this.policies = new EntitlementLRUCache<String, TreeSet<AbstractPolicy>>(maxInMemoryPolicies);
        this.maxInMemoryPolicies = maxInMemoryPolicies;
        this.combiningAlg = combiningAlg;
    }

    public DefaultPolicyCollection(PolicyCombiningAlgorithm combiningAlg) {
        this.policies = new LinkedHashMap();
        this.combiningAlg = combiningAlg;
    }

    public DefaultPolicyCollection(PolicyCombiningAlgorithm combiningAlg, URI parentPolicyId) {
        this.policies = new LinkedHashMap();
        this.combiningAlg = combiningAlg;
        this.parentId = parentPolicyId;
    }

    @Override
    public void init(Properties properties) throws Exception {
        String parentIdProperty = properties.getProperty("parentId");
        if (parentIdProperty != null) {
            this.parentId = new URI(parentIdProperty);
        }
    }

    @Override
    public boolean addPolicy(AbstractPolicy policy) {
        return this.addPolicy(policy, policy.getId().toString());
    }

    public boolean addPolicy(AbstractPolicy policy, String identifier) {
        if (this.policies.containsKey(identifier)) {
            TreeSet<AbstractPolicy> set = this.policies.get(identifier);
            return set.add(policy);
        }
        TreeSet<AbstractPolicy> set = new TreeSet<AbstractPolicy>(this.versionComparator);
        this.policies.put(identifier, set);
        return set.add(policy);
    }

    @Override
    public AbstractPolicy getEffectivePolicy(EvaluationCtx context) throws EntitlementException {
        ArrayList<AbstractPolicy> list = new ArrayList<AbstractPolicy>();
        Iterator<TreeSet<AbstractPolicy>> it = this.policies.values().iterator();
        while (it.hasNext()) {
            AbstractPolicy policy = it.next().first();
            MatchResult match = policy.match(context);
            int result = match.getResult();
            if (result == 2) {
                log.error((Object)match.getStatus().getMessage());
                throw new EntitlementException(match.getStatus().getMessage());
            }
            if (result != 0) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Matching XACML policy found " + policy.getId().toString()));
            }
            if (this.combiningAlg == null && list.size() > 0) {
                ArrayList<String> code = new ArrayList<String>();
                code.add("urn:oasis:names:tc:xacml:1.0:status:processing-error");
                Status status = new Status(code, "too many applicable top-level policies");
            }
            list.add(policy);
        }
        switch (list.size()) {
            case 0: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"No matching XACML policy found");
                }
                return null;
            }
            case 1: {
                return (AbstractPolicy)list.get(0);
            }
        }
        return new PolicySet(this.parentId, this.combiningAlg, null, list);
    }

    @Override
    public AbstractPolicy getPolicy(URI policyId) {
        if (this.policies.containsKey(policyId.toString())) {
            return this.policies.get(policyId.toString()).first();
        }
        return null;
    }

    public AbstractPolicy getPolicy(String policyId) {
        if (this.policies.containsKey(policyId)) {
            return this.policies.get(policyId).first();
        }
        return null;
    }

    public LinkedHashMap<String, TreeSet<AbstractPolicy>> getPolicies() {
        return this.policies;
    }

    public AbstractPolicy getEffectivePolicy(ArrayList<AbstractPolicy> policies) throws EntitlementException {
        if (this.combiningAlg == null && policies.size() > 0) {
            log.error((Object)"Too many applicable top-level policies");
            throw new EntitlementException("Too many applicable top-level policies");
        }
        switch (policies.size()) {
            case 0: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"No matching XACML policy found");
                }
                return null;
            }
            case 1: {
                return policies.get(0);
            }
        }
        return new PolicySet(this.parentId, this.combiningAlg, target, policies);
    }

    @Override
    public AbstractPolicy getPolicy(URI identifier, int type, VersionConstraints constraints) {
        TreeSet<AbstractPolicy> set = this.policies.get(identifier.toString());
        if (set == null) {
            return null;
        }
        for (AbstractPolicy policy : set) {
            if (!constraints.meetsConstraint(policy.getVersion()) || !(type == 0 ? policy instanceof Policy : policy instanceof PolicySet)) continue;
            return policy;
        }
        return null;
    }

    @Override
    public void setPolicyCombiningAlgorithm(PolicyCombiningAlgorithm algorithm) {
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + (null == this.policies ? 0 : this.policies.hashCode());
        hash = 31 * hash + (null == this.combiningAlg ? 0 : this.combiningAlg.hashCode());
        return hash;
    }

    @Override
    public boolean deletePolicy(String policyId) {
        return false;
    }

    @Override
    public LinkedHashMap getPolicyMap() {
        return this.policies;
    }

    @Override
    public void setPolicyMap(LinkedHashMap policyMap) {
        this.policies = policyMap;
    }

    static {
        log = LogFactory.getLog(DefaultPolicyCollection.class);
        target = new Target(new TargetSection(null, 0, 2), new TargetSection(null, 1, 2), new TargetSection(null, 2, 2), new TargetSection(null, 3, 2));
    }

    static class VersionComparator
    implements Serializable,
    Comparator<AbstractPolicy> {
        private static final long serialVersionUID = 1136846256293162005L;

        VersionComparator() {
        }

        @Override
        public int compare(AbstractPolicy o1, AbstractPolicy o2) {
            String v2;
            String v1 = o2.getVersion();
            if (v1.equals(v2 = o1.getVersion())) {
                return 0;
            }
            StringTokenizer tok1 = new StringTokenizer(v1, ".");
            StringTokenizer tok2 = new StringTokenizer(v2, ".");
            while (tok1.hasMoreTokens()) {
                int num2;
                if (!tok2.hasMoreTokens()) {
                    return 1;
                }
                int num1 = Integer.parseInt(tok1.nextToken());
                if (num1 > (num2 = Integer.parseInt(tok2.nextToken()))) {
                    return 1;
                }
                if (num1 >= num2) continue;
                return -1;
            }
            if (tok2.hasMoreTokens()) {
                return -1;
            }
            return 0;
        }
    }
}

