/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.entitlement.policy;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.entitlement.EntitlementException;
import org.xml.sax.SAXException;

public class PolicyRequestBuilder {
    private static Log log = LogFactory.getLog(PolicyRequestBuilder.class);

    public Element getXacmlRequest(String request) throws EntitlementException {
        Document doc;
        ByteArrayInputStream inputStream = new ByteArrayInputStream(request.getBytes());
        DocumentBuilderFactory documentBuilderFactory = IdentityUtil.getSecuredDocumentBuilderFactory();
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            doc = documentBuilder.parse(inputStream);
        }
        catch (SAXException e) {
            throw new EntitlementException("Error while creating DOM from XACML request");
        }
        catch (IOException e) {
            throw new EntitlementException("Error while creating DOM from XACML request");
        }
        catch (ParserConfigurationException e) {
            throw new EntitlementException("Error while creating DOM from XACML request");
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                log.error((Object)"Error in closing input stream of XACML request");
            }
        }
        return doc.getDocumentElement();
    }
}

