/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.entitlement.policy;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;
import org.wso2.carbon.identity.entitlement.EntitlementException;
import org.wso2.carbon.identity.entitlement.EntitlementUtil;
import org.wso2.carbon.identity.entitlement.dto.AttributeDTO;

public class PolicyAttributeBuilder {
    private String policy;
    private int version;

    public PolicyAttributeBuilder() {
    }

    public PolicyAttributeBuilder(String policy) {
        this.policy = policy;
        String version = EntitlementUtil.getPolicyVersion(policy);
        this.version = "urn:oasis:names:tc:xacml:1.0:policy".equals(version) ? 0 : ("urn:oasis:names:tc:xacml:2.0:policy:schema:os".equals(version) ? 2 : 3);
    }

    public Properties getPolicyMetaDataFromPolicy() throws EntitlementException {
        List<AttributeDTO> attributeDTOs = new ArrayList<AttributeDTO>();
        try {
            attributeDTOs = this.createPolicyMetaData(this.policy, attributeDTOs);
        }
        catch (EntitlementException e) {
            throw new EntitlementException("Can not create Policy MetaData for given policy");
        }
        int attributeElementNo = 0;
        Properties properties = new Properties();
        if (attributeDTOs != null) {
            for (AttributeDTO attributeDTO : attributeDTOs) {
                properties.setProperty("policyMetaData" + attributeElementNo, attributeDTO.getCategory() + "," + attributeDTO.getAttributeValue() + "," + attributeDTO.getAttributeId() + "," + attributeDTO.getAttributeDataType());
                ++attributeElementNo;
            }
        }
        return properties;
    }

    public AttributeDTO[] getPolicyMetaDataFromRegistryProperties(Properties properties) {
        ArrayList<AttributeDTO> attributeDTOs = new ArrayList<AttributeDTO>();
        if (properties != null && !properties.isEmpty()) {
            for (int attributeElementNo = 0; attributeElementNo < properties.size(); ++attributeElementNo) {
                String[] attributeData;
                ArrayList attributeList = (ArrayList)properties.get("policyMetaData" + attributeElementNo);
                if (attributeList == null || attributeList.get(0) == null || (attributeData = attributeList.get(0).toString().split(",")).length != 4) continue;
                AttributeDTO attributeDTO = new AttributeDTO();
                attributeDTO.setCategory(attributeData[0]);
                attributeDTO.setAttributeValue(attributeData[1]);
                attributeDTO.setAttributeId(attributeData[2]);
                attributeDTO.setAttributeDataType(attributeData[3]);
                attributeDTOs.add(attributeDTO);
            }
        }
        return attributeDTOs.toArray(new AttributeDTO[attributeDTOs.size()]);
    }

    public List<AttributeDTO> createPolicyMetaData(String policy, List<AttributeDTO> attributeDTOs) throws EntitlementException {
        OMElement omElement;
        try {
            omElement = AXIOMUtil.stringToOM((String)policy);
        }
        catch (XMLStreamException e) {
            throw new EntitlementException("Policy xml can not be converted to OMElement");
        }
        if (omElement != null) {
            Iterator iterator1 = omElement.getChildrenWithLocalName("Target");
            while (iterator1.hasNext()) {
                OMElement targetElement = (OMElement)iterator1.next();
                if (this.version == 3) {
                    this.createMetaDataFromXACML3TargetElement(targetElement, attributeDTOs);
                    continue;
                }
                this.createMetaDataFromTargetElement(targetElement, attributeDTOs);
            }
            Iterator iterator2 = omElement.getChildrenWithLocalName("Rule");
            while (iterator2.hasNext()) {
                OMElement targetElement = (OMElement)iterator2.next();
                this.createMetaDataFromRuleElement(targetElement, attributeDTOs);
            }
            Iterator iterator3 = omElement.getChildrenWithLocalName("Policy");
            while (iterator3.hasNext()) {
                OMElement targetElement = (OMElement)iterator3.next();
                this.createPolicyMetaData(targetElement.toString(), attributeDTOs);
            }
        }
        return attributeDTOs;
    }

    public List<AttributeDTO> createMetaDataFromTargetElement(OMElement omElement, List<AttributeDTO> attributeDTOs) {
        if (omElement != null) {
            Iterator iterator1 = omElement.getChildrenWithLocalName("Resources");
            while (iterator1.hasNext()) {
                OMElement resourceElements = (OMElement)iterator1.next();
                Iterator iterator2 = resourceElements.getChildrenWithLocalName("Resource");
                while (iterator2.hasNext()) {
                    OMElement resourceElement = (OMElement)iterator2.next();
                    Iterator iterator3 = resourceElement.getChildrenWithLocalName("ResourceMatch");
                    while (iterator3.hasNext()) {
                        OMElement resourceMatch = (OMElement)iterator3.next();
                        List<AttributeDTO> attributeDTOList = this.createMetaDataFromMatchElement(resourceMatch, "Resource");
                        for (AttributeDTO attributeDTO : attributeDTOList) {
                            attributeDTOs.add(attributeDTO);
                        }
                    }
                }
            }
            Iterator iterator4 = omElement.getChildrenWithLocalName("Subjects");
            while (iterator4.hasNext()) {
                OMElement resourceElements = (OMElement)iterator4.next();
                Iterator iterator2 = resourceElements.getChildrenWithLocalName("Subject");
                while (iterator2.hasNext()) {
                    OMElement resourceElement = (OMElement)iterator2.next();
                    Iterator iterator3 = resourceElement.getChildrenWithLocalName("SubjectMatch");
                    while (iterator3.hasNext()) {
                        OMElement resourceMatch = (OMElement)iterator3.next();
                        List<AttributeDTO> attributeDTOList = this.createMetaDataFromMatchElement(resourceMatch, "Subject");
                        for (AttributeDTO attributeDTO : attributeDTOList) {
                            attributeDTOs.add(attributeDTO);
                        }
                    }
                }
            }
            Iterator iterator5 = omElement.getChildrenWithLocalName("Actions");
            while (iterator5.hasNext()) {
                OMElement resourceElements = (OMElement)iterator5.next();
                Iterator iterator2 = resourceElements.getChildrenWithLocalName("Action");
                while (iterator2.hasNext()) {
                    OMElement resourceElement = (OMElement)iterator2.next();
                    Iterator iterator3 = resourceElement.getChildrenWithLocalName("ActionMatch");
                    while (iterator3.hasNext()) {
                        OMElement resourceMatch = (OMElement)iterator3.next();
                        List<AttributeDTO> list = this.createMetaDataFromMatchElement(resourceMatch, "Action");
                        for (AttributeDTO attributeDTO : list) {
                            attributeDTOs.add(attributeDTO);
                        }
                    }
                }
            }
            Iterator iterator6 = omElement.getChildrenWithLocalName("Environments");
            while (iterator6.hasNext()) {
                OMElement resourceElements = (OMElement)iterator6.next();
                Iterator iterator2 = resourceElements.getChildrenWithLocalName("Environment");
                while (iterator2.hasNext()) {
                    OMElement resourceElement = (OMElement)iterator2.next();
                    Iterator iterator3 = resourceElement.getChildrenWithLocalName("EnvironmentMatch");
                    while (iterator3.hasNext()) {
                        OMElement oMElement = (OMElement)iterator3.next();
                        List<AttributeDTO> list = this.createMetaDataFromMatchElement(oMElement, "Environment");
                        for (AttributeDTO attributeDTO : list) {
                            attributeDTOs.add(attributeDTO);
                        }
                    }
                }
            }
        }
        return attributeDTOs;
    }

    public List<AttributeDTO> createMetaDataFromXACML3TargetElement(OMElement omElement, List<AttributeDTO> attributeDTOs) {
        if (omElement != null) {
            Iterator iterator1 = omElement.getChildrenWithLocalName("AnyOf");
            while (iterator1.hasNext()) {
                OMElement anyOff = (OMElement)iterator1.next();
                Iterator iterator2 = anyOff.getChildrenWithLocalName("AllOf");
                while (iterator2.hasNext()) {
                    OMElement allOf = (OMElement)iterator2.next();
                    Iterator iterator3 = allOf.getChildrenWithLocalName("Match");
                    while (iterator3.hasNext()) {
                        OMElement resourceMatch = (OMElement)iterator3.next();
                        List<AttributeDTO> attributeDTOList = this.createMetaDataFromXACML3MatchElement(resourceMatch);
                        for (AttributeDTO attributeDTO : attributeDTOList) {
                            attributeDTOs.add(attributeDTO);
                        }
                    }
                }
            }
        }
        return attributeDTOs;
    }

    public List<AttributeDTO> createMetaDataFromMatchElement(OMElement omElement, String subElementName) {
        ArrayList<AttributeDTO> attributeDTOs = new ArrayList<AttributeDTO>();
        String attributeId = null;
        String dataType = null;
        if (omElement != null) {
            Iterator iterator1 = omElement.getChildrenWithLocalName(subElementName + "AttributeDesignator");
            while (iterator1.hasNext()) {
                OMElement attributeDesignator = (OMElement)iterator1.next();
                if (attributeDesignator == null) continue;
                attributeId = attributeDesignator.getAttributeValue(new QName("AttributeId"));
                dataType = attributeDesignator.getAttributeValue(new QName("DataType"));
            }
            Iterator iterator2 = omElement.getChildrenWithLocalName("AttributeSelector");
            while (iterator2.hasNext()) {
                OMElement attributeDesignator = (OMElement)iterator2.next();
                if (attributeDesignator == null) continue;
                attributeId = attributeDesignator.getAttributeValue(new QName("RequestContextPath"));
                dataType = attributeDesignator.getAttributeValue(new QName("DataType"));
            }
            Iterator iterator3 = omElement.getChildrenWithLocalName("AttributeValue");
            while (iterator3.hasNext()) {
                OMElement attributeElement = (OMElement)iterator3.next();
                if (attributeElement == null) continue;
                AttributeDTO attributeDTO = new AttributeDTO();
                attributeDTO.setAttributeValue(attributeElement.getText());
                attributeDTO.setAttributeId(attributeId);
                attributeDTO.setAttributeDataType(dataType);
                attributeDTO.setCategory(subElementName);
                attributeDTOs.add(attributeDTO);
            }
        }
        return attributeDTOs;
    }

    public List<AttributeDTO> createMetaDataFromXACML3MatchElement(OMElement omElement) {
        ArrayList<AttributeDTO> attributeDTOs = new ArrayList<AttributeDTO>();
        String attributeId = null;
        String category = null;
        if (omElement != null) {
            Iterator iterator1 = omElement.getChildrenWithLocalName("AttributeDesignator");
            while (iterator1.hasNext()) {
                OMElement attributeDesignator = (OMElement)iterator1.next();
                if (attributeDesignator == null) continue;
                attributeId = attributeDesignator.getAttributeValue(new QName("AttributeId"));
                category = attributeDesignator.getAttributeValue(new QName("Category"));
            }
            Iterator iterator3 = omElement.getChildrenWithLocalName("AttributeValue");
            while (iterator3.hasNext()) {
                OMElement attributeElement = (OMElement)iterator3.next();
                if (attributeElement == null) continue;
                String dataType = attributeElement.getAttributeValue(new QName("DataType"));
                AttributeDTO attributeDTO = new AttributeDTO();
                attributeDTO.setAttributeValue(attributeElement.getText());
                attributeDTO.setAttributeId(attributeId);
                attributeDTO.setAttributeDataType(dataType);
                attributeDTO.setCategory(category);
                attributeDTOs.add(attributeDTO);
            }
        }
        return attributeDTOs;
    }

    public List<AttributeDTO> createMetaDataFromApplyElement(OMElement omElement, List<AttributeDTO> attributeDTOs) {
        if (omElement != null) {
            Object attributeDTO;
            AttributeDTO attributeDTO2;
            List<String> attributeValues;
            Object attributeDTO3;
            Object attributeDTO4;
            Iterator iterator1 = omElement.getChildrenWithLocalName("ResourceAttributeDesignator");
            while (iterator1.hasNext()) {
                Object attributeDTO5;
                OMElement attributeDesignator = (OMElement)iterator1.next();
                if (attributeDesignator == null) continue;
                String attributeId = attributeDesignator.getAttributeValue(new QName("AttributeId"));
                String dataType = attributeDesignator.getAttributeValue(new QName("DataType"));
                List<String> attributeValues2 = this.searchAttributeValues(omElement, new ArrayList<String>(), true);
                if (attributeValues2 == null) {
                    attributeDTO5 = new AttributeDTO();
                    ((AttributeDTO)attributeDTO5).setCategory("UNKNOWN");
                    ((AttributeDTO)attributeDTO5).setAttributeValue("Attribute values are not defined directly for Resource Designator Element ");
                    attributeDTOs.add((AttributeDTO)attributeDTO5);
                    continue;
                }
                if (attributeValues2.isEmpty()) {
                    attributeDTO5 = new AttributeDTO();
                    ((AttributeDTO)attributeDTO5).setCategory("UNKNOWN");
                    ((AttributeDTO)attributeDTO5).setAttributeValue("No Attributes are defined for Resource Designator Element ");
                    continue;
                }
                for (String value : attributeValues2) {
                    attributeDTO4 = new AttributeDTO();
                    ((AttributeDTO)attributeDTO4).setAttributeValue(value);
                    ((AttributeDTO)attributeDTO4).setAttributeDataType(dataType);
                    ((AttributeDTO)attributeDTO4).setCategory("Resource");
                    ((AttributeDTO)attributeDTO4).setAttributeId(attributeId);
                    attributeDTOs.add((AttributeDTO)attributeDTO4);
                }
            }
            Iterator iterator2 = omElement.getChildrenWithLocalName("SubjectAttributeDesignator");
            while (iterator2.hasNext()) {
                Object attributeDTO6;
                OMElement attributeDesignator = (OMElement)iterator2.next();
                if (attributeDesignator == null) continue;
                String attributeId = attributeDesignator.getAttributeValue(new QName("AttributeId"));
                String dataType = attributeDesignator.getAttributeValue(new QName("DataType"));
                List<String> attributeValues3 = this.searchAttributeValues(omElement, new ArrayList<String>(), true);
                if (attributeValues3 == null) {
                    attributeDTO6 = new AttributeDTO();
                    ((AttributeDTO)attributeDTO6).setCategory("UNKNOWN");
                    ((AttributeDTO)attributeDTO6).setAttributeValue("Attribute values are not defined directly for Resource Designator Element ");
                    attributeDTOs.add((AttributeDTO)attributeDTO6);
                    continue;
                }
                if (attributeValues3.isEmpty()) {
                    attributeDTO6 = new AttributeDTO();
                    ((AttributeDTO)attributeDTO6).setCategory("UNKNOWN");
                    ((AttributeDTO)attributeDTO6).setAttributeValue("No Attributes are defined for Resource Designator Element ");
                    continue;
                }
                for (String value : attributeValues3) {
                    attributeDTO3 = new AttributeDTO();
                    ((AttributeDTO)attributeDTO3).setAttributeValue(value);
                    ((AttributeDTO)attributeDTO3).setAttributeDataType(dataType);
                    ((AttributeDTO)attributeDTO3).setCategory("Subject");
                    ((AttributeDTO)attributeDTO3).setAttributeId(attributeId);
                    attributeDTOs.add((AttributeDTO)attributeDTO3);
                }
            }
            Iterator iterator3 = omElement.getChildrenWithLocalName("ActionAttributeDesignator");
            while (iterator3.hasNext()) {
                OMElement attributeDesignator = (OMElement)iterator3.next();
                if (attributeDesignator == null) continue;
                String attributeId = attributeDesignator.getAttributeValue(new QName("AttributeId"));
                String dataType = attributeDesignator.getAttributeValue(new QName("DataType"));
                attributeValues = this.searchAttributeValues(omElement, new ArrayList<String>(), true);
                if (attributeValues == null) {
                    attributeDTO4 = new AttributeDTO();
                    ((AttributeDTO)attributeDTO4).setCategory("UNKNOWN");
                    ((AttributeDTO)attributeDTO4).setAttributeValue("Attribute values are not defined directly for Resource Designator Element ");
                    attributeDTOs.add((AttributeDTO)attributeDTO4);
                    continue;
                }
                if (attributeValues.isEmpty()) {
                    attributeDTO4 = new AttributeDTO();
                    ((AttributeDTO)attributeDTO4).setCategory("UNKNOWN");
                    ((AttributeDTO)attributeDTO4).setAttributeValue("No Attributes are defined for Resource Designator Element ");
                    continue;
                }
                for (String value : attributeValues) {
                    attributeDTO2 = new AttributeDTO();
                    attributeDTO2.setAttributeValue(value);
                    attributeDTO2.setAttributeDataType(dataType);
                    attributeDTO2.setCategory("Action");
                    attributeDTO2.setAttributeId(attributeId);
                    attributeDTOs.add(attributeDTO2);
                }
            }
            Iterator iterator4 = omElement.getChildrenWithLocalName("EnvironmentAttributeDesignator");
            while (iterator4.hasNext()) {
                OMElement attributeDesignator = (OMElement)iterator4.next();
                if (attributeDesignator == null) continue;
                String attributeId = attributeDesignator.getAttributeValue(new QName("AttributeId"));
                String dataType = attributeDesignator.getAttributeValue(new QName("DataType"));
                List<String> attributeValues4 = this.searchAttributeValues(omElement, new ArrayList<String>(), true);
                if (attributeValues4 == null) {
                    attributeDTO3 = new AttributeDTO();
                    ((AttributeDTO)attributeDTO3).setCategory("UNKNOWN");
                    ((AttributeDTO)attributeDTO3).setAttributeValue("Attribute values are not defined directly for Resource Designator Element ");
                    attributeDTOs.add((AttributeDTO)attributeDTO3);
                    continue;
                }
                if (attributeValues4.isEmpty()) {
                    attributeDTO3 = new AttributeDTO();
                    ((AttributeDTO)attributeDTO3).setCategory("UNKNOWN");
                    ((AttributeDTO)attributeDTO3).setAttributeValue("No Attributes are defined for Resource Designator Element ");
                    continue;
                }
                for (String value : attributeValues4) {
                    attributeDTO = new AttributeDTO();
                    ((AttributeDTO)attributeDTO).setAttributeValue(value);
                    ((AttributeDTO)attributeDTO).setAttributeDataType(dataType);
                    ((AttributeDTO)attributeDTO).setCategory("Environment");
                    ((AttributeDTO)attributeDTO).setAttributeId(attributeId);
                    attributeDTOs.add((AttributeDTO)attributeDTO);
                }
            }
            Iterator iterator5 = omElement.getChildrenWithLocalName("AttributeSelector");
            while (iterator5.hasNext()) {
                String attributeId;
                OMElement attributeSelector = (OMElement)iterator5.next();
                if (attributeSelector == null) continue;
                String subElementName = attributeId = attributeSelector.getAttributeValue(new QName("RequestContextPath"));
                String dataType = attributeSelector.getAttributeValue(new QName("DataType"));
                List<String> attributeValues5 = this.searchAttributeValues(omElement, new ArrayList<String>(), true);
                if (attributeValues5 == null) {
                    attributeDTO = new AttributeDTO();
                    ((AttributeDTO)attributeDTO).setCategory("UNKNOWN");
                    ((AttributeDTO)attributeDTO).setAttributeValue("Attribute Selector Element is contained with Xpath expression");
                    attributeDTOs.add((AttributeDTO)attributeDTO);
                    continue;
                }
                if (attributeValues5.isEmpty()) {
                    attributeDTO = new AttributeDTO();
                    ((AttributeDTO)attributeDTO).setCategory("UNKNOWN");
                    ((AttributeDTO)attributeDTO).setAttributeValue("Attribute Selector Element is contained with Xpath expression");
                    continue;
                }
                for (String value : attributeValues5) {
                    AttributeDTO attributeDTO7 = new AttributeDTO();
                    attributeDTO7.setAttributeValue(value);
                    attributeDTO7.setAttributeDataType(dataType);
                    attributeDTO7.setCategory(subElementName);
                    attributeDTO7.setAttributeId(attributeId);
                    attributeDTOs.add(attributeDTO7);
                    attributeDTO7.setCategory("UNKNOWN");
                    attributeDTO7.setAttributeValue("Attribute Selector Element is contained with Xpath expression");
                }
            }
            Iterator iterator6 = omElement.getChildrenWithLocalName("AttributeValue");
            if (iterator6.hasNext()) {
                attributeValues = this.searchAttributeValues(omElement, new ArrayList<String>(), false);
                if (attributeValues == null) {
                    attributeDTO4 = new AttributeDTO();
                    ((AttributeDTO)attributeDTO4).setCategory("UNKNOWN");
                    ((AttributeDTO)attributeDTO4).setAttributeValue("Attribute values are not defined directly for Resource Designator Element ");
                    attributeDTOs.add((AttributeDTO)attributeDTO4);
                } else if (attributeValues.isEmpty()) {
                    attributeDTO4 = new AttributeDTO();
                    ((AttributeDTO)attributeDTO4).setCategory("UNKNOWN");
                    ((AttributeDTO)attributeDTO4).setAttributeValue("No Attributes are defined for Resource Designator Element ");
                } else {
                    for (String values : attributeValues) {
                        attributeDTO2 = new AttributeDTO();
                        attributeDTO2.setAttributeValue(values);
                        Iterator iterator8 = omElement.getChildrenWithLocalName("Apply");
                        while (iterator8.hasNext()) {
                            OMElement applyElement = (OMElement)iterator8.next();
                            if (this.version == 3) {
                                this.searchXACML3Designator(applyElement, attributeDTO2);
                                continue;
                            }
                            this.searchDesignatorOrSelector(applyElement, attributeDTO2);
                        }
                        if (attributeDTO2.getCategory() == null && !"".equals(attributeDTO2.getCategory())) continue;
                        attributeDTOs.add(attributeDTO2);
                    }
                }
            }
            Iterator iterator7 = omElement.getChildrenWithLocalName("Apply");
            while (iterator7.hasNext()) {
                OMElement applyElement = (OMElement)iterator7.next();
                this.createMetaDataFromApplyElement(applyElement, attributeDTOs);
            }
        }
        return attributeDTOs;
    }

    public List<AttributeDTO> createMetaDataFromXACML3ApplyElement(OMElement omElement, List<AttributeDTO> attributeDTOs) {
        if (omElement != null) {
            Iterator iterator1 = omElement.getChildrenWithLocalName("AttributeDesignator");
            while (iterator1.hasNext()) {
                Object attributeDTO;
                OMElement attributeDesignator = (OMElement)iterator1.next();
                if (attributeDesignator == null) continue;
                String attributeId = attributeDesignator.getAttributeValue(new QName("AttributeId"));
                String category = attributeDesignator.getAttributeValue(new QName("Category"));
                String dataType = attributeDesignator.getAttributeValue(new QName("DataType"));
                List<String> attributeValues = this.searchAttributeValues(omElement, new ArrayList<String>(), true);
                if (attributeValues == null) {
                    attributeDTO = new AttributeDTO();
                    ((AttributeDTO)attributeDTO).setCategory("UNKNOWN");
                    ((AttributeDTO)attributeDTO).setAttributeValue("Attribute values are not defined directly for Resource Designator Element ");
                    attributeDTOs.add((AttributeDTO)attributeDTO);
                    continue;
                }
                if (attributeValues.isEmpty()) {
                    attributeDTO = new AttributeDTO();
                    ((AttributeDTO)attributeDTO).setCategory("UNKNOWN");
                    ((AttributeDTO)attributeDTO).setAttributeValue("No Attributes are defined for Resource Designator Element ");
                    continue;
                }
                for (String value : attributeValues) {
                    AttributeDTO attributeDTO2 = new AttributeDTO();
                    attributeDTO2.setAttributeValue(value);
                    attributeDTO2.setAttributeDataType(dataType);
                    attributeDTO2.setCategory(category);
                    attributeDTO2.setAttributeId(attributeId);
                    attributeDTOs.add(attributeDTO2);
                }
            }
            Iterator iterator2 = omElement.getChildrenWithLocalName("AttributeValue");
            if (iterator2.hasNext()) {
                Object attributeDTO;
                List<String> attributeValues = this.searchAttributeValues(omElement, new ArrayList<String>(), false);
                if (attributeValues == null) {
                    attributeDTO = new AttributeDTO();
                    ((AttributeDTO)attributeDTO).setCategory("UNKNOWN");
                    ((AttributeDTO)attributeDTO).setAttributeValue("Attribute values are not defined directly for Resource Designator Element ");
                    attributeDTOs.add((AttributeDTO)attributeDTO);
                } else if (attributeValues.isEmpty()) {
                    attributeDTO = new AttributeDTO();
                    ((AttributeDTO)attributeDTO).setCategory("UNKNOWN");
                    ((AttributeDTO)attributeDTO).setAttributeValue("No Attributes are defined for Resource Designator Element ");
                } else {
                    for (String values : attributeValues) {
                        AttributeDTO attributeDTO3 = new AttributeDTO();
                        attributeDTO3.setAttributeValue(values);
                        Iterator iterator8 = omElement.getChildrenWithLocalName("Apply");
                        while (iterator8.hasNext()) {
                            OMElement applyElement = (OMElement)iterator8.next();
                            this.searchXACML3Designator(applyElement, attributeDTO3);
                        }
                        if (attributeDTO3.getCategory() == null && !"".equals(attributeDTO3.getCategory())) continue;
                        attributeDTOs.add(attributeDTO3);
                    }
                }
            }
            Iterator iterator7 = omElement.getChildrenWithLocalName("Apply");
            while (iterator7.hasNext()) {
                OMElement applyElement = (OMElement)iterator7.next();
                this.createMetaDataFromXACML3ApplyElement(applyElement, attributeDTOs);
            }
        }
        return attributeDTOs;
    }

    public List<String> searchAttributeValues(OMElement omElement, List<String> values, boolean searchDesignators) {
        if (values != null) {
            Iterator iterator = omElement.getChildrenWithLocalName("AttributeValue");
            while (iterator.hasNext()) {
                OMElement attributeElement = (OMElement)iterator.next();
                if (attributeElement == null) continue;
                String dataType = attributeElement.getAttributeValue(new QName("DataType"));
                values.add(attributeElement.getText());
            }
        }
        Iterator iterator1 = omElement.getChildrenWithLocalName("Apply");
        while (iterator1.hasNext()) {
            OMElement applyElement = (OMElement)iterator1.next();
            this.searchAttributeValues(applyElement, values, searchDesignators);
            AttributeDTO attributeDTO = new AttributeDTO();
            if (searchDesignators) {
                if (this.version == 3) {
                    this.searchXACML3Designator(applyElement, attributeDTO);
                } else {
                    this.searchDesignatorOrSelector(applyElement, attributeDTO);
                }
            }
            if (attributeDTO.getCategory() == null && attributeDTO.getAttributeId() == null && attributeDTO.getAttributeDataType() == null) continue;
            values = null;
        }
        return values;
    }

    public AttributeDTO searchDesignatorOrSelector(OMElement omElement, AttributeDTO attributeDTO) {
        Iterator iterator1 = omElement.getChildrenWithLocalName("ResourceAttributeDesignator");
        while (iterator1.hasNext()) {
            OMElement attributeDesignator = (OMElement)iterator1.next();
            if (attributeDesignator == null) continue;
            String attributeId = attributeDesignator.getAttributeValue(new QName("AttributeId"));
            String dataType = attributeDesignator.getAttributeValue(new QName("DataType"));
            attributeDTO.setAttributeDataType(dataType);
            attributeDTO.setCategory("Resource");
            attributeDTO.setAttributeId(attributeId);
        }
        Iterator iterator2 = omElement.getChildrenWithLocalName("SubjectAttributeDesignator");
        while (iterator2.hasNext()) {
            OMElement attributeDesignator = (OMElement)iterator2.next();
            if (attributeDesignator == null) continue;
            String attributeId = attributeDesignator.getAttributeValue(new QName("AttributeId"));
            String dataType = attributeDesignator.getAttributeValue(new QName("DataType"));
            attributeDTO.setAttributeDataType(dataType);
            attributeDTO.setCategory("Subject");
            attributeDTO.setAttributeId(attributeId);
        }
        Iterator iterator3 = omElement.getChildrenWithLocalName("ActionAttributeDesignator");
        while (iterator3.hasNext()) {
            OMElement attributeDesignator = (OMElement)iterator3.next();
            if (attributeDesignator == null) continue;
            String attributeId = attributeDesignator.getAttributeValue(new QName("AttributeId"));
            String dataType = attributeDesignator.getAttributeValue(new QName("DataType"));
            attributeDTO.setAttributeDataType(dataType);
            attributeDTO.setCategory("Action");
            attributeDTO.setAttributeId(attributeId);
        }
        Iterator iterator4 = omElement.getChildrenWithLocalName("EnvironmentAttributeDesignator");
        while (iterator4.hasNext()) {
            OMElement attributeDesignator = (OMElement)iterator4.next();
            if (attributeDesignator == null) continue;
            String attributeId = attributeDesignator.getAttributeValue(new QName("AttributeId"));
            String dataType = attributeDesignator.getAttributeValue(new QName("DataType"));
            attributeDTO.setAttributeDataType(dataType);
            attributeDTO.setCategory("Environment");
            attributeDTO.setAttributeId(attributeId);
        }
        Iterator iterator5 = omElement.getChildrenWithLocalName("AttributeSelector");
        while (iterator5.hasNext()) {
            String attributeId;
            OMElement attributeDesignator = (OMElement)iterator5.next();
            if (attributeDesignator == null) continue;
            String subElementName = attributeId = attributeDesignator.getAttributeValue(new QName("RequestContextPath"));
            String dataType = attributeDesignator.getAttributeValue(new QName("DataType"));
            attributeDTO.setAttributeDataType(dataType);
            attributeDTO.setCategory("UNKNOWN");
            attributeDTO.setAttributeValue("Attribute Selector Element is contained with Xpath expression");
            attributeDTO.setAttributeId(attributeId);
        }
        return attributeDTO;
    }

    public AttributeDTO searchXACML3Designator(OMElement omElement, AttributeDTO attributeDTO) {
        Iterator iterator1 = omElement.getChildrenWithLocalName("AttributeDesignator");
        while (iterator1.hasNext()) {
            OMElement attributeDesignator = (OMElement)iterator1.next();
            if (attributeDesignator == null) continue;
            String attributeId = attributeDesignator.getAttributeValue(new QName("AttributeId"));
            String category = attributeDesignator.getAttributeValue(new QName("Category"));
            String dataType = attributeDesignator.getAttributeValue(new QName("DataType"));
            attributeDTO.setCategory(category);
            attributeDTO.setAttributeId(attributeId);
            attributeDTO.setAttributeDataType(dataType);
        }
        return attributeDTO;
    }

    public List<AttributeDTO> createMetaDataFromConditionElement(OMElement omElement, List<AttributeDTO> attributeDTOs) {
        Iterator iterator = omElement.getChildrenWithLocalName("Apply");
        if (iterator.hasNext()) {
            if (this.version == 3) {
                this.createMetaDataFromXACML3ApplyElement(omElement, attributeDTOs);
            } else {
                this.createMetaDataFromApplyElement(omElement, attributeDTOs);
            }
        } else {
            AttributeDTO attributeDTO = new AttributeDTO();
            attributeDTO.setCategory("UNKNOWN");
            attributeDTO.setAttributeValue("Apply Element is not contained within Condition Element");
        }
        return attributeDTOs;
    }

    public List<AttributeDTO> createMetaDataFromRuleElement(OMElement omElement, List<AttributeDTO> attributeDTOs) {
        if (omElement != null) {
            Iterator iterator1 = omElement.getChildrenWithLocalName("Target");
            while (iterator1.hasNext()) {
                OMElement targetElement = (OMElement)iterator1.next();
                if (this.version == 3) {
                    this.createMetaDataFromXACML3TargetElement(targetElement, attributeDTOs);
                    continue;
                }
                this.createMetaDataFromTargetElement(targetElement, attributeDTOs);
            }
            Iterator iterator2 = omElement.getChildrenWithLocalName("Condition");
            while (iterator2.hasNext()) {
                OMElement conditionElement = (OMElement)iterator2.next();
                this.createMetaDataFromConditionElement(conditionElement, attributeDTOs);
            }
        }
        return attributeDTOs;
    }
}

