/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.entitlement.pip;

import java.net.URI;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.balana.attr.AttributeValue;
import org.wso2.balana.attr.BagAttribute;
import org.wso2.balana.cond.EvaluationResult;
import org.wso2.balana.ctx.EvaluationCtx;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.identity.entitlement.pip.AbstractPIPAttributeFinder;
import org.wso2.carbon.user.api.ClaimManager;
import org.wso2.carbon.user.api.ClaimMapping;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class DefaultAttributeFinder
extends AbstractPIPAttributeFinder {
    private static final Log log = LogFactory.getLog(DefaultAttributeFinder.class);
    private Set<String> supportedAttrs = new HashSet<String>();
    private boolean mapFederatedUsersToLocal = false;
    private static final String MAP_FEDERATED_USERS_TO_LOCAL = "MapFederatedUsersToLocal";
    private static final String FEDERATED_USER_DOMAIN = "FEDERATED";

    @Override
    public void init(Properties properties) throws Exception {
        this.mapFederatedUsersToLocal = Boolean.parseBoolean(properties.getProperty(MAP_FEDERATED_USERS_TO_LOCAL));
        if (log.isDebugEnabled()) {
            log.debug((Object)"DefaultAttributeFinder is initialized successfully");
        }
    }

    @Override
    public String getModuleName() {
        return "Default Attribute Finder";
    }

    @Override
    public Set<String> getAttributeValues(URI attributeType, URI attributeId, URI category, String issuer, EvaluationCtx evaluationCtx) throws Exception {
        BagAttribute bagAttribute;
        Set<String> values = null;
        EvaluationResult userType = evaluationCtx.getAttribute(new URI("http://www.w3.org/2001/XMLSchema#string"), new URI("http://wso2.org/identity/user/user-type"), issuer, new URI("http://wso2.org/identity/user"));
        String userTypeId = null;
        if (userType != null && userType.getAttributeValue() != null && userType.getAttributeValue().isBag() && (bagAttribute = (BagAttribute)userType.getAttributeValue()).size() > 0) {
            userTypeId = ((AttributeValue)bagAttribute.iterator().next()).encode();
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("The user type of the user is %s", userTypeId));
            }
        }
        if (!StringUtils.equalsIgnoreCase(userTypeId, (String)FEDERATED_USER_DOMAIN)) {
            values = super.getAttributeValues(attributeType, attributeId, category, issuer, evaluationCtx);
        } else if (this.mapFederatedUsersToLocal) {
            values = super.getAttributeValues(attributeType, attributeId, category, issuer, evaluationCtx);
        }
        return values;
    }

    @Override
    public Set<String> getAttributeValues(String subjectId, String resourceId, String actionId, String environmentId, String attributeId, String issuer) throws Exception {
        HashSet<String> values = new HashSet<String>();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Retrieving attribute values of subjectId '" + subjectId + "'with attributeId '" + attributeId + "'"));
        }
        if (StringUtils.isEmpty((String)subjectId)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"subjectId value is null or empty. Returning empty attribute set");
            }
            return values;
        }
        subjectId = MultitenantUtils.getTenantAwareUsername((String)subjectId);
        if ("http://wso2.org/claims/role".equals(attributeId)) {
            String[] roles;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Looking for roles via DefaultAttributeFinder");
            }
            if ((roles = CarbonContext.getThreadLocalCarbonContext().getUserRealm().getUserStoreManager().getRoleListOfUser(subjectId)) != null && roles.length > 0) {
                for (String role : roles) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("User %1$s belongs to the Role %2$s", subjectId, role));
                    }
                    values.add(role);
                }
            }
        } else {
            String claimValue = null;
            try {
                claimValue = CarbonContext.getThreadLocalCarbonContext().getUserRealm().getUserStoreManager().getUserClaimValue(subjectId, attributeId, null);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Claim '" + claimValue + "' retrieved for attributeId '" + attributeId + "' for subjectId '" + subjectId + "'"));
                }
            }
            catch (UserStoreException e) {
                if (e.getMessage().startsWith("UserNotFound")) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("User: " + subjectId + " not found in user store"));
                    }
                }
                throw e;
            }
            if (claimValue == null && log.isDebugEnabled()) {
                log.debug((Object)String.format("Request attribute %1$s not found", attributeId));
            }
            if (claimValue != null) {
                String claimSeparator = CarbonContext.getThreadLocalCarbonContext().getUserRealm().getRealmConfiguration().getUserStoreProperty("MultiAttributeSeparator");
                if (StringUtils.isBlank((String)claimSeparator)) {
                    claimSeparator = ",,,";
                }
                if (claimValue.contains(claimSeparator)) {
                    StringTokenizer st = new StringTokenizer(claimValue, claimSeparator);
                    while (st.hasMoreElements()) {
                        String attributeValue = st.nextElement().toString();
                        if (!StringUtils.isNotBlank((String)attributeValue)) continue;
                        values.add(attributeValue);
                    }
                } else {
                    values.add(claimValue);
                }
            }
        }
        return values;
    }

    @Override
    public Set<String> getSupportedAttributes() {
        try {
            ClaimMapping[] claims;
            ClaimManager claimManager = CarbonContext.getThreadLocalCarbonContext().getUserRealm().getClaimManager();
            for (ClaimMapping claim : claims = claimManager.getAllClaimMappings("http://wso2.org/claims")) {
                this.supportedAttrs.add(claim.getClaim().getClaimUri());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.supportedAttrs;
    }
}

