/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.entitlement.pip;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.transform.TransformerException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.balana.ParsingException;
import org.wso2.balana.attr.AttributeValue;
import org.wso2.balana.attr.BagAttribute;
import org.wso2.balana.cond.EvaluationResult;
import org.wso2.balana.ctx.Attribute;
import org.wso2.balana.ctx.EvaluationCtx;
import org.wso2.balana.ctx.Status;
import org.wso2.balana.finder.AttributeFinderModule;
import org.wso2.balana.xacml3.Attributes;
import org.wso2.carbon.identity.entitlement.EntitlementUtil;
import org.wso2.carbon.identity.entitlement.cache.PIPAttributeCache;
import org.wso2.carbon.identity.entitlement.internal.EntitlementServiceComponent;
import org.wso2.carbon.identity.entitlement.pdp.EntitlementEngine;
import org.wso2.carbon.identity.entitlement.pip.PIPAttributeFinder;

public class CarbonAttributeFinder
extends AttributeFinderModule {
    private Map<String, List<PIPAttributeFinder>> attrFinders = new HashMap<String, List<PIPAttributeFinder>>();
    private static final Log log = LogFactory.getLog(CarbonAttributeFinder.class);
    private PIPAttributeCache attributeFinderCache = null;
    protected int tenantId;

    public CarbonAttributeFinder(int tenantId) {
        this.tenantId = tenantId;
    }

    public void init() {
        Map<PIPAttributeFinder, Properties> designators = EntitlementServiceComponent.getEntitlementConfig().getDesignators();
        Properties properties = EntitlementServiceComponent.getEntitlementConfig().getEngineProperties();
        if ("true".equals(properties.getProperty("PDP.AttributeCaching.Enable"))) {
            int attributeCachingInterval = -1;
            String cacheInterval = properties.getProperty("PDP.AttributeCaching.CachingInterval");
            if (cacheInterval != null) {
                try {
                    attributeCachingInterval = Integer.parseInt(cacheInterval.trim());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.attributeFinderCache = new PIPAttributeCache(attributeCachingInterval);
        }
        if (designators != null && !designators.isEmpty()) {
            Set<PIPAttributeFinder> pipAttributeFinders = designators.keySet();
            for (PIPAttributeFinder pipAttributeFinder : pipAttributeFinders) {
                Set<String> attrs = pipAttributeFinder.getSupportedAttributes();
                if (attrs == null) continue;
                for (String attr : attrs) {
                    List<Object> finders;
                    if (this.attrFinders.containsKey(attr)) {
                        finders = this.attrFinders.get(attr);
                        if (finders.contains(pipAttributeFinder)) continue;
                        finders.add(pipAttributeFinder);
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)String.format("PIP attribute handler %1$s registered for the supported attribute %2$s", pipAttributeFinder.getClass(), attr));
                        continue;
                    }
                    finders = new ArrayList<PIPAttributeFinder>();
                    finders.add(pipAttributeFinder);
                    this.attrFinders.put(attr, finders);
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)String.format("PIP attribute handler %1$s registered for the supported attribute %2$s", pipAttributeFinder.getClass(), attr));
                }
            }
        }
    }

    public EvaluationResult findAttribute(URI attributeType, URI attributeId, String issuer, URI category, EvaluationCtx context) {
        ArrayList<AttributeValue> attrBag = new ArrayList<AttributeValue>();
        List<PIPAttributeFinder> finders = null;
        if (StringUtils.isNotBlank((String)category.toString())) {
            finders = this.attrFinders.get(category.toString());
            if (log.isDebugEnabled()) {
                log.debug((Object)("No attribute designators defined for the category " + category.toString()));
            }
        }
        if (CollectionUtils.isEmpty(finders) && CollectionUtils.isEmpty(finders = this.attrFinders.get(attributeId.toString()))) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("No attribute designators defined for the attribute " + attributeId.toString()));
            }
            return new EvaluationResult((AttributeValue)BagAttribute.createEmptyBag((URI)attributeType));
        }
        try {
            for (PIPAttributeFinder pipAttributeFinder : finders) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Finding attributes with the PIP attribute handler %1$s", pipAttributeFinder.getClass()));
                }
                Set<String> attrs = null;
                String key = null;
                if (this.attributeFinderCache != null && !pipAttributeFinder.overrideDefaultCache()) {
                    key = "[" + attributeType.toString() + "][" + attributeId.toString() + "][" + category.toString() + "][" + this.encodeContext(context) + "]";
                    if (issuer != null) {
                        key = key + "[" + issuer + "]";
                    }
                    if (key != null) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Retrieving attributes from cache, tenantId: " + this.tenantId + ", key: " + key));
                        }
                        attrs = this.attributeFinderCache.getFromCache(this.tenantId, key);
                    }
                }
                if (attrs == null) {
                    attrs = pipAttributeFinder.getAttributeValues(attributeType, attributeId, category, issuer, context);
                    if (this.attributeFinderCache != null && key != null && !pipAttributeFinder.overrideDefaultCache()) {
                        this.attributeFinderCache.addToCache(this.tenantId, key, attrs);
                    }
                }
                if (attrs == null) continue;
                for (String attr : attrs) {
                    AttributeValue attribute = EntitlementUtil.getAttributeValue(attr, attributeType.toString());
                    attrBag.add(attribute);
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Attribute added to the attributeBag: '" + attr + "'"));
                }
            }
        }
        catch (ParsingException e) {
            log.error((Object)"Error while parsing attribute values from EvaluationCtx : ", (Throwable)e);
            ArrayList<String> code = new ArrayList<String>();
            code.add("urn:oasis:names:tc:xacml:1.0:status:missing-attribute");
            Status status = new Status(code, "Error while parsing attribute values from EvaluationCtx : " + e.getMessage());
            return new EvaluationResult(status);
        }
        catch (ParseException e) {
            e.printStackTrace();
            log.error((Object)"Error while parsing attribute values from EvaluationCtx : ", (Throwable)e);
            ArrayList<String> code = new ArrayList<String>();
            code.add("urn:oasis:names:tc:xacml:1.0:status:missing-attribute");
            Status status = new Status(code, "Error while parsing attribute values from EvaluationCtx : " + e.getMessage());
            return new EvaluationResult(status);
        }
        catch (URISyntaxException e) {
            log.error((Object)"Error while parsing attribute values from EvaluationCtx : ", (Throwable)e);
            ArrayList<String> code = new ArrayList<String>();
            code.add("urn:oasis:names:tc:xacml:1.0:status:missing-attribute");
            Status status = new Status(code, "Error while parsing attribute values from EvaluationCtx :" + e.getMessage());
            return new EvaluationResult(status);
        }
        catch (Exception e) {
            log.error((Object)"Error while retrieving attribute values from PIP  attribute finder : ", (Throwable)e);
            ArrayList<String> code = new ArrayList<String>();
            code.add("urn:oasis:names:tc:xacml:1.0:status:missing-attribute");
            Status status = new Status(code, "Error while retrieving attribute values from PIP attribute finder : " + e.getMessage());
            return new EvaluationResult(status);
        }
        return new EvaluationResult((AttributeValue)new BagAttribute(attributeType, attrBag));
    }

    public boolean isDesignatorSupported() {
        return true;
    }

    public Set getSupportedIds() {
        return null;
    }

    private void refreshAttributeFindersForNewAttributeId() throws Exception {
        Map<PIPAttributeFinder, Properties> designators = EntitlementServiceComponent.getEntitlementConfig().getDesignators();
        if (designators != null && !designators.isEmpty()) {
            Set<Map.Entry<PIPAttributeFinder, Properties>> attributeFinders = designators.entrySet();
            for (Map.Entry<PIPAttributeFinder, Properties> attributeFinder : attributeFinders) {
                attributeFinder.getKey().init(attributeFinder.getValue());
            }
            this.init();
        }
    }

    public void clearAttributeCache() {
        if (this.attributeFinderCache != null) {
            this.attributeFinderCache.clearCache();
            EntitlementEngine.getInstance().clearDecisionCache();
        }
    }

    private String encodeContext(EvaluationCtx evaluationCtx) throws TransformerException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        evaluationCtx.getRequestCtx().encode((OutputStream)stream);
        String rowContext = ((Object)stream).toString();
        String contextWithAttributeValues = rowContext + "][";
        StringBuilder builder = new StringBuilder();
        for (Attributes attributes : evaluationCtx.getRequestCtx().getAttributesSet()) {
            builder.append("<Attributes ").append(">");
            for (Attribute attribute : attributes.getAttributes()) {
                attribute.encode(builder);
            }
            builder.append("</Attributes>");
        }
        contextWithAttributeValues = contextWithAttributeValues + builder.toString();
        return contextWithAttributeValues;
    }
}

