/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.entitlement.pip;

import java.net.URI;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.wso2.balana.attr.AttributeValue;
import org.wso2.balana.attr.BagAttribute;
import org.wso2.balana.cond.EvaluationResult;
import org.wso2.balana.ctx.EvaluationCtx;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.identity.entitlement.EntitlementUtil;
import org.wso2.carbon.identity.entitlement.cache.EntitlementBaseCache;
import org.wso2.carbon.identity.entitlement.cache.IdentityCacheEntry;
import org.wso2.carbon.identity.entitlement.cache.IdentityCacheKey;
import org.wso2.carbon.identity.entitlement.internal.EntitlementServiceComponent;
import org.wso2.carbon.identity.entitlement.pip.CarbonAttributeFinder;
import org.wso2.carbon.identity.entitlement.pip.PIPResourceFinder;

public abstract class AbstractPIPResourceFinder
implements PIPResourceFinder {
    private static final Log log = LogFactory.getLog(CarbonAttributeFinder.class);
    private EntitlementBaseCache<IdentityCacheKey, IdentityCacheEntry> abstractResourceCache = null;
    private boolean isAbstractResourceCacheEnabled = false;
    private int tenantId;

    public abstract Set<String> findDescendantResources(String var1, String var2) throws Exception;

    @Override
    public Set<String> findDescendantResources(String parentResourceId, EvaluationCtx context) throws Exception {
        String environmentId = null;
        Set<String> resourceNames = null;
        NodeList children = context.getRequestRoot().getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            EvaluationResult environment;
            Node child = children.item(i);
            if (child == null || !"Environment".equals(child.getLocalName()) || child.getChildNodes() == null || child.getChildNodes().getLength() <= 0 || (environment = context.getAttribute(new URI("http://www.w3.org/2001/XMLSchema#string"), new URI("urn:oasis:names:tc:xacml:1.0:environment:environment-id"), null, new URI("urn:oasis:names:tc:xacml:3.0:attribute-category:environment"))) == null || environment.getAttributeValue() == null || !environment.getAttributeValue().isBag()) continue;
            BagAttribute attr = (BagAttribute)environment.getAttributeValue();
            environmentId = ((AttributeValue)attr.iterator().next()).encode();
        }
        if (this.isAbstractResourceCacheEnabled) {
            String key = "Descendants" + parentResourceId + (environmentId != null ? environmentId : "");
            this.tenantId = CarbonContext.getThreadLocalCarbonContext().getTenantId();
            IdentityCacheKey cacheKey = new IdentityCacheKey(this.tenantId, key);
            IdentityCacheEntry cacheEntry = this.abstractResourceCache.getValueFromCache(cacheKey);
            if (cacheEntry != null) {
                String[] values = cacheEntry.getCacheEntryArray();
                resourceNames = new HashSet<String>(Arrays.asList(values));
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Carbon Resource Cache Hit");
                }
            }
            if (resourceNames != null) {
                resourceNames = this.findDescendantResources(parentResourceId, environmentId);
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Carbon Resource Cache Miss");
                }
                if (resourceNames != null && !resourceNames.isEmpty()) {
                    cacheEntry = new IdentityCacheEntry(resourceNames.toArray(new String[resourceNames.size()]));
                    this.abstractResourceCache.addToCache(cacheKey, cacheEntry);
                }
            }
        } else {
            resourceNames = this.findDescendantResources(parentResourceId, environmentId);
        }
        return resourceNames;
    }

    @Override
    public boolean overrideDefaultCache() {
        Properties properties = EntitlementServiceComponent.getEntitlementConfig().getEngineProperties();
        if ("true".equals(properties.getProperty("PDP.ResourceCaching.Enable"))) {
            this.abstractResourceCache = EntitlementUtil.getCommonCache("PIP_ABSTRACT_RESOURCE_CACHE");
            this.isAbstractResourceCacheEnabled = true;
            return true;
        }
        return false;
    }

    @Override
    public void clearCache() {
        if (this.abstractResourceCache != null) {
            this.abstractResourceCache.clear();
        }
    }

    @Override
    public Set<String> findChildResources(String parentResourceId, EvaluationCtx context) throws Exception {
        return null;
    }
}

