/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.entitlement.pdp;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.wso2.balana.Balana;
import org.wso2.balana.PDP;
import org.wso2.balana.PDPConfig;
import org.wso2.balana.ParsingException;
import org.wso2.balana.ctx.AbstractRequestCtx;
import org.wso2.balana.ctx.RequestCtxFactory;
import org.wso2.balana.ctx.ResponseCtx;
import org.wso2.balana.finder.AttributeFinder;
import org.wso2.balana.finder.AttributeFinderModule;
import org.wso2.balana.finder.PolicyFinder;
import org.wso2.balana.finder.ResourceFinder;
import org.wso2.balana.finder.ResourceFinderModule;
import org.wso2.balana.finder.impl.CurrentEnvModule;
import org.wso2.balana.finder.impl.SelectorModule;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.entitlement.EntitlementException;
import org.wso2.carbon.identity.entitlement.EntitlementUtil;
import org.wso2.carbon.identity.entitlement.cache.DecisionCache;
import org.wso2.carbon.identity.entitlement.cache.PolicyCache;
import org.wso2.carbon.identity.entitlement.cache.SimpleDecisionCache;
import org.wso2.carbon.identity.entitlement.internal.EntitlementServiceComponent;
import org.wso2.carbon.identity.entitlement.pap.store.PAPPolicyFinder;
import org.wso2.carbon.identity.entitlement.pap.store.PAPPolicyStore;
import org.wso2.carbon.identity.entitlement.pap.store.PAPPolicyStoreReader;
import org.wso2.carbon.identity.entitlement.pip.CarbonAttributeFinder;
import org.wso2.carbon.identity.entitlement.pip.CarbonResourceFinder;
import org.wso2.carbon.identity.entitlement.pip.PIPExtension;
import org.wso2.carbon.identity.entitlement.policy.PolicyRequestBuilder;
import org.wso2.carbon.identity.entitlement.policy.finder.CarbonPolicyFinder;
import org.wso2.carbon.identity.entitlement.policy.search.PolicySearch;
import org.xml.sax.SAXException;

public class EntitlementEngine {
    private PolicyFinder papPolicyFinder;
    private CarbonAttributeFinder carbonAttributeFinder;
    private CarbonResourceFinder carbonResourceFinder;
    private PolicyFinder carbonPolicyFinder;
    private PolicySearch policySearch;
    private PDP pdp;
    private PDP pdpTest;
    private Balana balana;
    private int tenantId;
    private static final Object lock = new Object();
    private boolean pdpDecisionCacheEnable;
    private List<AttributeFinderModule> attributeModules = new ArrayList<AttributeFinderModule>();
    private List<ResourceFinderModule> resourceModules = new ArrayList<ResourceFinderModule>();
    private static EntitlementEngine entitlementEngine;
    private static final long DEFAULT_ENTITLEMENT_ENGINE_CACHING_INTERVAL = 900L;
    private static LoadingCache<Integer, EntitlementEngine> entitlementEngineLoadingCache;
    private DecisionCache decisionCache = null;
    private PolicyCache policyCache = null;
    private SimpleDecisionCache simpleDecisionCache = null;
    private static final Log log;

    public PolicyCache getPolicyCache() {
        return this.policyCache;
    }

    public void clearDecisionCache() {
        this.decisionCache.clear();
        this.simpleDecisionCache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EntitlementEngine getInstance() {
        EntitlementEngine entitleEngine;
        Integer tenantId = CarbonContext.getThreadLocalCarbonContext().getTenantId();
        if (tenantId == -1234) {
            if (entitlementEngine == null) {
                Object object = lock;
                synchronized (object) {
                    if (entitlementEngine == null) {
                        entitlementEngine = new EntitlementEngine(tenantId);
                    }
                }
            }
            return entitlementEngine;
        }
        if (entitlementEngineLoadingCache == null) {
            Object object = lock;
            synchronized (object) {
                if (entitlementEngineLoadingCache == null) {
                    entitlementEngineLoadingCache = CacheBuilder.newBuilder().weakValues().expireAfterAccess(EntitlementEngine.getCacheInterval(), TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<Integer, EntitlementEngine>(){

                        public EntitlementEngine load(Integer key) {
                            return new EntitlementEngine(key);
                        }
                    });
                }
            }
        }
        if ((entitleEngine = (EntitlementEngine)entitlementEngineLoadingCache.getIfPresent((Object)tenantId)) == null) {
            Object object = lock;
            synchronized (object) {
                entitleEngine = (EntitlementEngine)entitlementEngineLoadingCache.getIfPresent((Object)tenantId);
                if (entitleEngine == null) {
                    entitlementEngineLoadingCache.put((Object)tenantId, (Object)new EntitlementEngine(tenantId));
                }
            }
        }
        try {
            entitleEngine = (EntitlementEngine)entitlementEngineLoadingCache.get((Object)tenantId);
        }
        catch (ExecutionException e) {
            log.error((Object)("Error while getting the entitle engine for the tenant : " + tenantId));
        }
        return entitleEngine;
    }

    private static long getCacheInterval() {
        Properties properties = EntitlementServiceComponent.getEntitlementConfig().getEngineProperties();
        String engineCachingInterval = properties.getProperty("Entitlement.Engine.CachingInterval");
        long entitlementEngineCachingInterval = 900L;
        if (engineCachingInterval != null) {
            try {
                entitlementEngineCachingInterval = Long.parseLong(engineCachingInterval);
            }
            catch (NumberFormatException e) {
                log.warn((Object)("Invalid value for Entitlement.Engine.CachingInterval. Using default value " + entitlementEngineCachingInterval + " seconds."));
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("Entitlement.Engine.CachingInterval not set. Using default value " + entitlementEngineCachingInterval + " seconds."));
        }
        return entitlementEngineCachingInterval;
    }

    private EntitlementEngine(int tenantId) {
        String cacheInterval;
        boolean isPDP = Boolean.parseBoolean((String)EntitlementServiceComponent.getEntitlementConfig().getEngineProperties().get("PDP.Enable"));
        boolean isPAP = Boolean.parseBoolean((String)EntitlementServiceComponent.getEntitlementConfig().getEngineProperties().get("PAP.Enable"));
        boolean pdpMultipleDecision = Boolean.parseBoolean((String)EntitlementServiceComponent.getEntitlementConfig().getEngineProperties().get("PDP.Multiple.Decision.Profile.Enable"));
        if (!isPAP && !isPDP) {
            isPAP = true;
        }
        this.balana = Balana.getInstance();
        this.setUpAttributeFinders();
        this.setUpResourceFinders();
        this.setUPPolicyFinder();
        this.tenantId = tenantId;
        Properties properties = EntitlementServiceComponent.getEntitlementConfig().getEngineProperties();
        this.pdpDecisionCacheEnable = Boolean.parseBoolean(properties.getProperty("PDP.DecisionCaching.Enable"));
        int pdpDecisionCachingInterval = -1;
        if (this.pdpDecisionCacheEnable && (cacheInterval = properties.getProperty("PDP.DecisionCaching.CachingInterval")) != null) {
            try {
                pdpDecisionCachingInterval = Integer.parseInt(cacheInterval.trim());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        int pdpPolicyCachingInterval = -1;
        String policyCacheInterval = properties.getProperty("PDP.PolicyCaching.CachingInterval");
        if (policyCacheInterval != null) {
            try {
                pdpPolicyCachingInterval = Integer.parseInt(policyCacheInterval.trim());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.decisionCache = new DecisionCache(pdpDecisionCachingInterval);
        this.simpleDecisionCache = new SimpleDecisionCache(pdpDecisionCachingInterval);
        this.policyCache = new PolicyCache(pdpPolicyCachingInterval);
        this.policySearch = new PolicySearch(this.pdpDecisionCacheEnable, pdpDecisionCachingInterval);
        if (isPAP) {
            PolicyFinder policyFinder = new PolicyFinder();
            HashSet<PAPPolicyFinder> policyModules = new HashSet<PAPPolicyFinder>();
            PAPPolicyFinder papPolicyFinder = new PAPPolicyFinder(new PAPPolicyStoreReader(new PAPPolicyStore()));
            policyModules.add(papPolicyFinder);
            policyFinder.setModules(policyModules);
            this.papPolicyFinder = policyFinder;
            AttributeFinder attributeFinder = new AttributeFinder();
            attributeFinder.setModules(this.attributeModules);
            ResourceFinder resourceFinder = new ResourceFinder();
            resourceFinder.setModules(this.resourceModules);
            PDPConfig pdpConfig = new PDPConfig(attributeFinder, policyFinder, resourceFinder, true);
            this.pdpTest = new PDP(pdpConfig);
        }
        if (isPDP) {
            AttributeFinder attributeFinder = new AttributeFinder();
            attributeFinder.setModules(this.attributeModules);
            ResourceFinder resourceFinder = new ResourceFinder();
            resourceFinder.setModules(this.resourceModules);
            PDPConfig pdpConfig = new PDPConfig(attributeFinder, this.carbonPolicyFinder, resourceFinder, pdpMultipleDecision);
            this.pdp = new PDP(pdpConfig);
        }
    }

    public String test(String xacmlRequest) {
        if (log.isDebugEnabled() && IdentityUtil.isTokenLoggable((String)"XACML_Request")) {
            log.debug((Object)("XACML Request : " + xacmlRequest));
        }
        String xacmlResponse = this.pdpTest.evaluate(xacmlRequest);
        if (log.isDebugEnabled() && IdentityUtil.isTokenLoggable((String)"XACML_Response")) {
            log.debug((Object)("XACML Response : " + xacmlResponse));
        }
        return xacmlResponse;
    }

    public String evaluate(String xacmlRequest) throws EntitlementException, ParsingException {
        String xacmlResponse;
        if (log.isDebugEnabled() && IdentityUtil.isTokenLoggable((String)"XACML_Request")) {
            log.debug((Object)("XACML Request : " + xacmlRequest));
        }
        if ((xacmlResponse = (String)this.getFromCache(xacmlRequest, false)) != null) {
            if (log.isDebugEnabled() && IdentityUtil.isTokenLoggable((String)"XACML_Response")) {
                log.debug((Object)("XACML Response : " + xacmlResponse));
            }
            return xacmlResponse;
        }
        Map<PIPExtension, Properties> extensions = EntitlementServiceComponent.getEntitlementConfig().getExtensions();
        if (extensions != null && !extensions.isEmpty()) {
            PolicyRequestBuilder policyRequestBuilder = new PolicyRequestBuilder();
            Element xacmlRequestElement = policyRequestBuilder.getXacmlRequest(xacmlRequest);
            AbstractRequestCtx requestCtx = RequestCtxFactory.getFactory().getRequestCtx((Node)xacmlRequestElement);
            Set<PIPExtension> pipExtensions = extensions.keySet();
            for (PIPExtension pipExtension : pipExtensions) {
                pipExtension.update(requestCtx);
            }
            ResponseCtx responseCtx = this.pdp.evaluate(requestCtx);
            xacmlResponse = responseCtx.encode();
        } else {
            xacmlResponse = this.pdp.evaluate(xacmlRequest);
        }
        this.addToCache(xacmlRequest, xacmlResponse, false);
        if (log.isDebugEnabled() && IdentityUtil.isTokenLoggable((String)"XACML_Response")) {
            log.debug((Object)("XACML Response : " + xacmlResponse));
        }
        return xacmlResponse;
    }

    public ResponseCtx evaluateReturnResponseCtx(String xacmlRequest) throws EntitlementException, ParsingException, ParserConfigurationException, SAXException, IOException {
        ResponseCtx responseCtx;
        String xacmlResponse;
        if (log.isDebugEnabled() && IdentityUtil.isTokenLoggable((String)"XACML_Request")) {
            log.debug((Object)("XACML Request : " + xacmlRequest));
        }
        if ((xacmlResponse = (String)this.getFromCache(xacmlRequest, false)) != null) {
            if (log.isDebugEnabled() && IdentityUtil.isTokenLoggable((String)"XACML_Response")) {
                log.debug((Object)("XACML Response : " + xacmlResponse));
            }
            DocumentBuilderFactory documentBuilderFactory = IdentityUtil.getSecuredDocumentBuilderFactory();
            Element node = documentBuilderFactory.newDocumentBuilder().parse(new ByteArrayInputStream(xacmlResponse.getBytes())).getDocumentElement();
            return ResponseCtx.getInstance((Node)node);
        }
        Map<PIPExtension, Properties> extensions = EntitlementServiceComponent.getEntitlementConfig().getExtensions();
        if (extensions != null && !extensions.isEmpty()) {
            PolicyRequestBuilder policyRequestBuilder = new PolicyRequestBuilder();
            Element xacmlRequestElement = policyRequestBuilder.getXacmlRequest(xacmlRequest);
            AbstractRequestCtx requestCtx = RequestCtxFactory.getFactory().getRequestCtx((Node)xacmlRequestElement);
            Set<PIPExtension> pipExtensions = extensions.keySet();
            for (PIPExtension pipExtension : pipExtensions) {
                pipExtension.update(requestCtx);
            }
            responseCtx = this.pdp.evaluate(requestCtx);
        } else {
            responseCtx = this.pdp.evaluateReturnResponseCtx(xacmlRequest);
        }
        xacmlResponse = responseCtx.encode();
        this.addToCache(xacmlRequest, xacmlResponse, false);
        if (log.isDebugEnabled() && IdentityUtil.isTokenLoggable((String)"XACML_Response")) {
            log.debug((Object)("XACML Response : " + xacmlResponse));
        }
        return responseCtx;
    }

    public ResponseCtx evaluateByContext(AbstractRequestCtx requestCtx) {
        return this.pdp.evaluate(requestCtx);
    }

    public ResponseCtx evaluate(AbstractRequestCtx requestCtx, String xacmlRequest) {
        ResponseCtx xacmlResponse;
        if (log.isDebugEnabled() && IdentityUtil.isTokenLoggable((String)"XACML_Request")) {
            log.debug((Object)("XACML Request : " + xacmlRequest));
        }
        if ((xacmlResponse = (ResponseCtx)this.getFromCache(xacmlRequest, false)) != null) {
            if (log.isDebugEnabled() && IdentityUtil.isTokenLoggable((String)"XACML_Response")) {
                log.debug((Object)("XACML Response : " + xacmlResponse));
            }
            return xacmlResponse;
        }
        xacmlResponse = this.pdp.evaluate(requestCtx);
        this.addToCache(xacmlRequest, xacmlResponse, false);
        if (log.isDebugEnabled() && IdentityUtil.isTokenLoggable((String)"XACML_Response")) {
            log.debug((Object)("XACML Response : " + xacmlResponse));
        }
        return xacmlResponse;
    }

    public String evaluate(String subject, String resource, String action, String[] environment) throws Exception {
        String request;
        String response;
        String environmentValue = null;
        if (environment != null && environment.length > 0) {
            environmentValue = environment[0];
        }
        if ((response = (String)this.getFromCache(request = (subject != null ? subject : "") + (resource != null ? resource : "") + (action != null ? action : "") + (environmentValue != null ? environmentValue : ""), true)) != null) {
            if (log.isDebugEnabled() && IdentityUtil.isTokenLoggable((String)"XACML_Request")) {
                log.debug((Object)("XACML Request : " + EntitlementUtil.createSimpleXACMLRequest(subject, resource, action, environmentValue)));
            }
            if (log.isDebugEnabled() && IdentityUtil.isTokenLoggable((String)"XACML_Response")) {
                log.debug((Object)("XACML Response : " + response));
            }
            return response;
        }
        String requestAsString = EntitlementUtil.createSimpleXACMLRequest(subject, resource, action, environmentValue);
        if (log.isDebugEnabled() && IdentityUtil.isTokenLoggable((String)"XACML_Request")) {
            log.debug((Object)("XACML Request : " + requestAsString));
        }
        response = this.pdp.evaluate(requestAsString);
        this.addToCache(request, response, true);
        if (log.isDebugEnabled() && IdentityUtil.isTokenLoggable((String)"XACML_Response")) {
            log.debug((Object)("XACML Response : " + response));
        }
        return response;
    }

    public PolicyFinder getPapPolicyFinder() {
        return this.papPolicyFinder;
    }

    public CarbonAttributeFinder getCarbonAttributeFinder() {
        return this.carbonAttributeFinder;
    }

    public CarbonResourceFinder getCarbonResourceFinder() {
        return this.carbonResourceFinder;
    }

    public PolicyFinder getCarbonPolicyFinder() {
        return this.carbonPolicyFinder;
    }

    private Object getFromCache(String request, boolean simpleCache) {
        if (this.pdpDecisionCacheEnable) {
            String tenantRequest = this.tenantId + "+" + request;
            if (EntitlementEngine.getInstance().getPolicyCache().isInvalidate()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Policy Cache is invalidated. Clearing the decision cache.");
                }
                this.decisionCache.clear();
                this.simpleDecisionCache.clear();
                return null;
            }
            Object decision = simpleCache ? this.simpleDecisionCache.getFromCache(tenantRequest) : this.decisionCache.getFromCache(tenantRequest);
            return decision;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"PDP Decision Caching is disabled");
        }
        return null;
    }

    private void addToCache(String request, Object response, boolean simpleCache) {
        if (this.pdpDecisionCacheEnable) {
            String tenantRequest = this.tenantId + "+" + request;
            if (simpleCache) {
                this.simpleDecisionCache.addToCache(tenantRequest, response);
            } else {
                this.decisionCache.addToCache(tenantRequest, response);
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"PDP Decision Caching is disabled");
        }
    }

    private void setUpAttributeFinders() {
        this.carbonAttributeFinder = new CarbonAttributeFinder(this.tenantId);
        this.carbonAttributeFinder.init();
        CurrentEnvModule envAttributeModule = new CurrentEnvModule();
        SelectorModule selectorAttributeModule = new SelectorModule();
        this.attributeModules.add(this.carbonAttributeFinder);
        this.attributeModules.add((AttributeFinderModule)envAttributeModule);
        this.attributeModules.add((AttributeFinderModule)selectorAttributeModule);
        for (AttributeFinderModule module : this.balana.getPdpConfig().getAttributeFinder().getModules()) {
            if (module instanceof CurrentEnvModule || module instanceof SelectorModule) continue;
            this.attributeModules.add(module);
        }
    }

    private void setUpResourceFinders() {
        this.carbonResourceFinder = new CarbonResourceFinder(this.tenantId);
        this.carbonResourceFinder.init();
        this.resourceModules.add(this.carbonResourceFinder);
        for (ResourceFinderModule module : this.balana.getPdpConfig().getResourceFinder().getModules()) {
            this.resourceModules.add(module);
        }
    }

    public PolicySearch getPolicySearch() {
        return this.policySearch;
    }

    private void setUPPolicyFinder() {
        this.carbonPolicyFinder = new PolicyFinder();
        HashSet<CarbonPolicyFinder> policyModules = new HashSet<CarbonPolicyFinder>();
        CarbonPolicyFinder tmpCarbonPolicyFinder = new CarbonPolicyFinder();
        policyModules.add(tmpCarbonPolicyFinder);
        this.carbonPolicyFinder.setModules(policyModules);
        this.carbonPolicyFinder.init();
    }

    public void resetCacheInvalidateState() {
        if (this.policyCache != null) {
            this.policyCache.resetCacheInvalidateState();
        } else {
            log.error((Object)"Policy cache is null - Unable to reset cache invalidate state.");
        }
    }

    public void invalidatePolicyCache() {
        if (this.policyCache != null) {
            this.policyCache.invalidateCache();
        } else {
            log.error((Object)"Policy cache is null - Unable to invalidate cache.");
        }
    }

    static {
        log = LogFactory.getLog(EntitlementEngine.class);
    }
}

