/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.entitlement.pap.store;

import java.nio.charset.Charset;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.balana.AbstractPolicy;
import org.wso2.balana.finder.PolicyFinder;
import org.wso2.carbon.identity.entitlement.EntitlementException;
import org.wso2.carbon.identity.entitlement.dto.PolicyDTO;
import org.wso2.carbon.identity.entitlement.pap.PAPPolicyReader;
import org.wso2.carbon.identity.entitlement.pap.store.PAPPolicyStore;
import org.wso2.carbon.identity.entitlement.policy.PolicyAttributeBuilder;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;

public class PAPPolicyStoreReader {
    private static Log log = LogFactory.getLog(PAPPolicyStoreReader.class);
    private PAPPolicyStore store;

    public PAPPolicyStoreReader(PAPPolicyStore store) {
        this.store = store;
    }

    public synchronized AbstractPolicy readPolicy(String policyId, PolicyFinder finder) throws EntitlementException {
        Resource resource = this.store.getPolicy(policyId, "/repository/identity/entitlement/policy/pap/");
        if (resource != null) {
            try {
                String policy = new String((byte[])resource.getContent(), Charset.forName("UTF-8"));
                return PAPPolicyReader.getInstance(null).getPolicy(policy);
            }
            catch (RegistryException e) {
                log.error((Object)"Error while parsing entitlement policy", (Throwable)e);
                throw new EntitlementException("Error while loading entitlement policy");
            }
        }
        return null;
    }

    public PolicyDTO[] readAllLightPolicyDTOs() throws EntitlementException {
        String[] resources = null;
        resources = this.store.getAllPolicyIds();
        if (resources == null) {
            return new PolicyDTO[0];
        }
        ArrayList<PolicyDTO> policyDTOList = new ArrayList<PolicyDTO>();
        for (String resource : resources) {
            PolicyDTO policyDTO = this.readLightPolicyDTO(resource);
            policyDTOList.add(policyDTO);
        }
        return policyDTOList.toArray(new PolicyDTO[policyDTOList.size()]);
    }

    public PolicyDTO readPolicyDTO(String policyId) throws EntitlementException {
        Resource resource = null;
        PolicyDTO dto = null;
        try {
            String policySetReferences;
            String policyReferences;
            String lastModifiedUser;
            String lastModifiedTime;
            resource = this.store.getPolicy(policyId, "/repository/identity/entitlement/policy/pap/");
            if (resource == null) {
                log.error((Object)("Policy does not exist in the system with id " + policyId));
                throw new EntitlementException("Policy does not exist in the system with id " + policyId);
            }
            dto = new PolicyDTO();
            dto.setPolicyId(policyId);
            dto.setPolicy(new String((byte[])resource.getContent(), Charset.forName("UTF-8")));
            dto.setActive(Boolean.parseBoolean(resource.getProperty("isActive")));
            String policyOrder = resource.getProperty("policyOrder");
            if (policyOrder != null) {
                dto.setPolicyOrder(Integer.parseInt(policyOrder));
            } else {
                dto.setPolicyOrder(0);
            }
            dto.setPolicyType(resource.getProperty("policyType"));
            String version = resource.getProperty("version");
            if (version != null) {
                dto.setVersion(version);
            }
            if ((lastModifiedTime = resource.getProperty("lastModifiedTime")) != null) {
                dto.setLastModifiedTime(lastModifiedTime);
            }
            if ((lastModifiedUser = resource.getProperty("lastModifiedUser")) != null) {
                dto.setLastModifiedUser(lastModifiedUser);
            }
            if ((policyReferences = resource.getProperty("policyIdReferences")) != null && policyReferences.trim().length() > 0) {
                dto.setPolicyIdReferences(policyReferences.split(","));
            }
            if ((policySetReferences = resource.getProperty("policySetIdReferences")) != null && policySetReferences.trim().length() > 0) {
                dto.setPolicySetIdReferences(policySetReferences.split(","));
            }
            dto.setPolicyEditor(resource.getProperty("policyEditor"));
            String basicPolicyEditorMetaDataAmount = resource.getProperty("NoOfBasicPolicyEditorMetaData");
            if (basicPolicyEditorMetaDataAmount != null) {
                int amount = Integer.parseInt(basicPolicyEditorMetaDataAmount);
                String[] basicPolicyEditorMetaData = new String[amount];
                for (int i = 0; i < amount; ++i) {
                    basicPolicyEditorMetaData[i] = resource.getProperty("basicPolicyEditorMetaData" + i);
                }
                dto.setPolicyEditorData(basicPolicyEditorMetaData);
            }
            PolicyAttributeBuilder policyAttributeBuilder = new PolicyAttributeBuilder();
            dto.setAttributeDTOs(policyAttributeBuilder.getPolicyMetaDataFromRegistryProperties(resource.getProperties()));
            return dto;
        }
        catch (RegistryException e) {
            log.error((Object)("Error while loading entitlement policy " + policyId + " from PAP policy store"), (Throwable)e);
            throw new EntitlementException("Error while loading entitlement policy " + policyId + " from PAP policy store");
        }
    }

    public boolean isExistPolicy(String policyId) {
        Resource resource = null;
        try {
            resource = this.store.getPolicy(policyId, "/repository/identity/entitlement/policy/pap/");
            if (resource != null) {
                return true;
            }
        }
        catch (EntitlementException entitlementException) {
            // empty catch block
        }
        return false;
    }

    public PolicyDTO readLightPolicyDTO(String policyId) throws EntitlementException {
        String policySetReferences;
        String lastModifiedUser;
        String lastModifiedTime;
        Resource resource = null;
        PolicyDTO dto = null;
        resource = this.store.getPolicy(policyId, "/repository/identity/entitlement/policy/pap/");
        if (resource == null) {
            return null;
        }
        dto = new PolicyDTO();
        dto.setPolicyId(policyId);
        String version = resource.getProperty("version");
        if (version != null) {
            dto.setVersion(version);
        }
        if ((lastModifiedTime = resource.getProperty("lastModifiedTime")) != null) {
            dto.setLastModifiedTime(lastModifiedTime);
        }
        if ((lastModifiedUser = resource.getProperty("lastModifiedUser")) != null) {
            dto.setLastModifiedUser(lastModifiedUser);
        }
        dto.setActive(Boolean.parseBoolean(resource.getProperty("isActive")));
        String policyOrder = resource.getProperty("policyOrder");
        if (policyOrder != null) {
            dto.setPolicyOrder(Integer.parseInt(policyOrder));
        } else {
            dto.setPolicyOrder(0);
        }
        dto.setPolicyType(resource.getProperty("policyType"));
        String policyReferences = resource.getProperty("policyIdReferences");
        if (policyReferences != null && policyReferences.trim().length() > 0) {
            dto.setPolicyIdReferences(policyReferences.split(","));
        }
        if ((policySetReferences = resource.getProperty("policySetIdReferences")) != null && policySetReferences.trim().length() > 0) {
            dto.setPolicySetIdReferences(policySetReferences.split(","));
        }
        dto.setPolicyEditor(resource.getProperty("policyEditor"));
        return dto;
    }

    public PolicyDTO readMetaDataPolicyDTO(String policyId) throws EntitlementException {
        String policySetReferences;
        String lastModifiedUser;
        String lastModifiedTime;
        Resource resource = null;
        PolicyDTO dto = null;
        resource = this.store.getPolicy(policyId, "/repository/identity/entitlement/policy/pap/");
        if (resource == null) {
            return null;
        }
        dto = new PolicyDTO();
        dto.setPolicyId(policyId);
        dto.setActive(Boolean.parseBoolean(resource.getProperty("isActive")));
        String policyOrder = resource.getProperty("policyOrder");
        if (policyOrder != null) {
            dto.setPolicyOrder(Integer.parseInt(policyOrder));
        } else {
            dto.setPolicyOrder(0);
        }
        String version = resource.getProperty("version");
        if (version != null) {
            dto.setVersion(version);
        }
        if ((lastModifiedTime = resource.getProperty("lastModifiedTime")) != null) {
            dto.setLastModifiedTime(lastModifiedTime);
        }
        if ((lastModifiedUser = resource.getProperty("lastModifiedUser")) != null) {
            dto.setLastModifiedUser(lastModifiedUser);
        }
        dto.setPolicyType(resource.getProperty("policyType"));
        String policyReferences = resource.getProperty("policyIdReferences");
        if (policyReferences != null && policyReferences.trim().length() > 0) {
            dto.setPolicyIdReferences(policyReferences.split(","));
        }
        if ((policySetReferences = resource.getProperty("policySetIdReferences")) != null && policySetReferences.trim().length() > 0) {
            dto.setPolicySetIdReferences(policySetReferences.split(","));
        }
        dto.setPolicyEditor(resource.getProperty("policyEditor"));
        String basicPolicyEditorMetaDataAmount = resource.getProperty("NoOfBasicPolicyEditorMetaData");
        if (basicPolicyEditorMetaDataAmount != null) {
            int amount = Integer.parseInt(basicPolicyEditorMetaDataAmount);
            String[] basicPolicyEditorMetaData = new String[amount];
            for (int i = 0; i < amount; ++i) {
                basicPolicyEditorMetaData[i] = resource.getProperty("basicPolicyEditorMetaData" + i);
            }
            dto.setPolicyEditorData(basicPolicyEditorMetaData);
        }
        PolicyAttributeBuilder policyAttributeBuilder = new PolicyAttributeBuilder();
        dto.setAttributeDTOs(policyAttributeBuilder.getPolicyMetaDataFromRegistryProperties(resource.getProperties()));
        return dto;
    }

    public PolicyDTO readPolicyDTO(Resource resource) throws EntitlementException {
        String policy = null;
        String policyId = null;
        AbstractPolicy absPolicy = null;
        PolicyDTO dto = null;
        try {
            String policySetReferences;
            String lastModifiedUser;
            String lastModifiedTime;
            policy = new String((byte[])resource.getContent(), Charset.forName("UTF-8"));
            absPolicy = PAPPolicyReader.getInstance(null).getPolicy(policy);
            policyId = absPolicy.getId().toASCIIString();
            dto = new PolicyDTO();
            dto.setPolicyId(policyId);
            dto.setPolicy(policy);
            dto.setActive(Boolean.parseBoolean(resource.getProperty("isActive")));
            String policyOrder = resource.getProperty("policyOrder");
            if (policyOrder != null) {
                dto.setPolicyOrder(Integer.parseInt(policyOrder));
            } else {
                dto.setPolicyOrder(0);
            }
            String version = resource.getProperty("version");
            if (version != null) {
                dto.setVersion(version);
            }
            if ((lastModifiedTime = resource.getProperty("lastModifiedTime")) != null) {
                dto.setLastModifiedTime(lastModifiedTime);
            }
            if ((lastModifiedUser = resource.getProperty("lastModifiedUser")) != null) {
                dto.setLastModifiedUser(lastModifiedUser);
            }
            dto.setPolicyType(resource.getProperty("policyType"));
            String policyReferences = resource.getProperty("policyIdReferences");
            if (policyReferences != null && policyReferences.trim().length() > 0) {
                dto.setPolicyIdReferences(policyReferences.split(","));
            }
            if ((policySetReferences = resource.getProperty("policySetIdReferences")) != null && policySetReferences.trim().length() > 0) {
                dto.setPolicySetIdReferences(policySetReferences.split(","));
            }
            dto.setPolicyEditor(resource.getProperty("policyEditor"));
            String basicPolicyEditorMetaDataAmount = resource.getProperty("NoOfBasicPolicyEditorMetaData");
            if (basicPolicyEditorMetaDataAmount != null) {
                int amount = Integer.parseInt(basicPolicyEditorMetaDataAmount);
                String[] basicPolicyEditorMetaData = new String[amount];
                for (int i = 0; i < amount; ++i) {
                    basicPolicyEditorMetaData[i] = resource.getProperty("basicPolicyEditorMetaData" + i);
                }
                dto.setPolicyEditorData(basicPolicyEditorMetaData);
            }
            PolicyAttributeBuilder policyAttributeBuilder = new PolicyAttributeBuilder();
            dto.setAttributeDTOs(policyAttributeBuilder.getPolicyMetaDataFromRegistryProperties(resource.getProperties()));
            return dto;
        }
        catch (RegistryException e) {
            log.error((Object)("Error while loading entitlement policy " + policyId + " from PAP policy store"), (Throwable)e);
            throw new EntitlementException("Error while loading entitlement policy " + policyId + " from PAP policy store");
        }
    }
}

